/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.POST;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.domain.ZoneProperties;
import org.jclouds.ultradns.ws.filters.SOAPWrapWithPasswordAuth;
import org.jclouds.ultradns.ws.xml.ZoneListHandler;
import org.jclouds.ultradns.ws.xml.ZonePropertiesHandler;

@RequestFilters(value={SOAPWrapWithPasswordAuth.class})
@VirtualHost
public interface ZoneApi {
    @Named(value="createPrimaryZone")
    @POST
    @Payload(value="<v01:createPrimaryZone><transactionID /><accountId>{accountId}</accountId><zoneName>{zoneName}</zoneName><forceImport>false</forceImport></v01:createPrimaryZone>")
    public void createInAccount(@PayloadParam(value="zoneName") String var1, @PayloadParam(value="accountId") String var2) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="getGeneralPropertiesForZone")
    @POST
    @XMLResponseParser(value=ZonePropertiesHandler.class)
    @Payload(value="<v01:getGeneralPropertiesForZone><zoneName>{zoneName}</zoneName></v01:getGeneralPropertiesForZone>")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ZoneProperties get(@PayloadParam(value="zoneName") String var1);

    @Named(value="getZonesOfAccount")
    @POST
    @XMLResponseParser(value=ZoneListHandler.class)
    @Payload(value="<v01:getZonesOfAccount><accountId>{accountId}</accountId><zoneType>all</zoneType></v01:getZonesOfAccount>")
    public FluentIterable<Zone> listByAccount(@PayloadParam(value="accountId") String var1);

    @Named(value="getZonesOfAccount")
    @POST
    @XMLResponseParser(value=ZoneListHandler.class)
    @Payload(value="<v01:getZonesOfAccount><accountId>{accountId}</accountId><zoneType>{zoneType}</zoneType></v01:getZonesOfAccount>")
    public FluentIterable<Zone> listByAccountAndType(@PayloadParam(value="accountId") String var1, @PayloadParam(value="zoneType") Zone.Type var2) throws ResourceNotFoundException;

    @Named(value="deleteZone")
    @POST
    @Payload(value="<v01:deleteZone><transactionID /><zoneName>{zoneName}</zoneName></v01:deleteZone>")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PayloadParam(value="zoneName") String var1);
}

