/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public final class UltraDNSWSError {
    private final int code;
    private final Optional<String> description;

    public static UltraDNSWSError fromCodeAndDescription(int code, Optional<String> description) {
        return new UltraDNSWSError(code, description);
    }

    private UltraDNSWSError(int code, Optional<String> description) {
        this.code = code;
        this.description = (Optional)Preconditions.checkNotNull(description, (String)"description for code %s", (Object[])new Object[]{code});
    }

    public int getCode() {
        return this.code;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.code, this.description});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UltraDNSWSError that = (UltraDNSWSError)UltraDNSWSError.class.cast(obj);
        return Objects.equal((Object)this.code, (Object)that.code) && Objects.equal(this.description, that.description);
    }

    public String toString() {
        return this.description.isPresent() ? String.format("Error %s: %s", this.code, this.description.get()) : String.format("Error %s", this.code);
    }
}

