/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.inject.Injector;
import java.io.Closeable;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.internal.DeleteAllKeysInList;
import org.jclouds.util.Closeables2;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="DeleteAllKeysInListTest", singleThreaded=true)
public class DeleteAllKeysInListTest {
    private BlobStore blobstore;
    private DeleteAllKeysInList deleter;
    private static final String containerName = "container";
    private static final String directoryName = "directory";

    @BeforeMethod
    void setupBlobStore() {
        Injector injector = ContextBuilder.newBuilder((String)"transient").buildInjector();
        this.blobstore = (BlobStore)injector.getInstance(BlobStore.class);
        this.deleter = (DeleteAllKeysInList)injector.getInstance(DeleteAllKeysInList.class);
        this.createDataSet();
    }

    @AfterMethod
    void close() {
        Closeables2.closeQuietly((Closeable)this.blobstore.getContext());
    }

    public void testExecuteWithoutOptionsClearsRecursively() {
        this.deleter.execute(containerName);
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)0L);
    }

    public void testExecuteRecursive() {
        this.deleter.execute(containerName, ListContainerOptions.Builder.recursive());
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)0L);
    }

    public void testExecuteNonRecursive() {
        this.deleter.execute(containerName, (ListContainerOptions)ListContainerOptions.NONE);
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)2222L);
    }

    public void testExecuteInDirectory() {
        this.deleter.execute(containerName, ListContainerOptions.Builder.inDirectory((String)directoryName));
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)1111L);
    }

    private void createDataSet() {
        int i;
        String blobNameFmt = "blob-%d";
        String directoryBlobNameFmt = "%s/blob-%d";
        this.blobstore.createContainerInLocation(null, containerName);
        for (i = 0; i < 1111; ++i) {
            String blobName = String.format(blobNameFmt, i);
            this.blobstore.putBlob(containerName, this.blobstore.blobBuilder(blobName).payload(blobName).build());
        }
        for (i = 0; i < 2222; ++i) {
            String directoryBlobName = String.format(directoryBlobNameFmt, directoryName, i);
            this.blobstore.putBlob(containerName, this.blobstore.blobBuilder(directoryBlobName).payload(directoryBlobName).build());
        }
        Assert.assertEquals((long)this.blobstore.countBlobs(containerName), (long)3333L);
    }
}

