/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.io.ContentMetadata;

@Beta
public final class CopyOptions {
    public static final CopyOptions NONE = CopyOptions.builder().build();
    private final Optional<ContentMetadata> contentMetadata;
    private final Optional<Map<String, String>> userMetadata;

    private CopyOptions(Builder builder) {
        this.contentMetadata = Optional.fromNullable((Object)builder.contentMetadata);
        this.userMetadata = Optional.fromNullable(builder.userMetadata);
    }

    public Optional<ContentMetadata> getContentMetadata() {
        return this.contentMetadata;
    }

    public Optional<Map<String, String>> getUserMetadata() {
        return this.userMetadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        ContentMetadata contentMetadata;
        Map<String, String> userMetadata;

        Builder() {
        }

        public Builder contentMetadata(ContentMetadata contentMetadata) {
            this.contentMetadata = (ContentMetadata)Preconditions.checkNotNull((Object)contentMetadata, (Object)"contentMetadata");
            return this;
        }

        public Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = ImmutableMap.copyOf(userMetadata);
            return this;
        }

        public CopyOptions build() {
            return new CopyOptions(this);
        }
    }
}

