/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.InputSupplier;
import com.google.common.net.HostAndPort;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.compute.config.AdminAccessConfiguration;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.compute.util.OpenSocketFinder;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.io.Payload;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.ssh.SshClient;
import org.jclouds.util.Predicates2;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="StubComputeServiceIntegrationTest")
public class StubComputeServiceIntegrationTest
extends BaseComputeServiceLiveTest {
    private static final ExecResponse EXEC_GOOD = new ExecResponse("", "", 0);
    private static final ExecResponse EXEC_BAD = new ExecResponse("", "", 1);
    private static final ExecResponse EXEC_RC_GOOD = new ExecResponse("0", "", 0);

    public StubComputeServiceIntegrationTest() {
        this.provider = "stub";
    }

    @Override
    public void testCorrectAuthException() throws Exception {
    }

    @Override
    protected void buildSocketTester() {
        SocketOpen socketOpen = (SocketOpen)EasyMock.createMock(SocketOpen.class);
        EasyMock.expect((Object)socketOpen.apply((Object)HostAndPort.fromParts((String)"144.175.1.1", (int)22))).andReturn((Object)true).times(5);
        EasyMock.replay((Object[])new Object[]{socketOpen});
        this.socketTester = Predicates2.retry((Predicate)socketOpen, (long)1L, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.openSocketFinder = new OpenSocketFinder(){

            public HostAndPort findOpenSocketOnNode(NodeMetadata node, int port, long timeoutValue, TimeUnit timeUnits) {
                return HostAndPort.fromParts((String)"144.175.1.1", (int)8080);
            }
        };
    }

    @Override
    protected void checkHttpGet(NodeMetadata node) {
    }

    @Override
    protected Module getSshModule() {
        return new AbstractModule(){

            protected void configure() {
                this.bind(AdminAccessConfiguration.class).toInstance((Object)new AdminAccessConfiguration(){

                    public Supplier<String> defaultAdminUsername() {
                        return Suppliers.ofInstance((Object)"defaultAdminUsername");
                    }

                    public Supplier<Map<String, String>> defaultAdminSshKeys() {
                        return Suppliers.ofInstance((Object)ImmutableMap.of((Object)"public", (Object)"publicKey", (Object)"private", (Object)"-----BEGIN RSA PRIVATE KEY-----"));
                    }

                    public Function<String, String> cryptFunction() {
                        return new Function<String, String>(){

                            public String apply(String input) {
                                return String.format("crypt(%s)", input);
                            }
                        };
                    }

                    public Supplier<String> passwordGenerator() {
                        return Suppliers.ofInstance((Object)"randompassword");
                    }
                });
                SshClient.Factory factory = (SshClient.Factory)EasyMock.createMock(SshClient.Factory.class);
                SshClient client1 = (SshClient)EasyMock.createMock(SshClient.class);
                SshClient client1New = (SshClient)EasyMock.createMock(SshClient.class);
                SshClient client2 = (SshClient)EasyMock.createMock(SshClient.class);
                SshClient client2New = (SshClient)EasyMock.createMock(SshClient.class);
                SshClient client2Foo = (SshClient)EasyMock.createMock(SshClient.class);
                SshClient client3 = (SshClient)EasyMock.createMock(SshClient.class);
                SshClient client4 = (SshClient)EasyMock.createMock(SshClient.class);
                SshClient client5 = (SshClient)EasyMock.createMock(SshClient.class);
                SshClient client6 = (SshClient)EasyMock.createMock(SshClient.class);
                SshClient client7 = (SshClient)EasyMock.createMock(SshClient.class);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.1", (int)22), LoginCredentials.builder().user("root").password("password1").build())).andReturn((Object)client1);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.1", (int)22), LoginCredentials.builder().user("web").privateKey("-----BEGIN RSA PRIVATE KEY-----").build())).andReturn((Object)client1New).times(10);
                this.runScriptAndService(client1, client1New);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.2", (int)22), LoginCredentials.builder().user("root").password("password2").build())).andReturn((Object)client2).times(4);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.2", (int)22), LoginCredentials.builder().user("root").password("password2").build())).andReturn((Object)client2New);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.2", (int)22), LoginCredentials.builder().user("foo").privateKey("-----BEGIN RSA PRIVATE KEY-----").build())).andReturn((Object)client2Foo);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.2", (int)22), LoginCredentials.builder().user("root").password("romeo").build())).andThrow((Throwable)new AuthorizationException("Auth fail", null));
                client2.connect();
                EasyMock.expect((Object)client2.exec("hostname\n")).andReturn((Object)new ExecResponse("stub-r\n", "", 0));
                client2.disconnect();
                client2.connect();
                EasyMock.expect((Object)client2.exec("hostname\n")).andReturn((Object)new ExecResponse("stub-r\n", "", 0));
                client2.disconnect();
                client2.connect();
                try {
                    this.runScript(client2, "runScriptWithCreds", Strings2.toStringAndClose((InputStream)StubComputeServiceIntegrationTest.class.getResourceAsStream("/runscript.sh")), 2);
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
                client2.disconnect();
                client2New.connect();
                try {
                    this.runScript(client2New, "adminUpdate", Strings2.toStringAndClose((InputStream)StubComputeServiceIntegrationTest.class.getResourceAsStream("/runscript_adminUpdate.sh")), 2);
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
                client2New.disconnect();
                client2Foo.connect();
                EasyMock.expect((Object)client2Foo.getUsername()).andReturn((Object)"foo").atLeastOnce();
                EasyMock.expect((Object)client2Foo.getHostAddress()).andReturn((Object)"foo").atLeastOnce();
                EasyMock.expect((Object)client2Foo.exec("echo $USER\n")).andReturn((Object)new ExecResponse("foo\n", "", 0));
                client2Foo.disconnect();
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.3", (int)22), LoginCredentials.builder().user("root").password("password3").build())).andReturn((Object)client3).times(2);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.4", (int)22), LoginCredentials.builder().user("root").password("password4").build())).andReturn((Object)client4).times(2);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.5", (int)22), LoginCredentials.builder().user("root").password("password5").build())).andReturn((Object)client5).times(2);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.6", (int)22), LoginCredentials.builder().user("root").password("password6").build())).andReturn((Object)client6).times(2);
                EasyMock.expect((Object)factory.create(HostAndPort.fromParts((String)"144.175.1.7", (int)22), LoginCredentials.builder().user("root").password("password7").build())).andReturn((Object)client7).times(2);
                this.runScriptAndInstallSsh(client3, "bootstrap", 3);
                this.runScriptAndInstallSsh(client4, "bootstrap", 4);
                this.runScriptAndInstallSsh(client5, "bootstrap", 5);
                this.runScriptAndInstallSsh(client6, "bootstrap", 6);
                this.runScriptAndInstallSsh(client7, "bootstrap", 7);
                EasyMock.expect((Object)factory.create((HostAndPort)EasyMock.eq((Object)HostAndPort.fromParts((String)"144.175.1.1", (int)22)), (LoginCredentials)EasyMock.eq((Object)LoginCredentials.builder().user("defaultAdminUsername").privateKey("-----BEGIN RSA PRIVATE KEY-----").build()))).andReturn((Object)client1);
                EasyMock.expect((Object)factory.create((HostAndPort)EasyMock.eq((Object)HostAndPort.fromParts((String)"144.175.1.2", (int)22)), (LoginCredentials)EasyMock.eq((Object)LoginCredentials.builder().user("defaultAdminUsername").privateKey("-----BEGIN RSA PRIVATE KEY-----").build()))).andReturn((Object)client2);
                EasyMock.expect((Object)factory.create((HostAndPort)EasyMock.eq((Object)HostAndPort.fromParts((String)"144.175.1.3", (int)22)), (LoginCredentials)EasyMock.eq((Object)LoginCredentials.builder().user("defaultAdminUsername").privateKey("-----BEGIN RSA PRIVATE KEY-----").build()))).andReturn((Object)client3);
                EasyMock.expect((Object)factory.create((HostAndPort)EasyMock.eq((Object)HostAndPort.fromParts((String)"144.175.1.4", (int)22)), (LoginCredentials)EasyMock.eq((Object)LoginCredentials.builder().user("defaultAdminUsername").privateKey("-----BEGIN RSA PRIVATE KEY-----").build()))).andReturn((Object)client4);
                EasyMock.expect((Object)factory.create((HostAndPort)EasyMock.eq((Object)HostAndPort.fromParts((String)"144.175.1.5", (int)22)), (LoginCredentials)EasyMock.eq((Object)LoginCredentials.builder().user("defaultAdminUsername").privateKey("-----BEGIN RSA PRIVATE KEY-----").build()))).andReturn((Object)client5);
                EasyMock.expect((Object)factory.create((HostAndPort)EasyMock.eq((Object)HostAndPort.fromParts((String)"144.175.1.6", (int)22)), (LoginCredentials)EasyMock.eq((Object)LoginCredentials.builder().user("defaultAdminUsername").privateKey("-----BEGIN RSA PRIVATE KEY-----").build()))).andReturn((Object)client6);
                EasyMock.expect((Object)factory.create((HostAndPort)EasyMock.eq((Object)HostAndPort.fromParts((String)"144.175.1.7", (int)22)), (LoginCredentials)EasyMock.eq((Object)LoginCredentials.builder().user("defaultAdminUsername").privateKey("-----BEGIN RSA PRIVATE KEY-----").build()))).andReturn((Object)client7);
                this.helloAndJava(client2);
                this.helloAndJava(client3);
                this.helloAndJava(client4);
                this.helloAndJava(client5);
                this.helloAndJava(client6);
                this.helloAndJava(client7);
                EasyMock.replay((Object[])new Object[]{factory});
                EasyMock.replay((Object[])new Object[]{client1});
                EasyMock.replay((Object[])new Object[]{client1New});
                EasyMock.replay((Object[])new Object[]{client2});
                EasyMock.replay((Object[])new Object[]{client2New});
                EasyMock.replay((Object[])new Object[]{client2Foo});
                EasyMock.replay((Object[])new Object[]{client3});
                EasyMock.replay((Object[])new Object[]{client4});
                EasyMock.replay((Object[])new Object[]{client5});
                EasyMock.replay((Object[])new Object[]{client6});
                EasyMock.replay((Object[])new Object[]{client7});
                this.bind(SshClient.Factory.class).toInstance((Object)factory);
            }

            private void runScriptAndService(SshClient client, SshClient clientNew) {
                client.connect();
                try {
                    String scriptName = "configure-jetty";
                    client.put("/tmp/init-" + scriptName, Strings2.toStringAndClose((InputStream)StubComputeServiceIntegrationTest.class.getResourceAsStream("/initscript_with_jetty.sh")));
                    EasyMock.expect((Object)client.exec("chmod 755 /tmp/init-" + scriptName)).andReturn((Object)EXEC_GOOD);
                    EasyMock.expect((Object)client.exec("ln -fs /tmp/init-" + scriptName + " " + scriptName)).andReturn((Object)EXEC_GOOD);
                    EasyMock.expect((Object)client.getUsername()).andReturn((Object)"root").atLeastOnce();
                    EasyMock.expect((Object)client.getHostAddress()).andReturn((Object)"localhost").atLeastOnce();
                    EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " init")).andReturn((Object)EXEC_GOOD);
                    EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " start")).andReturn((Object)EXEC_GOOD);
                    EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " status")).andReturn((Object)EXEC_GOOD);
                    EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " status")).andReturn((Object)EXEC_BAD);
                    EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " stdout")).andReturn((Object)EXEC_GOOD);
                    EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " stderr")).andReturn((Object)EXEC_GOOD);
                    EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " exitstatus")).andReturn((Object)EXEC_RC_GOOD);
                    client.disconnect();
                    clientNew.connect();
                    EasyMock.expect((Object)clientNew.getUsername()).andReturn((Object)"web").atLeastOnce();
                    EasyMock.expect((Object)clientNew.getHostAddress()).andReturn((Object)"localhost").atLeastOnce();
                    EasyMock.expect((Object)clientNew.exec("head -1 /usr/local/jetty/VERSION.txt | cut -f1 -d ' '\n")).andReturn((Object)EXEC_GOOD);
                    clientNew.disconnect();
                    clientNew.connect();
                    EasyMock.expect((Object)clientNew.exec("java -fullversion\n")).andReturn((Object)EXEC_GOOD);
                    clientNew.disconnect();
                    String startJetty = "cd /usr/local/jetty" + '\n' + "nohup java -jar start.jar jetty.port=8080 > start.out 2> start.err < /dev/null &" + '\n' + "test $? && sleep 1" + '\n';
                    clientNew.connect();
                    EasyMock.expect((Object)clientNew.exec(startJetty)).andReturn((Object)EXEC_GOOD);
                    clientNew.disconnect();
                    clientNew.connect();
                    EasyMock.expect((Object)clientNew.exec("cd /usr/local/jetty\n./bin/jetty.sh stop\n")).andReturn((Object)EXEC_GOOD);
                    clientNew.disconnect();
                    clientNew.connect();
                    EasyMock.expect((Object)clientNew.exec(startJetty)).andReturn((Object)EXEC_GOOD);
                    clientNew.disconnect();
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
                clientNew.disconnect();
            }

            private void runScriptAndInstallSsh(SshClient client, String scriptName, int nodeId) {
                client.connect();
                try {
                    this.runScript(client, scriptName, Strings2.toStringAndClose((InputStream)StubComputeServiceIntegrationTest.class.getResourceAsStream("/initscript_with_java.sh")), nodeId);
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
                client.disconnect();
            }

            private void runScript(SshClient client, String scriptName, String script, int nodeId) {
                client.put("/tmp/init-" + scriptName, script);
                EasyMock.expect((Object)client.exec("chmod 755 /tmp/init-" + scriptName)).andReturn((Object)EXEC_GOOD);
                EasyMock.expect((Object)client.exec("ln -fs /tmp/init-" + scriptName + " " + scriptName)).andReturn((Object)EXEC_GOOD);
                EasyMock.expect((Object)client.getUsername()).andReturn((Object)"root").atLeastOnce();
                EasyMock.expect((Object)client.getHostAddress()).andReturn((Object)(nodeId + "")).atLeastOnce();
                EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " init")).andReturn((Object)EXEC_GOOD);
                EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " start")).andReturn((Object)EXEC_GOOD);
                EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " status")).andReturn((Object)EXEC_GOOD);
                EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " status")).andReturn((Object)EXEC_BAD);
                EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " stdout")).andReturn((Object)EXEC_GOOD);
                EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " stderr")).andReturn((Object)EXEC_GOOD);
                EasyMock.expect((Object)client.exec("/tmp/init-" + scriptName + " exitstatus")).andReturn((Object)EXEC_RC_GOOD);
            }

            private void helloAndJava(SshClient client) {
                client.connect();
                EasyMock.expect((Object)client.exec("echo hello")).andReturn((Object)new ExecResponse("hello", "", 0));
                EasyMock.expect((Object)client.exec("java -version")).andReturn((Object)new ExecResponse("", "OpenJDK", 0));
                client.disconnect();
            }
        };
    }

    protected void assertNodeZero(Set<? extends NodeMetadata> metadataSet) {
    }

    public static Payload payloadEq(String value) {
        EasyMock.reportMatcher((IArgumentMatcher)new PayloadEquals(value));
        return null;
    }

    @Override
    protected void setupKeyPairForTest() {
        this.keyPair = ImmutableMap.of((Object)"public", (Object)"ssh-rsa", (Object)"private", (Object)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Override
    public void testImagesCache() throws Exception {
        super.testImagesCache();
    }

    @Override
    public void testCompareSizes() throws Exception {
        super.testCompareSizes();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testImagesCache"})
    public void testAScriptExecutionAfterBootWithBasicTemplate() throws Exception {
        super.testAScriptExecutionAfterBootWithBasicTemplate();
    }

    @Override
    @Test(enabled=false)
    public void weCanCancelTasks(NodeMetadata node) throws InterruptedException, ExecutionException {
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testCompareSizes"})
    public void testCreateAndRunAService() throws Exception {
        super.testCreateAndRunAService();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testTemplateMatch"})
    public void testConcurrentUseOfComputeServiceToCreateNodes() throws Exception {
        super.testConcurrentUseOfComputeServiceToCreateNodes();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testConcurrentUseOfComputeServiceToCreateNodes"})
    public void testCreateTwoNodesWithRunScript() throws Exception {
        super.testCreateTwoNodesWithRunScript();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testCreateTwoNodesWithRunScript"})
    public void testCreateAnotherNodeWithANewContextToEnsureSharedMemIsntRequired() throws Exception {
        super.testCreateAnotherNodeWithANewContextToEnsureSharedMemIsntRequired();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testCreateAnotherNodeWithANewContextToEnsureSharedMemIsntRequired"})
    public void testCreateTwoNodesWithOneSpecifiedName() throws Exception {
        super.testCreateTwoNodesWithOneSpecifiedName();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testCreateAnotherNodeWithANewContextToEnsureSharedMemIsntRequired"})
    public void testCredentialsCache() throws Exception {
        super.testCredentialsCache();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testCreateAnotherNodeWithANewContextToEnsureSharedMemIsntRequired"})
    public void testGet() throws Exception {
        super.testGet();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testGet"})
    public void testOptionToNotBlock() throws Exception {
        super.testOptionToNotBlock();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testGet"})
    public void testReboot() throws Exception {
        super.testReboot();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testReboot"})
    public void testSuspendResume() throws Exception {
        super.testSuspendResume();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testImagesCache"})
    public void testTemplateMatch() throws Exception {
        super.testTemplateMatch();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testGetNodesWithDetails() throws Exception {
        super.testGetNodesWithDetails();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodes() throws Exception {
        super.testListNodes();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodesByIds() throws Exception {
        super.testListNodesByIds();
    }

    @Override
    @Test(enabled=true, dependsOnMethods={"testListNodes", "testGetNodesWithDetails", "testListNodesByIds"})
    public void testDestroyNodes() {
        super.testDestroyNodes();
    }

    private static class PayloadEquals
    implements IArgumentMatcher {
        private final Object expected;

        public PayloadEquals(Object expected) {
            this.expected = expected;
        }

        public boolean matches(Object actual) {
            if (this.expected == null) {
                return actual == null;
            }
            try {
                String real = Strings2.toString((InputSupplier)((Payload)actual));
                Assert.assertEquals((Object)real, (Object)this.expected);
                return true;
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return false;
            }
        }

        public void appendTo(StringBuffer buffer) {
            this.appendQuoting(buffer);
            buffer.append(this.expected);
            this.appendQuoting(buffer);
        }

        private void appendQuoting(StringBuffer buffer) {
            if (this.expected instanceof String) {
                buffer.append("\"");
            } else if (this.expected instanceof Character) {
                buffer.append("'");
            }
        }

        public boolean equals(Object o) {
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            PayloadEquals other = (PayloadEquals)o;
            return this.expected == null && other.expected == null || this.expected != null && this.expected.equals(other.expected);
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode() is not supported");
        }
    }
}

