/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import org.easymock.EasyMock;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DefaultLoginCredentialsFromImageOrOverridingLoginCredentialsTest")
public class DefaultCredentialsFromImageOrOverridingCredentialsTest {
    private static final DefaultCredentialsFromImageOrOverridingCredentials fn = new DefaultCredentialsFromImageOrOverridingCredentials();
    LoginCredentials expected = LoginCredentials.builder().user("ubuntu").password("password").build();

    public void testWhenLoginCredentialsNotPresentInImageOrTemplateOptionsReturnNull() {
        Object expected = null;
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn(null);
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)new TemplateOptions());
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template), expected);
        EasyMock.verify((Object[])new Object[]{template, image});
    }

    public void testWhenLoginCredentialsNotPresentInImageReturnsOneInTemplateOptions() {
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn(null);
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)TemplateOptions.Builder.overrideLoginCredentials((LoginCredentials)this.expected));
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template), (Object)this.expected);
        EasyMock.verify((Object[])new Object[]{template, image});
    }

    public void testWhenLoginCredentialsNotPresentInTemplateOptionsReturnsOneInImage() {
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn((Object)this.expected);
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)new TemplateOptions());
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template), (Object)this.expected);
        EasyMock.verify((Object[])new Object[]{template, image});
    }

    public void testWhenLoginCredentialsPresentInImageOverridesIdentityFromLoginCredentialsInTemplateOptions() {
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn((Object)LoginCredentials.builder().user("user").password("password").build());
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)TemplateOptions.Builder.overrideLoginUser((String)"ubuntu"));
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template), (Object)this.expected);
        EasyMock.verify((Object[])new Object[]{template, image});
    }

    public void testWhenLoginCredentialsPresentInImageOverridesCredentialFromLoginCredentialsInTemplateOptions() {
        Image image = (Image)EasyMock.createMock(Image.class);
        Template template = (Template)EasyMock.createMock(Template.class);
        EasyMock.expect((Object)template.getImage()).andReturn((Object)image);
        EasyMock.expect((Object)image.getDefaultCredentials()).andReturn((Object)LoginCredentials.builder().user("ubuntu").password("password2").build());
        EasyMock.expect((Object)template.getOptions()).andReturn((Object)TemplateOptions.Builder.overrideLoginPassword((String)"password"));
        EasyMock.replay((Object[])new Object[]{template, image});
        Assert.assertEquals((Object)fn.apply(template), (Object)this.expected);
        EasyMock.verify((Object[])new Object[]{template, image});
    }
}

