/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.util.ConcurrentOpenSocketFinder;
import org.jclouds.predicates.SocketOpen;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class ConcurrentOpenSocketFinderTest {
    private static final long SLOW_GRACE = 700L;
    private static final long EARLY_GRACE = 10L;
    private final NodeMetadata node = new NodeMetadataBuilder().id("myid").status(NodeMetadata.Status.RUNNING).publicAddresses((Iterable)ImmutableSet.of((Object)"1.2.3.4")).privateAddresses((Iterable)ImmutableSet.of((Object)"1.2.3.5")).build();
    private final SocketOpen socketAlwaysClosed = new SocketOpen(){

        public boolean apply(HostAndPort input) {
            return false;
        }
    };
    private final Predicate<AtomicReference<NodeMetadata>> nodeRunning = Predicates.alwaysTrue();
    private final Predicate<AtomicReference<NodeMetadata>> nodeNotRunning = Predicates.alwaysFalse();
    private ListeningExecutorService userExecutor;

    @BeforeClass
    public void setUp() {
        this.userExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.userExecutor != null) {
            this.userExecutor.shutdownNow();
        }
    }

    @Test
    public void testRespectsTimeout() throws Exception {
        long timeoutMs = 1000L;
        ConcurrentOpenSocketFinder finder = new ConcurrentOpenSocketFinder(this.socketAlwaysClosed, this.nodeRunning, this.userExecutor);
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        try {
            finder.findOpenSocketOnNode(this.node, 22, 1000L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (NoSuchElementException success) {
            // empty catch block
        }
        long timetaken = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Assert.assertTrue((timetaken >= 990L && timetaken <= 1700L ? 1 : 0) != 0, (String)("timetaken=" + timetaken));
    }

    @Test
    public void testReturnsReachable() throws Exception {
        SocketOpen secondSocketOpen = new SocketOpen(){

            public boolean apply(HostAndPort input) {
                return HostAndPort.fromParts((String)"1.2.3.5", (int)22).equals((Object)input);
            }
        };
        ConcurrentOpenSocketFinder finder = new ConcurrentOpenSocketFinder(secondSocketOpen, this.nodeRunning, this.userExecutor);
        HostAndPort result = finder.findOpenSocketOnNode(this.node, 22, 2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)result, (Object)HostAndPort.fromParts((String)"1.2.3.5", (int)22));
    }

    @Test
    public void testChecksSocketsConcurrently() throws Exception {
        ControllableSocketOpen socketTester = new ControllableSocketOpen((Map<HostAndPort, ? extends Callable<Boolean>>)ImmutableMap.of((Object)HostAndPort.fromParts((String)"1.2.3.4", (int)22), new SlowCallable<Boolean>(true, 1500L), (Object)HostAndPort.fromParts((String)"1.2.3.5", (int)22), new SlowCallable<Boolean>(true, 1000L)));
        ConcurrentOpenSocketFinder finder = new ConcurrentOpenSocketFinder((SocketOpen)socketTester, this.nodeRunning, this.userExecutor);
        HostAndPort result = finder.findOpenSocketOnNode(this.node, 22, 2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)result, (Object)HostAndPort.fromParts((String)"1.2.3.5", (int)22));
    }

    @Test
    public void testAbortsWhenNodeNotRunning() throws Exception {
        ConcurrentOpenSocketFinder finder = new ConcurrentOpenSocketFinder(this.socketAlwaysClosed, this.nodeNotRunning, this.userExecutor){

            protected <T> Predicate<T> retryPredicate(final Predicate<T> findOrBreak, long timeout, long period, TimeUnit timeUnits) {
                return new Predicate<T>(){

                    public boolean apply(T input) {
                        try {
                            findOrBreak.apply(input);
                            Assert.fail((String)"should have thrown IllegalStateException");
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        return false;
                    }
                };
            }
        };
        try {
            finder.findOpenSocketOnNode(this.node, 22, 2000L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private static class ControllableSocketOpen
    implements SocketOpen {
        private final Map<HostAndPort, ? extends Callable<Boolean>> answers;

        ControllableSocketOpen(Map<HostAndPort, ? extends Callable<Boolean>> answers) {
            this.answers = answers;
        }

        public boolean apply(HostAndPort input) {
            try {
                return this.answers.get(input).call();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static class SlowCallable<T>
    implements Callable<T> {
        private final T result;
        private final long delay;

        SlowCallable(T result, long delay) {
            this.result = result;
            this.delay = delay;
        }

        @Override
        public T call() throws Exception {
            Uninterruptibles.sleepUninterruptibly((long)this.delay, (TimeUnit)TimeUnit.MILLISECONDS);
            return this.result;
        }
    }
}

