/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Suppliers;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.internal.NullEqualToIsParentOrIsGrandparentOfCurrentLocation;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="NullEqualToIsParentOrIsGrandparentOfCurrentLocationTest")
public class NullEqualToIsParentOrIsGrandparentOfCurrentLocationTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("aws-ec2").description("aws-ec2").build();
    Location region = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").parent(this.provider).build();
    Location zone = new LocationBuilder().scope(LocationScope.ZONE).id("us-east-1a").description("us-east-1a").parent(this.region).build();
    Location host = new LocationBuilder().scope(LocationScope.HOST).id("xxxxx").description("xxxx").parent(this.zone).build();
    Location otherRegion = new LocationBuilder().scope(LocationScope.REGION).id("us-west-1").description("us-west-1").parent(this.provider).build();
    Location otherZone = new LocationBuilder().scope(LocationScope.ZONE).id("us-west-1a").description("us-west-1a").parent(this.otherRegion).build();
    Location orphanedRegion = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").build();
    Location orphanedZone = new LocationBuilder().scope(LocationScope.ZONE).id("us-east-1a").description("us-east-1a").build();

    public void testReturnTrueWhenIDontSpecifyALocation() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance(null));
        Hardware md = new HardwareBuilder().id("foo").location(this.region).build();
        Assert.assertTrue((boolean)predicate.apply((ComputeMetadata)md));
    }

    public void testReturnTrueWhenISpecifyALocationAndInputLocationIsNull() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.region));
        Hardware md = new HardwareBuilder().id("foo").location(null).build();
        Assert.assertTrue((boolean)predicate.apply((ComputeMetadata)md));
    }

    public void testReturnTrueWhenIDontSpecifyALocationAndInputLocationIsNull() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance(null));
        Hardware md = new HardwareBuilder().id("foo").location(null).build();
        Assert.assertTrue((boolean)predicate.apply((ComputeMetadata)md));
    }

    @Test
    public void testReturnTrueWhenISpecifyARegionAndInputLocationIsProvider() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.region));
        Hardware md = new HardwareBuilder().id("foo").location(this.provider).build();
        Assert.assertTrue((boolean)predicate.apply((ComputeMetadata)md));
    }

    @Test
    public void testReturnFalseWhenISpecifyALocationWhichTheSameScopeByNotEqualToInputLocationAndParentsAreNull() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.region));
        Hardware md = new HardwareBuilder().id("foo").location(this.otherRegion).build();
        Assert.assertFalse((boolean)predicate.apply((ComputeMetadata)md));
    }

    public void testReturnFalseWhenISpecifyALocationWhichTheSameScopeByNotEqualToInputLocationAndParentsAreNotNull() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.zone));
        Hardware md = new HardwareBuilder().id("foo").location(this.otherZone).build();
        Assert.assertFalse((boolean)predicate.apply((ComputeMetadata)md));
    }

    public void testReturnTrueWhenISpecifyALocationWhichIsAChildOfInput() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.zone));
        Hardware md = new HardwareBuilder().id("foo").location(this.region).build();
        Assert.assertTrue((boolean)predicate.apply((ComputeMetadata)md));
    }

    public void testReturnFalseWhenISpecifyALocationWhichIsNotAChildOfInput() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.zone));
        Hardware md = new HardwareBuilder().id("foo").location(this.otherRegion).build();
        Assert.assertFalse((boolean)predicate.apply((ComputeMetadata)md));
    }

    public void testReturnTrueWhenISpecifyALocationWhichIsAGrandChildOfInput() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.host));
        Hardware md = new HardwareBuilder().id("foo").location(this.host).build();
        Assert.assertTrue((boolean)predicate.apply((ComputeMetadata)md));
    }

    public void testReturnFalseWhenISpecifyALocationWhichIsNotAGrandChildOfInput() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.host));
        Hardware md = new HardwareBuilder().id("foo").location(this.otherRegion).build();
        Assert.assertFalse((boolean)predicate.apply((ComputeMetadata)md));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testThrowIllegalStateExceptionWhenInputIsAnOrphanedRegion() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.region));
        Hardware md = new HardwareBuilder().id("foo").location(this.orphanedRegion).build();
        predicate.apply((ComputeMetadata)md);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testThrowIllegalStateExceptionWhenInputIsAnOrphanedZone() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.region));
        Hardware md = new HardwareBuilder().id("foo").location(this.orphanedZone).build();
        predicate.apply((ComputeMetadata)md);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testThrowIllegalArgumentExceptionWhenWhenISpecifyAnOrphanedRegion() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.orphanedRegion));
        Hardware md = new HardwareBuilder().id("foo").location(this.region).build();
        predicate.apply((ComputeMetadata)md);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testThrowIllegalArgumentExceptionWhenWhenISpecifyAnOrphanedZone() {
        NullEqualToIsParentOrIsGrandparentOfCurrentLocation predicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(Suppliers.ofInstance((Object)this.orphanedZone));
        Hardware md = new HardwareBuilder().id("foo").location(this.region).build();
        predicate.apply((ComputeMetadata)md);
    }
}

