/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Provider;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.TemplateBuilderImpl;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.suppliers.ImageCacheSupplier;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="TemplateBuilderImplTest")
public class TemplateBuilderImplTest {
    protected Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("aws-ec2").description("aws-ec2").build();
    protected Location region = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").parent(this.provider).build();
    protected Location region2 = new LocationBuilder().scope(LocationScope.REGION).id("us-east-2").description("us-east-2").parent(this.provider).build();
    protected OperatingSystem os = OperatingSystem.builder().name("osName").version("osVersion").description("osDescription").arch("X86_32").build();
    protected Image image = new ImageBuilder().id(this.getProviderFormatId("imageId")).providerId("imageId").name("imageName").description("imageDescription").version("imageVersion").operatingSystem(this.os).status(Image.Status.AVAILABLE).location(this.region).build();
    protected Image image64bit = ImageBuilder.fromImage((Image)this.image).id(this.getProviderFormatId("image64bId")).providerId("image64bId").operatingSystem(this.os.toBuilder().arch("X86_64").build()).build();
    protected Image imageArchNull = ImageBuilder.fromImage((Image)this.image).id(this.getProviderFormatId("imageArchNullId")).providerId("imageArchNullId").operatingSystem(this.os.toBuilder().arch(null).build()).build();
    protected Image imageNameAlt = ImageBuilder.fromImage((Image)this.image).id(this.getProviderFormatId("imageNameAltId")).providerId("imageNameAltId").name("alternateImageName").build();

    public void testMultiMax() {
        ImmutableList values = ImmutableList.of((Object)"1", (Object)"2", (Object)"2", (Object)"3", (Object)"3");
        Assert.assertEquals((Collection)TemplateBuilderImpl.multiMax((Comparator)Ordering.natural(), (Iterable)values), (Collection)ImmutableList.of((Object)"3", (Object)"3"));
    }

    public void testMultiMax1() {
        ImmutableList values = ImmutableList.of((Object)"1", (Object)"2", (Object)"2", (Object)"3");
        Assert.assertEquals((Collection)TemplateBuilderImpl.multiMax((Comparator)Ordering.natural(), (Iterable)values), (Collection)ImmutableList.of((Object)"3"));
    }

    public void testMultiMax2() {
        ImmutableList values = ImmutableList.of((Object)"1", (Object)"3", (Object)"2", (Object)"2");
        Assert.assertEquals((Collection)TemplateBuilderImpl.multiMax((Comparator)Ordering.natural(), (Iterable)values), (Collection)ImmutableList.of((Object)"3"));
    }

    public void testMultiMaxNull() {
        List<String> values = Arrays.asList("1", "3", null, "2", "2");
        Assert.assertEquals((Collection)TemplateBuilderImpl.multiMax((Comparator)Ordering.natural().nullsLast(), values), Arrays.asList(new Object[]{null}));
    }

    public void testMultiMaxNulls() {
        List<String> values = Arrays.asList("1", "3", null, "2", "2", null);
        Assert.assertEquals((Collection)TemplateBuilderImpl.multiMax((Comparator)Ordering.natural().nullsLast(), values), Arrays.asList(null, null));
    }

    protected String getProviderFormatId(String uniqueLabel) {
        return uniqueLabel;
    }

    public void testLocationPredicateWhenComputeMetadataIsNotLocationBound() {
        Hardware hardware = new HardwareBuilder().id("hardwareId").build();
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)hardware));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateBuilder defaultTemplate = (TemplateBuilder)EasyMock.createMock(TemplateBuilder.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.replay((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        assert (template.locationPredicate.apply((Object)hardware));
        EasyMock.verify((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    protected void doTestResolveImagesWithTemplateBuilderCustomizer(Supplier<Set<? extends Image>> inputImages, Function<TemplateBuilderImpl, TemplateBuilderImpl> templateBuilderPerTestCustomizer, Image expectedBest) {
        Hardware hardware = new HardwareBuilder().id("hardwareId").build();
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)hardware));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateBuilder defaultTemplate = (TemplateBuilder)EasyMock.createMock(TemplateBuilder.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.replay((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, inputImages, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        template = (TemplateBuilderImpl)templateBuilderPerTestCustomizer.apply((Object)template);
        Assert.assertEquals((Object)template.resolveImage(hardware, (Iterable)inputImages.get()), (Object)expectedBest);
        EasyMock.verify((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    protected void doTestResolveImages(Supplier<Set<? extends Image>> inputImages, Image expectedBest) {
        this.doTestResolveImagesWithTemplateBuilderCustomizer(inputImages, (Function<TemplateBuilderImpl, TemplateBuilderImpl>)Functions.identity(), expectedBest);
    }

    public void testResolveImagesSimple() {
        this.doTestResolveImages((Supplier<Set<? extends Image>>)Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image, (Object)this.image64bit)), this.image64bit);
    }

    public void testResolveImagesPrefersNull() {
        this.doTestResolveImages((Supplier<Set<? extends Image>>)Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image, (Object)this.imageArchNull, (Object)this.image64bit)), this.imageArchNull);
    }

    public void testResolveImagesCustomSorterPreferringNonNull() {
        Ordering<Image> sorterPreferringNonNullArch = new Ordering<Image>(){

            public int compare(Image left, Image right) {
                return ComparisonChain.start().compare((Object)left.getOperatingSystem().getArch(), (Object)right.getOperatingSystem().getArch(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)left, (Object)right, (Comparator)TemplateBuilderImpl.DEFAULT_IMAGE_ORDERING).result();
            }
        };
        Assert.assertTrue((TemplateBuilderImpl.DEFAULT_IMAGE_ORDERING.compare((Object)this.image64bit, (Object)this.imageArchNull) < 0 ? 1 : 0) != 0, (String)"wrong default image ordering");
        Assert.assertTrue((sorterPreferringNonNullArch.compare((Object)this.image64bit, (Object)this.imageArchNull) > 0 ? 1 : 0) != 0, (String)"wrong custom image ordering");
        Function<TemplateBuilderImpl, TemplateBuilderImpl> tbCustomiser = new Function<TemplateBuilderImpl, TemplateBuilderImpl>((Ordering)sorterPreferringNonNullArch){
            final /* synthetic */ Ordering val$sorterPreferringNonNullArch;
            {
                this.val$sorterPreferringNonNullArch = ordering;
            }

            public TemplateBuilderImpl apply(TemplateBuilderImpl input) {
                return input.imageChooser(input.imageChooserFromOrdering(this.val$sorterPreferringNonNullArch));
            }
        };
        this.doTestResolveImagesWithTemplateBuilderCustomizer((Supplier<Set<? extends Image>>)Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image, (Object)this.imageArchNull, (Object)this.image64bit)), tbCustomiser, this.image64bit);
    }

    public void testResolveImagesPrefersImageBecauseNameIsLastAlphabetically() {
        this.doTestResolveImages((Supplier<Set<? extends Image>>)Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.imageNameAlt, (Object)this.image)), this.image);
    }

    public void testResolveImagesCustomSorterPreferringAltImage() {
        Function<TemplateBuilderImpl, TemplateBuilderImpl> tbSortWithAlternate = new Function<TemplateBuilderImpl, TemplateBuilderImpl>(){

            public TemplateBuilderImpl apply(TemplateBuilderImpl input) {
                return input.imageChooser(input.imageChooserFromOrdering((Ordering)new Ordering<Image>(){

                    private int score(Image img) {
                        if (img.getName().contains("alternate")) {
                            return 10;
                        }
                        return 0;
                    }

                    public int compare(Image left, Image right) {
                        return this.score(left) - this.score(right);
                    }
                }));
            }
        };
        this.doTestResolveImagesWithTemplateBuilderCustomizer((Supplier<Set<? extends Image>>)Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.imageNameAlt, (Object)this.image, (Object)this.imageArchNull, (Object)this.image64bit)), tbSortWithAlternate, this.imageNameAlt);
    }

    public void testResolveImagesCustomChooserPreferringAltImage() {
        Function<TemplateBuilderImpl, TemplateBuilderImpl> tbChooseAlternate = new Function<TemplateBuilderImpl, TemplateBuilderImpl>(){

            public TemplateBuilderImpl apply(TemplateBuilderImpl input) {
                return input.imageChooser((Function)new Function<Iterable<? extends Image>, Image>(){

                    public Image apply(Iterable<? extends Image> input) {
                        return (Image)Iterables.find(input, (Predicate)new Predicate<Image>(){

                            public boolean apply(Image input) {
                                return input.getName() != null && input.getName().contains("alternate");
                            }
                        });
                    }
                });
            }
        };
        this.doTestResolveImagesWithTemplateBuilderCustomizer((Supplier<Set<? extends Image>>)Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.imageNameAlt, (Object)this.image, (Object)this.imageArchNull, (Object)this.image64bit)), tbChooseAlternate, this.imageNameAlt);
    }

    @Test
    public void testArchWins() {
        Hardware hardware = new HardwareBuilder().id("hardwareId").build();
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image, (Object)this.image64bit));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)hardware));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateBuilder defaultTemplate = (TemplateBuilder)EasyMock.createMock(TemplateBuilder.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)new TemplateOptions());
        EasyMock.replay((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        Assert.assertEquals((Object)template.smallest().osArchMatches("X86_32").build().getImage(), (Object)this.image);
        EasyMock.verify((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    @Test
    public void testHardwareWithImageIdPredicateOnlyAcceptsImage() {
        Hardware hardware = new HardwareBuilder().id("hardwareId").supportsImage(ImagePredicates.idEquals((String)this.getProviderFormatId("imageId"))).build();
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)hardware));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateBuilder defaultTemplate = (TemplateBuilder)EasyMock.createMock(TemplateBuilder.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)new TemplateOptions());
        EasyMock.replay((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        template.imageId(this.getProviderFormatId("imageId")).build();
        EasyMock.verify((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    @Test
    public void testHardwareWithImageIdPredicateOnlyAcceptsImageWhenLocationNull() {
        Hardware hardware = new HardwareBuilder().id("hardwareId").supportsImage(ImagePredicates.idEquals((String)this.getProviderFormatId("imageId"))).build();
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)hardware));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateBuilder defaultTemplate = (TemplateBuilder)EasyMock.createMock(TemplateBuilder.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)new TemplateOptions());
        EasyMock.replay((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        template.imageId(this.getProviderFormatId("imageId")).build();
        EasyMock.verify((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    @Test
    public void testHardwareWithImageIdPredicateOnlyDoesntImage() {
        Hardware hardware = new HardwareBuilder().id("hardwareId").supportsImage(ImagePredicates.idEquals((String)"differentImageId")).build();
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)hardware));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateBuilder defaultTemplate = (TemplateBuilder)EasyMock.createMock(TemplateBuilder.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)new TemplateOptions());
        EasyMock.replay((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(this.image, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        try {
            template.imageId(this.getProviderFormatId("imageId")).build();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"no hardware profiles support images matching params: idEquals(differentImageId)");
            EasyMock.verify((Object[])new Object[]{defaultTemplate, optionsProvider, templateBuilderProvider, getImageStrategy});
        }
    }

    @Test
    public void testOptionsUsesDefaultTemplateBuilder() {
        TemplateOptions options = this.provideTemplateOptions();
        TemplateOptions from = this.provideTemplateOptions();
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of());
        Location defaultLocation = (Location)EasyMock.createMock(Location.class);
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateBuilder defaultTemplate = (TemplateBuilder)EasyMock.createMock(TemplateBuilder.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)templateBuilderProvider.get()).andReturn((Object)defaultTemplate);
        EasyMock.expect((Object)defaultTemplate.options(from)).andReturn((Object)defaultTemplate);
        EasyMock.expect((Object)defaultTemplate.build()).andReturn(null);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)from).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{defaultTemplate, defaultLocation, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, defaultLocation, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        template.options(options).build();
        EasyMock.verify((Object[])new Object[]{defaultTemplate, defaultLocation, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    @Test
    public void testNothingUsesDefaultTemplateBuilder() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of());
        Location defaultLocation = (Location)EasyMock.createMock(Location.class);
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateBuilder defaultTemplate = (TemplateBuilder)EasyMock.createMock(TemplateBuilder.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)templateBuilderProvider.get()).andReturn((Object)defaultTemplate);
        EasyMock.expect((Object)defaultTemplate.build()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{defaultTemplate, defaultLocation, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, defaultLocation, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        template.build();
        EasyMock.verify((Object[])new Object[]{defaultTemplate, defaultLocation, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    protected TemplateBuilderImpl createTemplateBuilder(Image knownImage, Supplier<Set<? extends Location>> locations, Supplier<Set<? extends Image>> images, Supplier<Set<? extends Hardware>> hardwares, Location defaultLocation, Provider<TemplateOptions> optionsProvider, Provider<TemplateBuilder> templateBuilderProvider, GetImageStrategy getImageStrategy) {
        TemplateBuilderImpl template = new TemplateBuilderImpl(locations, new ImageCacheSupplier(images, 60L), hardwares, Suppliers.ofInstance((Object)defaultLocation), optionsProvider, templateBuilderProvider, getImageStrategy);
        return template;
    }

    @Test
    public void testSuppliedImageLocationWiderThanDefault() {
        TemplateOptions from = this.provideTemplateOptions();
        Hardware hardware = new HardwareBuilder().id("hardwareId").supportsImage(ImagePredicates.idEquals((String)this.image.getId())).build();
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider, (Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)hardware));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)from).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        Assert.assertEquals((Object)template.imageId(this.image.getId()).locationId(this.provider.getId()).build().getLocation(), (Object)this.region);
        EasyMock.verify((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    @Test
    public void testSuppliedLocationWithNoOptions() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of());
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.replay((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        try {
            template.imageId("foo").locationId("location").build();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    @Test
    public void testSuppliedLocationAndOptions() {
        TemplateOptions from = this.provideTemplateOptions();
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of());
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)from).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        try {
            template.imageId("foo").options(this.provideTemplateOptions()).locationId("location").build();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    public void testImagesMustBePresentWhenQuerying() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)EasyMock.createMock(Hardware.class)));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)defaultOptions);
        EasyMock.replay((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        try {
            template.os64Bit(true).build();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"no images present!");
        }
        EasyMock.verify((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    public void testHardwareProfilesMustBePresentWhenQuerying() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of());
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)defaultOptions);
        EasyMock.replay((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        try {
            template.os64Bit(true).build();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"no hardware profiles present!");
        }
        EasyMock.verify((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    @Test
    public void testDefaultLocationWithNoOptionsNoSuchElement() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)EasyMock.createMock(Hardware.class)));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)defaultOptions);
        EasyMock.expect((Object)getImageStrategy.getImage((String)EasyMock.anyObject(String.class))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        try {
            template.imageId("region/imageId2").build();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"imageId(region/imageId2) not found");
        }
        EasyMock.verify((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider});
    }

    @Test
    public void testDefaultLocationWithUnmatchedPredicateExceptionMessageAndLocationNotCalled() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)EasyMock.createMock(Hardware.class)));
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)defaultOptions);
        EasyMock.replay((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, this.region, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        try {
            template.imageDescriptionMatches("notDescription").build();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"no image matched predicate: Predicates.and(nullEqualToIsParentOrIsGrandparentOfCurrentLocation(),imageDescription(notDescription))");
        }
        EasyMock.verify((Object[])new Object[]{defaultOptions, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    protected TemplateOptions provideTemplateOptions() {
        return new TemplateOptions();
    }

    @Test
    public void testDefaultLocationWithOptions() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.image));
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)EasyMock.createMock(Hardware.class)));
        Location defaultLocation = (Location)EasyMock.createMock(Location.class);
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions from = this.provideTemplateOptions();
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)from);
        EasyMock.expect((Object)getImageStrategy.getImage((String)EasyMock.anyObject(String.class))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{defaultLocation, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, defaultLocation, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        try {
            template.imageId("region/ami").options(this.provideTemplateOptions()).build();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{defaultLocation, optionsProvider, templateBuilderProvider});
    }

    @Test
    public void testImageIdNullsEverythingElse() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of());
        Location defaultLocation = (Location)EasyMock.createMock(Location.class);
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.replay((Object[])new Object[]{defaultLocation, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, defaultLocation, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        template.imageDescriptionMatches("imageDescriptionMatches");
        template.imageNameMatches("imageNameMatches");
        template.imageVersionMatches("imageVersionMatches");
        template.osDescriptionMatches("osDescriptionMatches");
        template.osFamily(OsFamily.CENTOS);
        template.osArchMatches("osArchMatches");
        Assert.assertEquals((String)template.osArch, (String)"osArchMatches");
        Assert.assertEquals((String)template.imageDescription, (String)"imageDescriptionMatches");
        Assert.assertEquals((String)template.imageName, (String)"imageNameMatches");
        Assert.assertEquals((String)template.imageVersion, (String)"imageVersionMatches");
        Assert.assertEquals((String)template.osDescription, (String)"osDescriptionMatches");
        Assert.assertEquals((Object)template.osFamily, (Object)OsFamily.CENTOS);
        Assert.assertEquals((String)template.imageId, null);
        template.imageId("myid");
        Assert.assertEquals((String)template.osArch, null);
        Assert.assertEquals((String)template.imageDescription, null);
        Assert.assertEquals((String)template.imageName, null);
        Assert.assertEquals((String)template.imageVersion, null);
        Assert.assertEquals((String)template.osDescription, null);
        Assert.assertEquals((Object)template.osFamily, null);
        Assert.assertEquals((String)template.imageId, (String)"myid");
        EasyMock.verify((Object[])new Object[]{defaultLocation, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    @Test
    public void testFindImageWithIdDefaultToGetImageStrategy() {
        final Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        final Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new ImageBuilder().ids("Ubuntu 11.04 x64").name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").location(this.region).status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").is64Bit(true).version("11.04").family(OsFamily.UBUNTU).build()).build(), (Object)new ImageBuilder().ids("Ubuntu 11.04 64-bit").name("Ubuntu 11.04 64-bit").description("Ubuntu 11.04 64-bit").location(this.region).status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu 11.04 64-bit").description("Ubuntu 11.04 64-bit").is64Bit(true).version("11.04").family(OsFamily.UBUNTU).build()).build()));
        final Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new HardwareBuilder().ids(String.format("datacenter(%s)platform(%s)cpuCores(%d)memorySizeMB(%d)diskSizeGB(%d)", "Falkenberg", "Xen", 1, 512, 5)).ram(512).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(5.0f), true, true))).hypervisor("Xen").location(this.region).supportsImage(ImagePredicates.idEquals((String)this.image.getId())).build()));
        Provider<TemplateOptions> optionsProvider = new Provider<TemplateOptions>(){

            public TemplateOptions get() {
                return new TemplateOptions();
            }
        };
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)getImageStrategy.getImage(this.image.getId())).andReturn((Object)this.image);
        EasyMock.replay((Object[])new Object[]{getImageStrategy});
        Provider<TemplateBuilder> templateBuilderProvider = new Provider<TemplateBuilder>((Provider)optionsProvider, getImageStrategy){
            final /* synthetic */ Provider val$optionsProvider;
            final /* synthetic */ GetImageStrategy val$getImageStrategy;
            {
                this.val$optionsProvider = provider;
                this.val$getImageStrategy = getImageStrategy;
            }

            public TemplateBuilder get() {
                return TemplateBuilderImplTest.this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, TemplateBuilderImplTest.this.region, (Provider<TemplateOptions>)this.val$optionsProvider, this, this.val$getImageStrategy);
            }
        };
        TemplateBuilder templateBuilder = ((TemplateBuilder)templateBuilderProvider.get()).imageId(this.image.getId());
        Template template = templateBuilder.build();
        Assert.assertEquals((String)template.getImage().getId(), (String)this.image.getId());
        EasyMock.verify((Object[])new Object[]{getImageStrategy});
    }

    @Test
    public void testFindImageWithIdDefaultToGetImageStrategyAndPopulatesTheCache() {
        final Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        final Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new ImageBuilder().ids("Ubuntu 11.04 x64").name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").location(this.region).status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").is64Bit(true).version("11.04").family(OsFamily.UBUNTU).build()).build(), (Object)new ImageBuilder().ids("Ubuntu 11.04 64-bit").name("Ubuntu 11.04 64-bit").description("Ubuntu 11.04 64-bit").location(this.region).status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu 11.04 64-bit").description("Ubuntu 11.04 64-bit").is64Bit(true).version("11.04").family(OsFamily.UBUNTU).build()).build()));
        final Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new HardwareBuilder().ids(String.format("datacenter(%s)platform(%s)cpuCores(%d)memorySizeMB(%d)diskSizeGB(%d)", "Falkenberg", "Xen", 1, 512, 5)).ram(512).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(5.0f), true, true))).hypervisor("Xen").location(this.region).supportsImage(ImagePredicates.idEquals((String)this.image.getId())).build()));
        Provider<TemplateOptions> optionsProvider = new Provider<TemplateOptions>(){

            public TemplateOptions get() {
                return new TemplateOptions();
            }
        };
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.expect((Object)getImageStrategy.getImage(this.image.getId())).andReturn((Object)this.image);
        EasyMock.replay((Object[])new Object[]{getImageStrategy});
        Provider<TemplateBuilder> templateBuilderProvider = new Provider<TemplateBuilder>((Provider)optionsProvider, getImageStrategy){
            final /* synthetic */ Provider val$optionsProvider;
            final /* synthetic */ GetImageStrategy val$getImageStrategy;
            {
                this.val$optionsProvider = provider;
                this.val$getImageStrategy = getImageStrategy;
            }

            public TemplateBuilder get() {
                return TemplateBuilderImplTest.this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, TemplateBuilderImplTest.this.region, (Provider<TemplateOptions>)this.val$optionsProvider, this, this.val$getImageStrategy);
            }
        };
        TemplateBuilder templateBuilder = (TemplateBuilder)templateBuilderProvider.get();
        try {
            templateBuilder.osNameMatches(this.image.getOperatingSystem().getName()).build();
            Assert.fail((String)"Image should not exist in the cache");
        }
        catch (Exception ex) {
            // empty catch block
        }
        Assert.assertNotNull((Object)templateBuilder.imageId(this.image.getId()).build());
        templateBuilder.imageId(null);
        Template template = templateBuilder.osNameMatches(this.image.getOperatingSystem().getName()).build();
        Assert.assertEquals((String)template.getImage().getId(), (String)this.image.getId());
        EasyMock.verify((Object[])new Object[]{getImageStrategy});
    }

    @Test
    public void testHardwareIdNullsHypervisor() {
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of());
        Location defaultLocation = (Location)EasyMock.createMock(Location.class);
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        EasyMock.replay((Object[])new Object[]{defaultLocation, optionsProvider, templateBuilderProvider, getImageStrategy});
        TemplateBuilderImpl template = this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, defaultLocation, (Provider<TemplateOptions>)optionsProvider, (Provider<TemplateBuilder>)templateBuilderProvider, getImageStrategy);
        template.hypervisorMatches("OpenVZ");
        Assert.assertEquals((String)template.hardwareId, null);
        Assert.assertEquals((String)template.hypervisor, (String)"OpenVZ");
        template.hardwareId("myid");
        Assert.assertEquals((String)template.hardwareId, (String)"myid");
        Assert.assertEquals((String)template.hypervisor, null);
        EasyMock.verify((Object[])new Object[]{defaultLocation, optionsProvider, templateBuilderProvider, getImageStrategy});
    }

    @Test
    public void testMatchesHardwareWithIdPredicate() {
        final Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        final Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new ImageBuilder().ids("Ubuntu 11.04 x64").name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").location(this.region).status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").is64Bit(true).version("11.04").family(OsFamily.UBUNTU).build()).build(), (Object)new ImageBuilder().ids("Ubuntu 11.04 64-bit").name("Ubuntu 11.04 64-bit").description("Ubuntu 11.04 64-bit").location(this.region).status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu 11.04 64-bit").description("Ubuntu 11.04 64-bit").is64Bit(true).version("11.04").family(OsFamily.UBUNTU).build()).build()));
        final Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new HardwareBuilder().ids(String.format("datacenter(%s)platform(%s)cpuCores(%d)memorySizeMB(%d)diskSizeGB(%d)", "Falkenberg", "Xen", 1, 512, 5)).ram(512).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(5.0f), true, true))).hypervisor("Xen").location(this.region).supportsImage(ImagePredicates.idIn((Iterable)ImmutableSet.of((Object)"Ubuntu 11.04 x64"))).build(), (Object)new HardwareBuilder().ids(String.format("datacenter(%s)platform(%s)cpuCores(%d)memorySizeMB(%d)diskSizeGB(%d)", "Falkenberg", "OpenVZ", 1, 512, 5)).ram(512).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(5.0f), true, true))).hypervisor("OpenVZ").location(this.region).supportsImage(ImagePredicates.idIn((Iterable)ImmutableSet.of((Object)"Ubuntu 11.04 64-bit"))).build()));
        Provider<TemplateOptions> optionsProvider = new Provider<TemplateOptions>(){

            public TemplateOptions get() {
                return new TemplateOptions();
            }
        };
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        Provider<TemplateBuilder> templateBuilderProvider = new Provider<TemplateBuilder>((Provider)optionsProvider, getImageStrategy){
            final /* synthetic */ Provider val$optionsProvider;
            final /* synthetic */ GetImageStrategy val$getImageStrategy;
            {
                this.val$optionsProvider = provider;
                this.val$getImageStrategy = getImageStrategy;
            }

            public TemplateBuilder get() {
                return TemplateBuilderImplTest.this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, TemplateBuilderImplTest.this.region, (Provider<TemplateOptions>)this.val$optionsProvider, this, this.val$getImageStrategy);
            }
        };
        TemplateBuilder templateBuilder = ((TemplateBuilder)templateBuilderProvider.get()).minRam(512).osFamily(OsFamily.UBUNTU).hypervisorMatches("OpenVZ").osVersionMatches("1[10].[10][04]").os64Bit(true);
        Assert.assertEquals((String)templateBuilder.toString(), (String)"{minRam=512, minRam=512, osFamily=ubuntu, osVersion=1[10].[10][04], os64Bit=true, hypervisor=OpenVZ}");
        Template template = templateBuilder.build();
        Assert.assertEquals((String)template.getHardware().getHypervisor(), (String)"OpenVZ");
        Assert.assertEquals((String)template.getImage().getId(), (String)"Ubuntu 11.04 64-bit");
    }

    @Test
    public void testImageLocationNonDefault() {
        final Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        final Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new ImageBuilder().id("us-east-2/ami-ffff").providerId("ami-ffff").name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").location(this.region2).status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").is64Bit(true).version("11.04").family(OsFamily.UBUNTU).build()).build()));
        final Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new HardwareBuilder().ids("m1.small").ram(512).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(5.0f), true, true))).build()));
        Provider<TemplateOptions> optionsProvider = new Provider<TemplateOptions>(){

            public TemplateOptions get() {
                return new TemplateOptions();
            }
        };
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        Provider<TemplateBuilder> templateBuilderProvider = new Provider<TemplateBuilder>((Provider)optionsProvider, getImageStrategy){
            final /* synthetic */ Provider val$optionsProvider;
            final /* synthetic */ GetImageStrategy val$getImageStrategy;
            {
                this.val$optionsProvider = provider;
                this.val$getImageStrategy = getImageStrategy;
            }

            public TemplateBuilder get() {
                return TemplateBuilderImplTest.this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, TemplateBuilderImplTest.this.region, (Provider<TemplateOptions>)this.val$optionsProvider, this, this.val$getImageStrategy);
            }
        };
        TemplateBuilder templateBuilder = ((TemplateBuilder)templateBuilderProvider.get()).hardwareId("m1.small").imageId("us-east-2/ami-ffff");
        Assert.assertEquals((String)templateBuilder.toString(), (String)"{imageId=us-east-2/ami-ffff, hardwareId=m1.small}");
        Template template = templateBuilder.build();
        Assert.assertEquals((String)template.getLocation().getId(), (String)"us-east-2");
    }

    @Test
    public void testFromSpecWithLoginUser() {
        final Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.region));
        final Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new ImageBuilder().id("us-east-2/ami-ffff").providerId("ami-ffff").name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").location(this.region2).status(Image.Status.AVAILABLE).operatingSystem(OperatingSystem.builder().name("Ubuntu 11.04 x64").description("Ubuntu 11.04 x64").is64Bit(true).version("11.04").family(OsFamily.UBUNTU).build()).build()));
        final Supplier hardwares = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new HardwareBuilder().ids("m1.small").ram(512).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(5.0f), true, true))).build()));
        Provider<TemplateOptions> optionsProvider = new Provider<TemplateOptions>(){

            public TemplateOptions get() {
                return new TemplateOptions();
            }
        };
        GetImageStrategy getImageStrategy = (GetImageStrategy)EasyMock.createMock(GetImageStrategy.class);
        Provider<TemplateBuilder> templateBuilderProvider = new Provider<TemplateBuilder>((Provider)optionsProvider, getImageStrategy){
            final /* synthetic */ Provider val$optionsProvider;
            final /* synthetic */ GetImageStrategy val$getImageStrategy;
            {
                this.val$optionsProvider = provider;
                this.val$getImageStrategy = getImageStrategy;
            }

            public TemplateBuilder get() {
                return TemplateBuilderImplTest.this.createTemplateBuilder(null, (Supplier<Set<? extends Location>>)locations, (Supplier<Set<? extends Image>>)images, (Supplier<Set<? extends Hardware>>)hardwares, TemplateBuilderImplTest.this.region, (Provider<TemplateOptions>)this.val$optionsProvider, this, this.val$getImageStrategy);
            }
        };
        TemplateBuilder templateBuilder = ((TemplateBuilder)templateBuilderProvider.get()).from("hardwareId=m1.small,imageId=us-east-2/ami-ffff,loginUser=user:Password01,authenticateSudo=true");
        Assert.assertEquals((String)templateBuilder.toString(), (String)"{imageId=us-east-2/ami-ffff, hardwareId=m1.small}");
        Template template = templateBuilder.build();
        Assert.assertEquals((String)template.getLocation().getId(), (String)"us-east-2");
        Assert.assertEquals((String)template.getOptions().getLoginUser(), (String)"user");
        Assert.assertEquals((String)template.getOptions().getLoginPassword(), (String)"Password01");
        Assert.assertEquals((String)template.getOptions().getLoginPrivateKey(), null);
        Assert.assertEquals((Object)template.getOptions().shouldAuthenticateSudo(), (Object)Boolean.TRUE);
    }
}

