/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.extensions.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public abstract class BaseSecurityGroupExtensionLiveTest
extends BaseComputeServiceContextLiveTest {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final String secGroupName = "test-create-security-group";
    protected final String nodeGroup = "test-create-node-with-group";
    protected String groupId;
    protected boolean securityGroupsSupported = true;

    public Template getNodeTemplate() {
        return ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
    }

    protected void skipIfSecurityGroupsNotSupported() {
        if (!this.securityGroupsSupported) {
            throw new SkipException("Test cannot run without security groups available.");
        }
    }

    @Test(groups={"integration", "live"}, singleThreaded=true)
    public void testCreateSecurityGroup() throws RunNodesException, InterruptedException, ExecutionException {
        this.skipIfSecurityGroupsNotSupported();
        ComputeService computeService = ((ComputeServiceContext)this.view).getComputeService();
        Location location = this.getNodeTemplate().getLocation();
        Optional securityGroupExtension = computeService.getSecurityGroupExtension();
        Assert.assertTrue((boolean)securityGroupExtension.isPresent(), (String)"security extension was not present");
        SecurityGroup group = ((SecurityGroupExtension)securityGroupExtension.get()).createSecurityGroup("test-create-security-group", location);
        this.logger.info("Group created: %s", new Object[]{group});
        Assert.assertTrue((boolean)group.getName().contains("test-create-security-group"));
        this.groupId = group.getId();
    }

    @Test(groups={"integration", "live"}, singleThreaded=true, dependsOnMethods={"testCreateSecurityGroup"})
    public void testGetSecurityGroupById() throws RunNodesException, InterruptedException, ExecutionException {
        this.skipIfSecurityGroupsNotSupported();
        ComputeService computeService = ((ComputeServiceContext)this.view).getComputeService();
        Location location = this.getNodeTemplate().getLocation();
        Optional securityGroupExtension = computeService.getSecurityGroupExtension();
        Assert.assertTrue((boolean)securityGroupExtension.isPresent(), (String)"security extension was not present");
        SecurityGroup group = ((SecurityGroupExtension)securityGroupExtension.get()).getSecurityGroupById(this.groupId);
        this.logger.info("Group found: %s", new Object[]{group});
        Assert.assertTrue((boolean)group.getName().contains("test-create-security-group"));
    }

    @Test(groups={"integration", "live"}, singleThreaded=true, dependsOnMethods={"testGetSecurityGroupById"})
    public void testAddIpPermission() {
        this.skipIfSecurityGroupsNotSupported();
        ComputeService computeService = ((ComputeServiceContext)this.view).getComputeService();
        Optional securityGroupExtension = computeService.getSecurityGroupExtension();
        Assert.assertTrue((boolean)securityGroupExtension.isPresent(), (String)"security group extension was not present");
        Optional<SecurityGroup> optGroup = this.getGroup((SecurityGroupExtension)securityGroupExtension.get());
        Assert.assertTrue((boolean)optGroup.isPresent());
        SecurityGroup group = (SecurityGroup)optGroup.get();
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.TCP);
        builder.fromPort(10);
        builder.toPort(20);
        builder.cidrBlock("0.0.0.0/0");
        IpPermission perm = builder.build();
        SecurityGroup newGroup = ((SecurityGroupExtension)securityGroupExtension.get()).addIpPermission(perm, group);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)newGroup.getIpPermissions()), (Object)perm, (String)("Expecting IpPermission " + perm + " but group was " + newGroup));
    }

    @Test(groups={"integration", "live"}, singleThreaded=true, dependsOnMethods={"testAddIpPermission"})
    public void testRemoveIpPermission() {
        this.skipIfSecurityGroupsNotSupported();
        ComputeService computeService = ((ComputeServiceContext)this.view).getComputeService();
        Optional securityGroupExtension = computeService.getSecurityGroupExtension();
        Assert.assertTrue((boolean)securityGroupExtension.isPresent(), (String)"security group extension was not present");
        Optional<SecurityGroup> optGroup = this.getGroup((SecurityGroupExtension)securityGroupExtension.get());
        Assert.assertTrue((boolean)optGroup.isPresent());
        SecurityGroup group = (SecurityGroup)optGroup.get();
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.TCP);
        builder.fromPort(10);
        builder.toPort(20);
        builder.cidrBlock("0.0.0.0/0");
        IpPermission perm = builder.build();
        SecurityGroup newGroup = ((SecurityGroupExtension)securityGroupExtension.get()).removeIpPermission(perm, group);
        Assert.assertEquals((int)Iterables.size((Iterable)newGroup.getIpPermissions()), (int)0, (String)("Group should have no permissions, but has " + Iterables.size((Iterable)newGroup.getIpPermissions())));
    }

    @Test(groups={"integration", "live"}, singleThreaded=true, dependsOnMethods={"testRemoveIpPermission"})
    public void testAddIpPermissionsFromSpec() {
        int toPort;
        int fromPort;
        this.skipIfSecurityGroupsNotSupported();
        ComputeService computeService = ((ComputeServiceContext)this.view).getComputeService();
        Optional securityGroupExtension = computeService.getSecurityGroupExtension();
        Assert.assertTrue((boolean)securityGroupExtension.isPresent(), (String)"security group extension was not present");
        Optional<SecurityGroup> optGroup = this.getGroup((SecurityGroupExtension)securityGroupExtension.get());
        Assert.assertTrue((boolean)optGroup.isPresent());
        SecurityGroup group = (SecurityGroup)optGroup.get();
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.TCP);
        builder.fromPort(50);
        builder.toPort(60);
        builder.cidrBlock("0.0.0.0/0");
        IpPermission perm = builder.build();
        SecurityGroup newGroup = ((SecurityGroupExtension)securityGroupExtension.get()).addIpPermission(IpProtocol.TCP, 50, 60, this.emptyMultimap(), (Iterable)ImmutableSet.of((Object)"0.0.0.0/0"), this.emptyStringSet(), group);
        Assert.assertTrue((boolean)newGroup.getIpPermissions().contains(perm));
        if (((SecurityGroupExtension)securityGroupExtension.get()).supportsGroupIds()) {
            IpPermission.Builder secondBuilder = IpPermission.builder();
            if (((SecurityGroupExtension)securityGroupExtension.get()).supportsPortRangesForGroups()) {
                fromPort = 70;
                toPort = 80;
            } else {
                fromPort = 1;
                toPort = 65535;
            }
            secondBuilder.ipProtocol(IpProtocol.TCP);
            secondBuilder.fromPort(fromPort);
            secondBuilder.toPort(toPort);
            secondBuilder.groupId(group.getId());
            IpPermission secondPerm = secondBuilder.build();
            SecurityGroup secondNewGroup = ((SecurityGroupExtension)securityGroupExtension.get()).addIpPermission(IpProtocol.TCP, fromPort, toPort, this.emptyMultimap(), this.emptyStringSet(), (Iterable)ImmutableSet.of((Object)group.getId()), newGroup);
            Assert.assertTrue((boolean)secondNewGroup.getIpPermissions().contains(secondPerm), (String)("permissions for second group should contain " + secondPerm + " but do not: " + secondNewGroup.getIpPermissions()));
        }
        if (((SecurityGroupExtension)securityGroupExtension.get()).supportsTenantIdGroupNamePairs() || ((SecurityGroupExtension)securityGroupExtension.get()).supportsTenantIdGroupIdPairs()) {
            IpPermission.Builder thirdBuilder = IpPermission.builder();
            if (((SecurityGroupExtension)securityGroupExtension.get()).supportsPortRangesForGroups()) {
                fromPort = 90;
                toPort = 100;
            } else {
                fromPort = 1;
                toPort = 65535;
            }
            thirdBuilder.ipProtocol(IpProtocol.TCP);
            thirdBuilder.fromPort(fromPort);
            thirdBuilder.toPort(toPort);
            if (((SecurityGroupExtension)securityGroupExtension.get()).supportsTenantIdGroupIdPairs()) {
                thirdBuilder.tenantIdGroupNamePair(group.getOwnerId(), group.getProviderId());
            } else if (((SecurityGroupExtension)securityGroupExtension.get()).supportsTenantIdGroupNamePairs()) {
                thirdBuilder.tenantIdGroupNamePair(group.getOwnerId(), group.getName());
            }
            IpPermission thirdPerm = thirdBuilder.build();
            SecurityGroup thirdNewGroup = ((SecurityGroupExtension)securityGroupExtension.get()).addIpPermission(IpProtocol.TCP, fromPort, toPort, thirdPerm.getTenantIdGroupNamePairs(), this.emptyStringSet(), this.emptyStringSet(), newGroup);
            Assert.assertTrue((boolean)thirdNewGroup.getIpPermissions().contains(thirdPerm));
        }
    }

    @Test(groups={"integration", "live"}, singleThreaded=true, dependsOnMethods={"testAddIpPermissionsFromSpec"})
    public void testDeleteSecurityGroup() {
        this.skipIfSecurityGroupsNotSupported();
        ComputeService computeService = ((ComputeServiceContext)this.view).getComputeService();
        Optional securityGroupExtension = computeService.getSecurityGroupExtension();
        Assert.assertTrue((boolean)securityGroupExtension.isPresent(), (String)"security group extension was not present");
        Optional<SecurityGroup> optGroup = this.getGroup((SecurityGroupExtension)securityGroupExtension.get());
        Assert.assertTrue((boolean)optGroup.isPresent());
        SecurityGroup group = (SecurityGroup)optGroup.get();
        Assert.assertTrue((boolean)((SecurityGroupExtension)securityGroupExtension.get()).removeSecurityGroup(group.getId()));
    }

    private Multimap<String, String> emptyMultimap() {
        return LinkedHashMultimap.create();
    }

    private Set<String> emptyStringSet() {
        return Sets.newLinkedHashSet();
    }

    private Optional<SecurityGroup> getGroup(SecurityGroupExtension ext) {
        return Iterables.tryFind((Iterable)ext.listSecurityGroups(), (Predicate)new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup input) {
                return input.getId().equals(BaseSecurityGroupExtensionLiveTest.this.groupId);
            }
        });
    }

    private void cleanup() {
        Optional<SecurityGroup> group;
        ComputeService computeService;
        Optional securityGroupExtension;
        if (this.securityGroupsSupported && (securityGroupExtension = (computeService = ((ComputeServiceContext)this.view).getComputeService()).getSecurityGroupExtension()).isPresent() && (group = this.getGroup((SecurityGroupExtension)securityGroupExtension.get())).isPresent()) {
            ((SecurityGroupExtension)securityGroupExtension.get()).removeSecurityGroup(((SecurityGroup)group.get()).getId());
        }
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        try {
            this.cleanup();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDownContext();
    }
}

