/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.rest.HttpClient;
import org.jclouds.ssh.SshKeys;
import org.testng.Assert;

public class ComputeTestUtils {
    public static Map<String, String> setupKeyPair() {
        String secretKeyFile;
        try {
            secretKeyFile = (String)Preconditions.checkNotNull((Object)System.getProperty("test.ssh.keyfile"), (Object)"test.ssh.keyfile");
        }
        catch (NullPointerException e) {
            secretKeyFile = System.getProperty("user.home") + "/.ssh/id_rsa";
        }
        try {
            ComputeTestUtils.checkSecretKeyFile(secretKeyFile);
        }
        catch (IllegalStateException e) {
            return SshKeys.generate();
        }
        try {
            String secret = Files.toString((File)new File(secretKeyFile), (Charset)Charsets.UTF_8);
            assert (secret.startsWith("-----BEGIN RSA PRIVATE KEY-----")) : "invalid key:\n" + secret;
            return ImmutableMap.of((Object)"private", (Object)secret, (Object)"public", (Object)Files.toString((File)new File(secretKeyFile + ".pub"), (Charset)Charsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void checkSecretKeyFile(String secretKeyFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)secretKeyFile), (Object)"System property: [test.ssh.keyfile] set to an empty string");
        if (!new File(secretKeyFile).exists()) {
            throw new IllegalStateException("secretKeyFile not found at: " + secretKeyFile);
        }
    }

    public static void checkHttpGet(HttpClient client, NodeMetadata node, int port) {
        for (int i = 0; i < 5; ++i) {
            try {
                assert (client.get(URI.create(String.format("http://%s:%d", Iterables.get((Iterable)node.getPublicAddresses(), (int)0), port))) != null);
                break;
            }
            catch (UndeclaredThrowableException e) {
                Assert.assertEquals(e.getCause().getClass(), TimeoutException.class);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
    }
}

