/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.compute.callables.BlockUntilInitScriptStatusIsZeroThenReturnOutput;
import org.jclouds.compute.callables.InitScriptConfigurationForTasks;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.ssh.SshClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilCompleteTest")
public class RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilCompleteTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new ExecutorServiceModule(MoreExecutors.sameThreadExecutor()), new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.user-threads")).to(1);
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.compute.timeout.script-complete")).to(100);
            this.install(new FactoryModuleBuilder().build(BlockUntilInitScriptStatusIsZeroThenReturnOutput.Factory.class));
        }
    }});
    EventBus eventBus = new EventBus();
    BlockUntilInitScriptStatusIsZeroThenReturnOutput.Factory statusFactory = (BlockUntilInitScriptStatusIsZeroThenReturnOutput.Factory)this.injector.getInstance(BlockUntilInitScriptStatusIsZeroThenReturnOutput.Factory.class);
    ComputeServiceConstants.Timeouts timeouts = (ComputeServiceConstants.Timeouts)this.injector.getInstance(ComputeServiceConstants.Timeouts.class);

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWithoutInitThrowsIllegalStateException() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("testpassword!").build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete testMe = new RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete(this.statusFactory, this.timeouts, Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions());
        testMe.call();
    }

    public void testDefault() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("testpassword!").build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        InitScript init = InitScript.builder().name("jclouds-script-0").home("/tmp/jclouds-script-0").run(command).build();
        sshClient.connect();
        sshClient.put("/tmp/init-jclouds-script-0", init.render(OsFamily.UNIX));
        EasyMock.expect((Object)sshClient.getUsername()).andReturn((Object)"tester").atLeastOnce();
        EasyMock.expect((Object)sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com").atLeastOnce();
        EasyMock.expect((Object)sshClient.exec("chmod 755 /tmp/init-jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("ln -fs /tmp/init-jclouds-script-0 jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 init")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("sudo /tmp/init-jclouds-script-0 start")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 status")).andReturn((Object)new ExecResponse("", "", 1)).times(1);
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stdout")).andReturn((Object)new ExecResponse("out", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stderr")).andReturn((Object)new ExecResponse("err", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 exitstatus")).andReturn((Object)new ExecResponse("0", "", 0));
        sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete testMe = new RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete(this.statusFactory, this.timeouts, Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions());
        Assert.assertEquals((String)testMe.getInitFile(), (String)"/tmp/init-jclouds-script-0");
        Assert.assertEquals((Object)testMe.getNode(), (Object)node);
        Assert.assertEquals((Object)testMe.getStatement(), (Object)init);
        testMe.init();
        Assert.assertEquals((Object)testMe.call(), (Object)new ExecResponse("out", "err", 0));
        EasyMock.verify((Object[])new Object[]{sshClient});
    }

    public void testWithSudoPassword() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("testpassword!").authenticateSudo(true).build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        InitScript init = InitScript.builder().name("jclouds-script-0").home("/tmp/jclouds-script-0").run(command).build();
        sshClient.connect();
        sshClient.put("/tmp/init-jclouds-script-0", init.render(OsFamily.UNIX));
        EasyMock.expect((Object)sshClient.getUsername()).andReturn((Object)"tester").atLeastOnce();
        EasyMock.expect((Object)sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com").atLeastOnce();
        EasyMock.expect((Object)sshClient.exec("chmod 755 /tmp/init-jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("ln -fs /tmp/init-jclouds-script-0 jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 init")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("echo 'testpassword!'|sudo -S /tmp/init-jclouds-script-0 start")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 status")).andReturn((Object)new ExecResponse("", "", 1));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stdout")).andReturn((Object)new ExecResponse("out", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stderr")).andReturn((Object)new ExecResponse("err", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 exitstatus")).andReturn((Object)new ExecResponse("0", "", 0));
        sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete testMe = new RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete(this.statusFactory, this.timeouts, Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions());
        Assert.assertEquals((String)testMe.getInitFile(), (String)"/tmp/init-jclouds-script-0");
        Assert.assertEquals((Object)testMe.getNode(), (Object)node);
        Assert.assertEquals((Object)testMe.getStatement(), (Object)init);
        testMe.init();
        Assert.assertEquals((Object)testMe.call(), (Object)new ExecResponse("out", "err", 0));
        EasyMock.verify((Object[])new Object[]{sshClient});
    }

    public void testDoublecheckStatusInCaseTransientlyWrong() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("testpassword!").authenticateSudo(true).build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        InitScript init = InitScript.builder().name("jclouds-script-0").home("/tmp/jclouds-script-0").run(command).build();
        sshClient.connect();
        sshClient.put("/tmp/init-jclouds-script-0", init.render(OsFamily.UNIX));
        EasyMock.expect((Object)sshClient.getUsername()).andReturn((Object)"tester").atLeastOnce();
        EasyMock.expect((Object)sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com").atLeastOnce();
        EasyMock.expect((Object)sshClient.exec("chmod 755 /tmp/init-jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("ln -fs /tmp/init-jclouds-script-0 jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 init")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("echo 'testpassword!'|sudo -S /tmp/init-jclouds-script-0 start")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 status")).andReturn((Object)new ExecResponse("8001", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 status")).andReturn((Object)new ExecResponse("", "", 1));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stdout")).andReturn((Object)new ExecResponse("out", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stderr")).andReturn((Object)new ExecResponse("err", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 exitstatus")).andReturn((Object)new ExecResponse("0", "", 0));
        sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete testMe = new RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete(this.statusFactory, this.timeouts, Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions());
        Assert.assertEquals((String)testMe.getInitFile(), (String)"/tmp/init-jclouds-script-0");
        Assert.assertEquals((Object)testMe.getNode(), (Object)node);
        Assert.assertEquals((Object)testMe.getStatement(), (Object)init);
        testMe.init();
        Assert.assertEquals((Object)testMe.call(), (Object)new ExecResponse("out", "err", 0));
        EasyMock.verify((Object[])new Object[]{sshClient});
    }

    public void testNotRoot() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("id").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("testpassword!").authenticateSudo(true).build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        InitScript init = InitScript.builder().name("jclouds-script-0").home("/tmp/jclouds-script-0").run(command).build();
        sshClient.connect();
        sshClient.put("/tmp/init-jclouds-script-0", init.render(OsFamily.UNIX));
        EasyMock.expect((Object)sshClient.getUsername()).andReturn((Object)"tester").atLeastOnce();
        EasyMock.expect((Object)sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com").atLeastOnce();
        EasyMock.expect((Object)sshClient.exec("chmod 755 /tmp/init-jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("ln -fs /tmp/init-jclouds-script-0 jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 init")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 start")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 status")).andReturn((Object)new ExecResponse("", "", 1));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stdout")).andReturn((Object)new ExecResponse("out", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stderr")).andReturn((Object)new ExecResponse("err", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 exitstatus")).andReturn((Object)new ExecResponse("0", "", 0));
        sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete testMe = new RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete(this.statusFactory, this.timeouts, Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions().runAsRoot(false));
        Assert.assertEquals((String)testMe.getInitFile(), (String)"/tmp/init-jclouds-script-0");
        Assert.assertEquals((Object)testMe.getNode(), (Object)node);
        Assert.assertEquals((Object)testMe.getStatement(), (Object)init);
        testMe.init();
        Assert.assertEquals((Object)testMe.call(), (Object)new ExecResponse("out", "err", 0));
        EasyMock.verify((Object[])new Object[]{sshClient});
    }

    public void testBadReturnCode() {
        Statement command = Statements.exec((String)"doFoo");
        NodeMetadata node = new NodeMetadataBuilder().ids("badreturncode").status(NodeMetadata.Status.RUNNING).credentials(LoginCredentials.builder().user("tester").password("testpassword!").authenticateSudo(true).build()).build();
        SshClient sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        InitScript init = InitScript.builder().name("jclouds-script-0").home("/tmp/jclouds-script-0").run(command).build();
        sshClient.connect();
        sshClient.put("/tmp/init-jclouds-script-0", init.render(OsFamily.UNIX));
        EasyMock.expect((Object)sshClient.getUsername()).andReturn((Object)"tester").atLeastOnce();
        EasyMock.expect((Object)sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com").atLeastOnce();
        EasyMock.expect((Object)sshClient.exec("chmod 755 /tmp/init-jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("ln -fs /tmp/init-jclouds-script-0 jclouds-script-0")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 init")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 start")).andReturn((Object)new ExecResponse("", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 status")).andReturn((Object)new ExecResponse("", "", 1));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stdout")).andReturn((Object)new ExecResponse("out", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 stderr")).andReturn((Object)new ExecResponse("err", "", 0));
        EasyMock.expect((Object)sshClient.exec("/tmp/init-jclouds-script-0 exitstatus")).andReturn((Object)new ExecResponse("1", "", 0));
        sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{sshClient});
        RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete testMe = new RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete(this.statusFactory, this.timeouts, Functions.forMap((Map)ImmutableMap.of((Object)node, (Object)sshClient)), this.eventBus, InitScriptConfigurationForTasks.create().appendIncrementingNumberToAnonymousTaskNames(), node, command, new RunScriptOptions().runAsRoot(false));
        Assert.assertEquals((String)testMe.getInitFile(), (String)"/tmp/init-jclouds-script-0");
        Assert.assertEquals((Object)testMe.getNode(), (Object)node);
        Assert.assertEquals((Object)testMe.getStatement(), (Object)init);
        testMe.init();
        Assert.assertEquals((Object)testMe.call(), (Object)new ExecResponse("out", "err", 1));
        EasyMock.verify((Object[])new Object[]{sshClient});
    }
}

