/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.net.util;

import com.google.common.collect.ImmutableSet;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.net.util.IpPermissions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="IpPermissionsTest")
public class IpPermissionsTest {
    public void testAllProtocol() {
        IpPermissions.ToSourceSelection authorization = IpPermissions.permitAnyProtocol();
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ALL).fromPort(1).toPort(65535).cidrBlock("0.0.0.0/0").build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAllProtocolInvalidCidr() {
        IpPermissions.ToSourceSelection authorization = IpPermissions.permitAnyProtocol();
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ALL).fromPort(1).toPort(65535).cidrBlock("a.0.0.0/0").build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAllProtocolInvalidExclusionCidr() {
        IpPermissions.ToSourceSelection authorization = IpPermissions.permitAnyProtocol();
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ALL).fromPort(1).toPort(65535).exclusionCidrBlock("a.0.0.0/0").build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAllProtocolInvalidCidrMultiple() {
        IpPermissions.ToSourceSelection authorization = IpPermissions.permitAnyProtocol();
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ALL).fromPort(1).toPort(65535).cidrBlocks((Iterable)ImmutableSet.of((Object)"a.0.0.0/0", (Object)"0.0.0.0/0")).build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAllProtocolInvalidExclusionCidrMultiple() {
        IpPermissions.ToSourceSelection authorization = IpPermissions.permitAnyProtocol();
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ALL).fromPort(1).toPort(65535).exclusionCidrBlocks((Iterable)ImmutableSet.of((Object)"a.0.0.0/0", (Object)"0.0.0.0/0")).build());
    }

    public void testAllProtocolCidrBound() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.ALL).originatingFromCidrBlock("1.1.1.1/32");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ALL).fromPort(1).toPort(65535).cidrBlock("1.1.1.1/32").build());
    }

    public void testAllProtocolExclusionCidrBound() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.ALL).exceptOriginatingFromCidrBlock("1.1.1.1/32");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ALL).fromPort(1).toPort(65535).exclusionCidrBlock("1.1.1.1/32").build());
    }

    public void testJustProtocolAndCidr() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.TCP).originatingFromCidrBlock("1.1.1.1/32");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(1).toPort(65535).cidrBlock("1.1.1.1/32").build());
    }

    public void testJustProtocolAndExcludedCidr() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.TCP).exceptOriginatingFromCidrBlock("1.1.1.1/32");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(1).toPort(65535).exclusionCidrBlock("1.1.1.1/32").build());
    }

    public void testAnyProtocol() {
        IpPermissions authorization = IpPermissions.permitAnyProtocol().originatingFromCidrBlock("1.1.1.1/32");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ALL).fromPort(1).toPort(65535).cidrBlock("1.1.1.1/32").build());
    }

    public void testAnyProtocolWithExcludedCidr() {
        IpPermissions authorization = IpPermissions.permitAnyProtocol().exceptOriginatingFromCidrBlock("1.1.1.1/32");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ALL).fromPort(1).toPort(65535).exclusionCidrBlock("1.1.1.1/32").build());
    }

    public void testMultipleCidrs() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.TCP).originatingFromCidrBlocks((Iterable)ImmutableSet.of((Object)"1.1.1.1/32", (Object)"1.1.1.2/32"));
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(1).toPort(65535).cidrBlocks((Iterable)ImmutableSet.of((Object)"1.1.1.1/32", (Object)"1.1.1.2/32")).build());
    }

    public void testMultipleCidrsExclusions() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.TCP).exceptOriginatingFromCidrBlocks((Iterable)ImmutableSet.of((Object)"1.1.1.1/32", (Object)"1.1.1.2/32"));
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.TCP).fromPort(1).toPort(65535).exclusionCidrBlocks((Iterable)ImmutableSet.of((Object)"1.1.1.1/32", (Object)"1.1.1.2/32")).build());
    }

    public void testProtocolFromAndToPortAndGroupIds() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.UDP).fromPort(11).to(53).originatingFromSecurityGroupId("groupId");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.UDP).fromPort(11).toPort(53).groupId("groupId").build());
    }

    public void testProtocolICMPAny() {
        IpPermissions authorization = IpPermissions.permitICMP().originatingFromSecurityGroupId("groupId");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ICMP).fromPort(-1).toPort(-1).groupId("groupId").build());
    }

    public void testProtocolICMPTypeAnyCode() {
        IpPermissions authorization = IpPermissions.permitICMP().type(8).originatingFromSecurityGroupId("groupId");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ICMP).fromPort(8).toPort(-1).groupId("groupId").build());
    }

    public void testProtocolICMPTypeCode() {
        IpPermissions authorization = IpPermissions.permitICMP().type(8).andCode(0).originatingFromSecurityGroupId("groupId");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ICMP).fromPort(8).toPort(0).groupId("groupId").build());
    }

    public void testProtocolFromAndToPortAndUserGroups() {
        IpPermissions authorization = IpPermissions.permit((IpProtocol)IpProtocol.ICMP).fromPort(8).to(0).originatingFromTenantAndSecurityGroup("tenantId", "groupName");
        Assert.assertEquals((Object)authorization, (Object)IpPermission.builder().ipProtocol(IpProtocol.ICMP).fromPort(8).toPort(0).tenantIdGroupNamePair("tenantId", "groupName").build());
    }
}

