/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh;

import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import org.jclouds.crypto.Pems;
import org.jclouds.ssh.SshKeys;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="SshKeysTest")
public class SshKeysTest {
    String expectedFingerprint = "2b:a9:62:95:5b:8b:1d:61:e0:92:f7:03:10:e9:db:d9";
    String expectedSha1 = "c8:01:34:c0:3c:8c:91:ac:e1:da:cf:72:15:d7:f2:e5:99:5b:28:d4";

    @Test
    public void testCanReadRsaAndCompareFingerprintOnPublicRSAKey() throws IOException {
        String pubKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test.pub"));
        RSAPublicKeySpec key = SshKeys.publicKeySpecFromOpenSSH((String)pubKey);
        String fingerPrint = SshKeys.fingerprint((BigInteger)key.getPublicExponent(), (BigInteger)key.getModulus());
        Assert.assertEquals((String)fingerPrint, (String)this.expectedFingerprint);
    }

    @Test
    public void testCanReadRsaAndCompareFingerprintOnPrivateRSAKey() throws IOException {
        String privKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test"));
        RSAPrivateCrtKeySpec key = (RSAPrivateCrtKeySpec)Pems.privateKeySpec((String)privKey);
        String fingerPrint = SshKeys.fingerprint((BigInteger)key.getPublicExponent(), (BigInteger)key.getModulus());
        Assert.assertEquals((String)fingerPrint, (String)this.expectedFingerprint);
    }

    @Test
    public void testPrivateKeyMatchesFingerprintTyped() throws IOException {
        String privKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test"));
        RSAPrivateCrtKeySpec privateKey = (RSAPrivateCrtKeySpec)Pems.privateKeySpec((String)privKey);
        assert (SshKeys.privateKeyHasFingerprint((RSAPrivateCrtKeySpec)privateKey, (String)this.expectedFingerprint));
    }

    @Test
    public void testPrivateKeyMatchesFingerprintString() throws IOException {
        String privKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test"));
        assert (SshKeys.privateKeyHasFingerprint((String)privKey, (String)this.expectedFingerprint));
    }

    @Test
    public void testPrivateKeyMatchesSha1Typed() throws IOException {
        String privKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test"));
        RSAPrivateCrtKeySpec privateKey = (RSAPrivateCrtKeySpec)Pems.privateKeySpec((String)privKey);
        assert (SshKeys.privateKeyHasSha1((RSAPrivateCrtKeySpec)privateKey, (String)this.expectedSha1));
    }

    @Test
    public void testPrivateKeyMatchesSha1String() throws IOException {
        String privKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test"));
        assert (SshKeys.privateKeyHasSha1((String)privKey, (String)this.expectedSha1));
    }

    @Test
    public void testPrivateKeyMatchesPublicKeyTyped() throws IOException {
        String privKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test"));
        RSAPrivateCrtKeySpec privateKey = (RSAPrivateCrtKeySpec)Pems.privateKeySpec((String)privKey);
        String pubKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test.pub"));
        RSAPublicKeySpec publicKey = SshKeys.publicKeySpecFromOpenSSH((String)pubKey);
        assert (SshKeys.privateKeyMatchesPublicKey((RSAPrivateCrtKeySpec)privateKey, (RSAPublicKeySpec)publicKey));
    }

    @Test
    public void testPrivateKeyMatchesPublicKeyString() throws IOException {
        String privKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test"));
        String pubKey = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test.pub"));
        assert (SshKeys.privateKeyMatchesPublicKey((String)privKey, (String)pubKey));
    }

    @Test
    public void testCanGenerate() {
        Map map = SshKeys.generate();
        assert (((String)map.get("public")).startsWith("ssh-rsa ")) : map;
        assert (((String)map.get("private")).startsWith("-----BEGIN RSA PRIVATE KEY-----")) : map;
        assert (SshKeys.privateKeyMatchesPublicKey((String)((String)map.get("private")), (String)((String)map.get("public")))) : map;
    }

    @Test
    public void testEncodeAsOpenSSH() throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        String encoded = SshKeys.encodeAsOpenSSH((RSAPublicKey)((RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(SshKeys.publicKeySpecFromOpenSSH((ByteSource)Resources.asByteSource((URL)Resources.getResource(this.getClass(), (String)"/test.pub"))))));
        Assert.assertEquals((String)encoded, (String)Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test.pub")).trim());
    }
}

