/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Function;
import com.google.common.eventbus.EventBus;
import org.easymock.EasyMock;
import org.jclouds.compute.callables.RunScriptOnNodeUsingSsh;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.login.UserAdd;
import org.jclouds.ssh.SshClient;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class RunScriptOnNodeUsingSshTest {
    EventBus eventBus = new EventBus();
    private SshClient sshClient;
    private NodeMetadata node;
    private Function<NodeMetadata, SshClient> sshFactory;

    @BeforeMethod(groups={"unit"})
    public void init() {
        this.sshClient = (SshClient)EasyMock.createMock(SshClient.class);
        this.sshFactory = new Function<NodeMetadata, SshClient>(){

            public SshClient apply(@Nullable NodeMetadata nodeMetadata) {
                return RunScriptOnNodeUsingSshTest.this.sshClient;
            }
        };
        this.node = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        EasyMock.expect((Object)this.node.getCredentials()).andReturn((Object)LoginCredentials.builder().user("tester").password("notalot").build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.node});
    }

    public void simpleTest() {
        RunScriptOnNodeUsingSsh testMe = new RunScriptOnNodeUsingSsh(this.sshFactory, this.eventBus, this.node, Statements.exec((String)"echo $USER\necho $USER"), RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false));
        testMe.init();
        this.sshClient.connect();
        EasyMock.expect((Object)this.sshClient.getUsername()).andReturn((Object)"tester");
        EasyMock.expect((Object)this.sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com");
        EasyMock.expect((Object)this.sshClient.exec("echo $USER\necho $USER\n")).andReturn((Object)new ExecResponse("tester\ntester\n", null, 0));
        this.sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{this.sshClient});
        testMe.call();
    }

    public void simpleRootTest() {
        RunScriptOnNodeUsingSsh testMe = new RunScriptOnNodeUsingSsh(this.sshFactory, this.eventBus, this.node, Statements.exec((String)"echo $USER\necho $USER"), RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(true));
        testMe.init();
        this.sshClient.connect();
        EasyMock.expect((Object)this.sshClient.getUsername()).andReturn((Object)"tester");
        EasyMock.expect((Object)this.sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com");
        EasyMock.expect((Object)this.sshClient.exec("sudo sh <<'RUN_SCRIPT_AS_ROOT_SSH'\necho $USER\necho $USER\nRUN_SCRIPT_AS_ROOT_SSH\n")).andReturn((Object)new ExecResponse("root\nroot\n", null, 0));
        this.sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{this.sshClient});
        testMe.call();
    }

    public void simpleRootTestWithSudoPassword() {
        this.node = (NodeMetadata)EasyMock.createMock(NodeMetadata.class);
        EasyMock.expect((Object)this.node.getCredentials()).andReturn((Object)LoginCredentials.builder().user("tester").password("testpassword!").authenticateSudo(true).build()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.node});
        RunScriptOnNodeUsingSsh testMe = new RunScriptOnNodeUsingSsh(this.sshFactory, this.eventBus, this.node, Statements.exec((String)"echo $USER\necho $USER"), RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(true));
        testMe.init();
        this.sshClient.connect();
        EasyMock.expect((Object)this.sshClient.getUsername()).andReturn((Object)"tester");
        EasyMock.expect((Object)this.sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com");
        EasyMock.expect((Object)this.sshClient.exec("sudo -S sh <<'RUN_SCRIPT_AS_ROOT_SSH'\ntestpassword!\necho $USER\necho $USER\nRUN_SCRIPT_AS_ROOT_SSH\n")).andReturn((Object)new ExecResponse("root\nroot\n", null, 0));
        this.sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{this.sshClient});
        testMe.call();
    }

    public void testUserAddAsRoot() {
        RunScriptOnNodeUsingSsh testMe = new RunScriptOnNodeUsingSsh(this.sshFactory, this.eventBus, this.node, (Statement)UserAdd.builder().login("testuser").build(), RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(true).overrideLoginPassword("test"));
        testMe.init();
        this.sshClient.connect();
        EasyMock.expect((Object)this.sshClient.getUsername()).andReturn((Object)"tester");
        EasyMock.expect((Object)this.sshClient.getHostAddress()).andReturn((Object)"somewhere.example.com");
        EasyMock.expect((Object)this.sshClient.exec("sudo sh <<'RUN_SCRIPT_AS_ROOT_SSH'\nmkdir -p /home/users\nchmod 0755 /home/users\nuseradd -c testuser -s /bin/bash -m  -d /home/users/testuser testuser\nchown -R testuser /home/users/testuser\nRUN_SCRIPT_AS_ROOT_SSH\n")).andReturn((Object)new ExecResponse("done", null, 0));
        this.sshClient.disconnect();
        EasyMock.replay((Object[])new Object[]{this.sshClient});
        testMe.call();
    }
}

