/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeTestUtils;
import org.jclouds.compute.JettyStatements;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.compute.util.OpenSocketFinder;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.java.InstallJDK;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"integration", "live"}, singleThreaded=true)
public abstract class BaseComputeServiceLiveTest
extends BaseComputeServiceContextLiveTest {
    protected String group;
    protected Predicate<HostAndPort> socketTester;
    protected OpenSocketFinder openSocketFinder;
    protected SortedSet<NodeMetadata> nodes;
    protected ComputeService client;
    protected Template template;
    protected Map<String, String> keyPair;
    protected int nonBlockDurationSeconds = 30;

    @BeforeGroups(groups={"integration", "live"})
    public void setupContext() {
        this.setServiceDefaults();
        if (this.group == null) {
            this.group = (String)Preconditions.checkNotNull((Object)this.provider, (Object)"provider");
        }
        if (this.group.indexOf(45) == -1) {
            this.group = this.group + "-";
        }
        this.setupKeyPairForTest();
        super.setupContext();
        this.buildSocketTester();
    }

    public void setServiceDefaults() {
    }

    protected void setupKeyPairForTest() {
        this.keyPair = ComputeTestUtils.setupKeyPair();
    }

    protected void buildSocketTester() {
        SocketOpen socketOpen = (SocketOpen)((ComputeServiceContext)this.view).utils().injector().getInstance(SocketOpen.class);
        this.socketTester = Predicates2.retry((Predicate)socketOpen, (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.openSocketFinder = (OpenSocketFinder)this.context.utils().injector().getInstance(OpenSocketFinder.class);
    }

    protected void initializeContext() {
        super.initializeContext();
        this.client = ((ComputeServiceContext)this.view).getComputeService();
    }

    @Test(enabled=true, expectedExceptions={AuthorizationException.class})
    public void testCorrectAuthException() throws Exception {
        ComputeServiceContext context = null;
        try {
            Properties overrides = this.setupProperties();
            overrides.setProperty(this.provider + ".identity", "MOM:MA");
            overrides.setProperty(this.provider + ".credential", "MIA");
            context = (ComputeServiceContext)this.newBuilder().modules((Iterable)ImmutableSet.of((Object)this.getLoggingModule(), (Object)this.credentialStoreModule)).overrides(overrides).build(ComputeServiceContext.class);
            context.getComputeService().listNodes();
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test(enabled=true)
    public void testImagesCache() throws Exception {
        this.client.listImages();
        long time = System.currentTimeMillis();
        this.client.listImages();
        long duration = System.currentTimeMillis() - time;
        assert (duration < 1000L) : String.format("%dms to get images", duration);
    }

    @Test(enabled=true, expectedExceptions={NoSuchElementException.class})
    public void testCorrectExceptionRunningNodesNotFound() throws Exception {
        this.client.runScriptOnNodesMatching(NodePredicates.runningInGroup((String)"zebras-are-awesome"), InstallJDK.fromOpenJDK());
    }

    public void testImageById() {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        Assert.assertEquals((Object)((ComputeServiceContext)this.view).getComputeService().getImage(defaultTemplate.getImage().getId()), (Object)defaultTemplate.getImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true, dependsOnMethods={"testCompareSizes"})
    public void testAScriptExecutionAfterBootWithBasicTemplate() throws Exception {
        String group = this.group + "r";
        try {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.template = this.buildTemplate(this.client.templateBuilder());
        this.template.getOptions().blockOnPort(22, 120);
        try {
            Set nodes = this.client.createNodesInGroup(group, 1, this.template);
            NodeMetadata node = (NodeMetadata)Iterables.get((Iterable)nodes, (int)0);
            LoginCredentials good = node.getCredentials();
            assert (good.identity != null) : nodes;
            for (Map.Entry response : this.client.runScriptOnNodesMatching(NodePredicates.runningInGroup((String)group), "hostname", RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false).overrideLoginCredentials(good)).entrySet()) {
                this.checkResponseEqualsHostname((ExecResponse)response.getValue(), (NodeMetadata)response.getKey());
            }
            ExecResponse response = this.client.runScriptOnNode(node.getId(), "hostname", RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false));
            this.checkResponseEqualsHostname(response, node);
            OperatingSystem os = node.getOperatingSystem();
            this.tryBadPassword(group, (Credentials)good);
            this.runScriptWithCreds(group, os, good);
            this.checkNodes(nodes, group, "runScriptWithCreds");
            ListenableFuture future = this.client.submitScriptOnNode(node.getId(), (Statement)AdminAccess.builder().adminUsername("foo").adminHome("/over/ridden/foo").build(), RunScriptOptions.Builder.nameTask((String)"adminUpdate"));
            response = (ExecResponse)future.get(3L, TimeUnit.MINUTES);
            assert (response.getExitStatus() == 0) : node.getId() + ": " + response;
            node = this.client.getNodeMetadata(node.getId());
            Assert.assertEquals((String)node.getCredentials().identity, (String)"foo");
            assert (node.getCredentials().credential != null) : nodes;
            this.weCanCancelTasks(node);
            assert (response.getExitStatus() == 0) : node.getId() + ": " + response;
            response = this.client.runScriptOnNode(node.getId(), "echo $USER", RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false));
            assert (response.getOutput().trim().equals("foo")) : node.getId() + ": " + response;
        }
        finally {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
    }

    @Test(enabled=false)
    protected void tryBadPassword(String group, Credentials good) throws AssertionError {
        block4: {
            try {
                Map responses = this.client.runScriptOnNodesMatching(NodePredicates.runningInGroup((String)group), "echo I put a bad password", RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false).overrideLoginCredentials(LoginCredentials.builder().user(good.identity).noPrivateKey().password("romeo").build()));
                assert (responses.size() == 0) : "shouldn't pass with a bad password\n" + responses;
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (RunScriptOnNodesException e) {
                if ($assertionsDisabled || Iterables.any(e.getNodeErrors().values(), (Predicate)Predicates.instanceOf(AuthorizationException.class))) break block4;
                throw new AssertionError((Object)((Object)((Object)e) + " not authexception!"));
            }
        }
    }

    @Test(enabled=false)
    public void weCanCancelTasks(NodeMetadata node) throws InterruptedException, ExecutionException {
        ListenableFuture future = this.client.submitScriptOnNode(node.getId(), "sleep 300", RunScriptOptions.Builder.nameTask((String)"sleeper").runAsRoot(false));
        ExecResponse response = null;
        try {
            response = (ExecResponse)future.get(1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)(node.getId() + ": " + response));
        }
        catch (TimeoutException e) {
            assert (!future.isDone());
            response = this.client.runScriptOnNode(node.getId(), "/tmp/init-sleeper status", RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false));
            assert (!response.getOutput().trim().equals("")) : node.getId() + ": " + response;
            future.cancel(true);
            response = this.client.runScriptOnNode(node.getId(), "/tmp/init-sleeper status", RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false));
            assert (response.getOutput().trim().equals("")) : node.getId() + ": " + response;
            try {
                future.get();
                Assert.fail((String)future.toString());
            }
            catch (CancellationException e1) {
                // empty catch block
            }
        }
    }

    protected void checkResponseEqualsHostname(ExecResponse execResponse, NodeMetadata node1) {
        assert (execResponse.getOutput().trim().equals(node1.getHostname())) : node1 + ": " + execResponse;
    }

    @Test(enabled=true, dependsOnMethods={"testImagesCache"})
    public void testTemplateMatch() throws Exception {
        this.template = this.buildTemplate(this.client.templateBuilder());
        Template toMatch = this.client.templateBuilder().imageId(this.template.getImage().getId()).build();
        Assert.assertEquals((Object)toMatch.getImage(), (Object)this.template.getImage());
    }

    protected void checkHttpGet(NodeMetadata node) {
        ComputeTestUtils.checkHttpGet(((ComputeServiceContext)this.view).utils().http(), node, 8080);
    }

    @Test(enabled=true, dependsOnMethods={"testConcurrentUseOfComputeServiceToCreateNodes"})
    public void testCreateTwoNodesWithRunScript() throws Exception {
        try {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)this.group));
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.refreshTemplate();
        try {
            this.nodes = Sets.newTreeSet((Iterable)this.client.createNodesInGroup(this.group, 2, this.template));
        }
        catch (RunNodesException e) {
            this.nodes = Sets.newTreeSet((Iterable)Iterables.concat((Iterable)e.getSuccessfulNodes(), e.getNodeErrors().keySet()));
            throw e;
        }
        Assert.assertEquals((int)this.nodes.size(), (int)2, (String)("expected two nodes but was " + this.nodes));
        this.checkNodes(this.nodes, this.group, "bootstrap");
        NodeMetadata node1 = this.nodes.first();
        NodeMetadata node2 = this.nodes.last();
        this.assertLocationSameOrChild((Location)Preconditions.checkNotNull((Object)node1.getLocation(), (String)"location of %s", (Object[])new Object[]{node1}), this.template.getLocation());
        this.assertLocationSameOrChild((Location)Preconditions.checkNotNull((Object)node2.getLocation(), (String)"location of %s", (Object[])new Object[]{node2}), this.template.getLocation());
        this.checkImageIdMatchesTemplate(node1);
        this.checkImageIdMatchesTemplate(node2);
        this.checkOsMatchesTemplate(node1);
        this.checkOsMatchesTemplate(node2);
    }

    @Test(enabled=true, dependsOnMethods={"testCreateTwoNodesWithRunScript"})
    public void testCreateTwoNodesWithOneSpecifiedName() throws Exception {
        TreeSet nodes2;
        this.template = this.buildTemplate(this.client.templateBuilder());
        this.template.getOptions().nodeNames((Iterable)ImmutableSet.of((Object)"first-node"));
        try {
            nodes2 = Sets.newTreeSet((Iterable)this.client.createNodesInGroup(this.group, 2, this.template));
        }
        catch (RunNodesException e) {
            TreeSet nodes2 = Sets.newTreeSet((Iterable)Iterables.concat((Iterable)e.getSuccessfulNodes(), e.getNodeErrors().keySet()));
            throw e;
        }
        Assert.assertEquals((int)nodes2.size(), (int)2, (String)("expected two nodes but was " + nodes2));
        NodeMetadata node1 = (NodeMetadata)Iterables.getFirst((Iterable)nodes2, null);
        NodeMetadata node2 = (NodeMetadata)Iterables.getLast((Iterable)nodes2, null);
        Assert.assertTrue((node1.getName().equals("first-node") || node2.getName().equals("first-node") ? 1 : 0) != 0, (String)"one node should be named 'first-node'");
        Assert.assertFalse((node1.getName().equals("first-node") && node2.getName().equals("first-node") ? 1 : 0) != 0, (String)"one node should be named something other than 'first-node");
        this.nodes.addAll(nodes2);
    }

    private Template refreshTemplate() {
        this.template = BaseComputeServiceLiveTest.addRunScriptToTemplate(this.buildTemplate(this.client.templateBuilder()));
        return this.template;
    }

    protected static Template addRunScriptToTemplate(Template template) {
        template.getOptions().runScript(Statements.newStatementList((Statement[])new Statement[]{AdminAccess.standard(), InstallJDK.fromOpenJDK()}));
        return template;
    }

    protected void checkImageIdMatchesTemplate(NodeMetadata node) {
        if (node.getImageId() != null) {
            Assert.assertEquals((String)node.getImageId(), (String)this.template.getImage().getId());
        }
    }

    protected void checkOsMatchesTemplate(NodeMetadata node) {
        if (node.getOperatingSystem() != null) assert (node.getOperatingSystem().getFamily().equals((Object)this.template.getImage().getOperatingSystem().getFamily())) : String.format("expecting family %s but got %s", this.template.getImage().getOperatingSystem().getFamily(), node.getOperatingSystem());
    }

    void assertLocationSameOrChild(Location test, Location expected) {
        if (!test.equals(expected)) {
            Assert.assertEquals((String)test.getParent().getId(), (String)expected.getId());
        } else {
            Assert.assertEquals((Object)test, (Object)expected);
        }
    }

    @Test(enabled=true, dependsOnMethods={"testCreateTwoNodesWithOneSpecifiedName"})
    public void testCreateAnotherNodeWithANewContextToEnsureSharedMemIsntRequired() throws Exception {
        this.initializeContext();
        Location existingLocation = ((NodeMetadata)Iterables.get(this.nodes, (int)0)).getLocation();
        boolean existingLocationIsAssignable = Iterables.any((Iterable)this.client.listAssignableLocations(), (Predicate)Predicates.equalTo((Object)existingLocation));
        if (existingLocationIsAssignable) {
            Logger.getAnonymousLogger().info("creating another node based on existing nodes' location: " + existingLocation);
            this.template = this.buildTemplate(this.client.templateBuilder());
            this.template = BaseComputeServiceLiveTest.addRunScriptToTemplate(this.client.templateBuilder().fromTemplate(this.template).locationId(existingLocation.getId()).build());
        } else {
            this.refreshTemplate();
            Logger.getAnonymousLogger().info(String.format("%s is not assignable; using template's location %s as  ", existingLocation, this.template.getLocation()));
        }
        Set nodes = this.client.createNodesInGroup(this.group, 1, this.template);
        Assert.assertEquals((int)nodes.size(), (int)1);
        this.checkNodes(nodes, this.group, "bootstrap");
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)nodes);
        if (existingLocationIsAssignable) {
            Assert.assertEquals((Object)node.getLocation(), (Object)existingLocation);
        } else {
            this.assertLocationSameOrChild((Location)Preconditions.checkNotNull((Object)node.getLocation(), (String)"location of %s", (Object[])new Object[]{node}), this.template.getLocation());
        }
        this.checkOsMatchesTemplate(node);
        this.nodes.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true, dependsOnMethods={"testCompareSizes"})
    public void testConcurrentUseOfComputeServiceToCreateNodes() throws Exception {
        long timeoutMs = 1200000L;
        ArrayList groups = Lists.newArrayList();
        ArrayList futures = Lists.newArrayList();
        ListeningExecutorService userExecutor = (ListeningExecutorService)this.context.utils().injector().getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.user-threads")));
        try {
            int i = 0;
            while (i < 2) {
                int groupNum = i++;
                final String group = "twin" + groupNum;
                groups.add(group);
                this.template = this.buildTemplate(this.client.templateBuilder());
                this.template.getOptions().inboundPorts(new int[]{22, 8080}).blockOnPort(22, 300 + groupNum);
                ListenableFuture future = userExecutor.submit((Callable)new Callable<NodeMetadata>(){

                    @Override
                    public NodeMetadata call() throws Exception {
                        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)BaseComputeServiceLiveTest.this.client.createNodesInGroup(group, 1, BaseComputeServiceLiveTest.this.template));
                        Logger.getAnonymousLogger().info("Started node " + node.getId());
                        return node;
                    }
                });
                futures.add(future);
            }
            ListenableFuture compoundFuture = Futures.allAsList((Iterable)futures);
            compoundFuture.get(1200000L, TimeUnit.MILLISECONDS);
        }
        finally {
            for (String group : groups) {
                this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
            }
        }
    }

    @Test(enabled=true, dependsOnMethods={"testCreateAnotherNodeWithANewContextToEnsureSharedMemIsntRequired"})
    public void testCredentialsCache() throws Exception {
        this.initializeContext();
        for (NodeMetadata node : this.nodes) {
            assert (((ComputeServiceContext)this.view).utils().credentialStore().get("node#" + node.getId()) != null) : "credentials for " + node.getId();
        }
    }

    protected Map<? extends NodeMetadata, ExecResponse> runScriptWithCreds(String group, OperatingSystem os, LoginCredentials creds) throws RunScriptOnNodesException {
        return this.client.runScriptOnNodesMatching(NodePredicates.runningInGroup((String)group), InstallJDK.fromOpenJDK(), (RunScriptOptions)TemplateOptions.Builder.overrideLoginCredentials((LoginCredentials)creds).nameTask("runScriptWithCreds"));
    }

    protected void checkNodes(Iterable<? extends NodeMetadata> nodes, String group, String taskName) throws IOException {
        for (NodeMetadata nodeMetadata : nodes) {
            Assert.assertNotNull((Object)nodeMetadata.getProviderId());
            Assert.assertNotNull((Object)nodeMetadata.getGroup());
            Assert.assertEquals((String)nodeMetadata.getGroup(), (String)group);
            Assert.assertEquals((Object)nodeMetadata.getStatus(), (Object)NodeMetadata.Status.RUNNING);
            Credentials fromStore = (Credentials)((ComputeServiceContext)this.view).utils().credentialStore().get("node#" + nodeMetadata.getId());
            Assert.assertEquals((Object)fromStore, (Object)nodeMetadata.getCredentials());
            assert (nodeMetadata.getPublicAddresses().size() >= 1 || nodeMetadata.getPrivateAddresses().size() >= 1) : "no ips in" + nodeMetadata;
            Assert.assertNotNull((Object)nodeMetadata.getCredentials());
            if (nodeMetadata.getCredentials().identity == null) continue;
            Assert.assertNotNull((Object)nodeMetadata.getCredentials().identity);
            this.sshPing(nodeMetadata, taskName);
        }
    }

    protected Template buildTemplate(TemplateBuilder templateBuilder) {
        return templateBuilder.build();
    }

    @Test(enabled=true, dependsOnMethods={"testCreateAnotherNodeWithANewContextToEnsureSharedMemIsntRequired"})
    public void testGet() throws Exception {
        LinkedHashMap metadataMap = Maps.newLinkedHashMap((Map)Maps.uniqueIndex((Iterable)Sets.filter((Set)this.client.listNodesDetailsMatching(NodePredicates.all()), (Predicate)Predicates.and((Predicate)NodePredicates.inGroup((String)this.group), (Predicate)Predicates.not((Predicate)NodePredicates.TERMINATED))), (Function)new Function<NodeMetadata, String>(){

            public String apply(NodeMetadata from) {
                return from.getId();
            }
        }));
        for (NodeMetadata node : this.nodes) {
            metadataMap.remove(node.getId());
            NodeMetadata metadata = this.client.getNodeMetadata(node.getId());
            Assert.assertEquals((String)metadata.getProviderId(), (String)node.getProviderId());
            Assert.assertEquals((String)metadata.getGroup(), (String)node.getGroup());
            this.assertLocationSameOrChild((Location)Preconditions.checkNotNull((Object)metadata.getLocation(), (String)"location of %s", (Object[])new Object[]{metadata}), this.template.getLocation());
            this.checkImageIdMatchesTemplate(metadata);
            this.checkOsMatchesTemplate(metadata);
            assert (metadata.getStatus() == NodeMetadata.Status.RUNNING) : metadata;
            Assert.assertEquals((int)metadata.getPrivateAddresses().size(), (int)node.getPrivateAddresses().size(), (String)String.format("[%s] didn't match: [%s]", metadata.getPrivateAddresses(), node.getPrivateAddresses().size()));
            Assert.assertEquals((int)metadata.getPublicAddresses().size(), (int)node.getPublicAddresses().size(), (String)String.format("[%s] didn't match: [%s]", metadata.getPublicAddresses(), node.getPublicAddresses().size()));
        }
        this.assertNodeZero(metadataMap.values());
    }

    protected void assertNodeZero(Collection<? extends NodeMetadata> metadataSet) {
        assert (metadataSet.size() == 0) : String.format("nodes left in set: [%s] which didn't match set: [%s]", metadataSet, this.nodes);
    }

    @Test(enabled=true, dependsOnMethods={"testGet"})
    public void testReboot() throws Exception {
        Set rebootNodes = this.client.rebootNodesMatching(NodePredicates.inGroup((String)this.group));
        for (ComputeMetadata node : rebootNodes) {
            Assert.assertNotNull((Object)node);
            assert (node.getProviderId() != null) : node;
            assert (node.getLocation() != null) : node;
        }
        this.testGet();
    }

    @Test(enabled=true, dependsOnMethods={"testReboot"})
    public void testSuspendResume() throws Exception {
        Set suspendedNodes = this.client.suspendNodesMatching(NodePredicates.inGroup((String)this.group));
        for (ComputeMetadata node : suspendedNodes) {
            Assert.assertNotNull((Object)node);
            assert (node.getProviderId() != null) : node;
            assert (node.getLocation() != null) : node;
        }
        Set<? extends NodeMetadata> stoppedNodes = this.refreshNodes();
        assert (Iterables.all(stoppedNodes, (Predicate)new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata input) {
                boolean returnVal;
                boolean bl = returnVal = input.getStatus() == NodeMetadata.Status.SUSPENDED;
                if (!returnVal) {
                    Logger.getAnonymousLogger().warning(String.format("node %s in state %s%n", input.getId(), input.getStatus()));
                }
                return returnVal;
            }
        })) : stoppedNodes;
        Set resumedNodes = this.client.resumeNodesMatching(NodePredicates.inGroup((String)this.group));
        for (ComputeMetadata node : resumedNodes) {
            Assert.assertNotNull((Object)node);
            assert (node.getProviderId() != null) : node;
            assert (node.getLocation() != null) : node;
        }
        this.testGet();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodes() throws Exception {
        for (ComputeMetadata node : this.client.listNodes()) {
            assert (node.getProviderId() != null) : node;
            assert (node.getLocation() != null) : node;
            Assert.assertEquals((Object)node.getType(), (Object)ComputeType.NODE);
        }
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodesByIds() throws Exception {
        ImmutableSet nodeIds = ImmutableSet.copyOf((Iterable)Iterables.transform(this.nodes, (Function)new Function<NodeMetadata, String>(){

            public String apply(NodeMetadata from) {
                return from.getId();
            }
        }));
        ImmutableSortedSet listedNodes = ImmutableSortedSet.copyOf((Collection)this.client.listNodesByIds((Iterable)nodeIds));
        Assert.assertTrue((boolean)Iterables.elementsEqual(this.nodes, (Iterable)listedNodes), (String)("nodes and listNodesByIds should be identical: was " + listedNodes + " but should be " + this.nodes));
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testGetNodesWithDetails() throws Exception {
        for (NodeMetadata node : this.client.listNodesDetailsMatching(NodePredicates.all())) {
            assert (node.getProviderId() != null) : node;
            assert (node.getLocation() != null) : node;
            Assert.assertEquals((Object)node.getType(), (Object)ComputeType.NODE);
            assert (node instanceof NodeMetadata);
            NodeMetadata nodeMetadata = node;
            assert (nodeMetadata.getProviderId() != null) : nodeMetadata;
            if (nodeMetadata.getStatus() != NodeMetadata.Status.RUNNING) continue;
            assert (nodeMetadata.getPublicAddresses() != null) : nodeMetadata;
            assert (!nodeMetadata.getPublicAddresses().isEmpty() || !nodeMetadata.getPrivateAddresses().isEmpty()) : nodeMetadata;
            Assert.assertNotNull((Object)nodeMetadata.getPrivateAddresses());
        }
    }

    @Test(enabled=true, dependsOnMethods={"testListNodes", "testGetNodesWithDetails", "testListNodesByIds"})
    public void testDestroyNodes() {
        int toDestroy = this.refreshNodes().size();
        Set destroyed = this.client.destroyNodesMatching(NodePredicates.inGroup((String)this.group));
        Assert.assertEquals((int)toDestroy, (int)destroyed.size());
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        for (NodeMetadata node : Sets.filter((Set)this.client.listNodesDetailsMatching(NodePredicates.all()), (Predicate)NodePredicates.inGroup((String)this.group))) {
            assert (node.getStatus() == NodeMetadata.Status.TERMINATED) : node;
            assert (((ComputeServiceContext)this.view).utils().credentialStore().get("node#" + node.getId()) == null) : "credential should have been null for node#" + node.getId();
        }
    }

    private Set<? extends NodeMetadata> refreshNodes() {
        return Sets.filter((Set)this.client.listNodesDetailsMatching(NodePredicates.all()), (Predicate)Predicates.and((Predicate)NodePredicates.inGroup((String)this.group), (Predicate)Predicates.not((Predicate)NodePredicates.TERMINATED)));
    }

    protected ServiceStats trackAvailabilityOfProcessOnNode(Statement process, String processName, NodeMetadata node) {
        ServiceStats stats = new ServiceStats();
        Stopwatch watch = Stopwatch.createStarted();
        ExecResponse exec = this.client.runScriptOnNode(node.getId(), process, (RunScriptOptions)TemplateOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false));
        stats.backgroundProcessMilliseconds = watch.elapsed(TimeUnit.MILLISECONDS);
        watch.reset().start();
        HostAndPort socket = null;
        try {
            socket = this.openSocketFinder.findOpenSocketOnNode(node, 8080, 600L, TimeUnit.SECONDS);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("%s%n%s%s", e.getMessage(), exec.getOutput(), exec.getError()));
        }
        stats.socketOpenMilliseconds = watch.elapsed(TimeUnit.MILLISECONDS);
        Logger.getAnonymousLogger().info(String.format("<< %s on node(%s)[%s] %s", processName, node.getId(), socket, stats));
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testCreateAndRunAService() throws Exception {
        String group = this.group + "s";
        try {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.createAndRunAServiceInGroup(group);
        }
        finally {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
    }

    protected void createAndRunAServiceInGroup(String group) throws RunNodesException {
        ImmutableMap userMetadata = ImmutableMap.of((Object)"test", (Object)group);
        ImmutableSet tags = ImmutableSet.of((Object)group);
        Stopwatch watch = Stopwatch.createStarted();
        this.template = this.buildTemplate(this.client.templateBuilder());
        this.template.getOptions().inboundPorts(new int[]{22, 8080}).blockOnPort(22, 300).userMetadata((Map)userMetadata).tags((Iterable)tags);
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)this.client.createNodesInGroup(group, 1, this.template));
        long createSeconds = watch.elapsed(TimeUnit.SECONDS);
        String nodeId = node.getId();
        this.checkUserMetadataContains(node, (ImmutableMap<String, String>)userMetadata);
        this.checkTagsInNodeEquals(node, (ImmutableSet<String>)tags);
        Logger.getAnonymousLogger().info(String.format("<< available node(%s) os(%s) in %ss", node.getId(), node.getOperatingSystem(), createSeconds));
        watch.reset().start();
        this.client.runScriptOnNode(nodeId, JettyStatements.install(), RunScriptOptions.Builder.nameTask((String)"configure-jetty"));
        long configureSeconds = watch.elapsed(TimeUnit.SECONDS);
        Logger.getAnonymousLogger().info(String.format("<< configured node(%s) with %s and jetty %s in %ss", nodeId, this.exec(nodeId, "java -fullversion"), this.exec(nodeId, JettyStatements.version()), configureSeconds));
        this.trackAvailabilityOfProcessOnNode(JettyStatements.start(), "start jetty", node);
        this.client.runScriptOnNode(nodeId, JettyStatements.stop(), (RunScriptOptions)TemplateOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false));
        this.trackAvailabilityOfProcessOnNode(JettyStatements.start(), "start jetty", node);
    }

    protected String exec(String nodeId, String command) {
        return this.exec(nodeId, Statements.exec((String)command));
    }

    protected String exec(String nodeId, Statement command) {
        return this.client.runScriptOnNode(nodeId, command, (RunScriptOptions)TemplateOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false)).getOutput().trim();
    }

    protected void checkUserMetadataContains(NodeMetadata node, ImmutableMap<String, String> userMetadata) {
        Map missing = Maps.difference((Map)node.getUserMetadata(), userMetadata).entriesOnlyOnRight();
        assert (missing.isEmpty()) : String.format("node userMetadata did not contain %s %s", missing, node);
    }

    protected void checkTagsInNodeEquals(NodeMetadata node, ImmutableSet<String> tags) {
        assert (node.getTags().equals(tags)) : String.format("node tags did not match %s %s", tags, node);
    }

    public void testListImages() throws Exception {
        for (Image image : this.client.listImages()) {
            assert (image.getProviderId() != null) : image;
            Assert.assertEquals((Object)image.getType(), (Object)ComputeType.IMAGE);
        }
    }

    @Test(groups={"integration", "live"})
    public void testGetAssignableLocations() throws Exception {
        for (Location location : this.client.listAssignableLocations()) {
            Logger.getAnonymousLogger().warning("location " + location);
            assert (location.getId() != null) : location;
            assert (location != location.getParent()) : location;
            assert (location.getScope() != null) : location;
            switch (location.getScope()) {
                case PROVIDER: {
                    this.assertProvider(location);
                    break;
                }
                case REGION: {
                    this.assertProvider(location.getParent());
                    break;
                }
                case ZONE: {
                    Location provider = location.getParent().getParent();
                    if (provider == null) {
                        provider = location.getParent();
                    }
                    this.assertProvider(provider);
                    break;
                }
                case HOST: {
                    Location provider2 = location.getParent().getParent().getParent();
                    if (provider2 == null) {
                        provider2 = location.getParent().getParent();
                    }
                    this.assertProvider(provider2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptionToNotBlock() throws Exception {
        String group = this.group + "block";
        try {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.template = this.buildTemplate(this.client.templateBuilder());
        this.template.getOptions().blockUntilRunning(false).inboundPorts(new int[0]);
        try {
            long time = System.currentTimeMillis();
            Set nodes = this.client.createNodesInGroup(group, 1, this.template);
            NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)nodes);
            assert (node.getStatus() != NodeMetadata.Status.RUNNING) : node;
            long duration = (System.currentTimeMillis() - time) / 1000L;
            assert (duration < (long)this.nonBlockDurationSeconds) : String.format("duration(%d) longer than expected(%d) seconds! ", duration, this.nonBlockDurationSeconds);
        }
        finally {
            this.client.destroyNodesMatching(NodePredicates.inGroup((String)group));
        }
    }

    private void assertProvider(Location provider) {
        Assert.assertEquals((Object)provider.getScope(), (Object)LocationScope.PROVIDER);
        Assert.assertEquals((Object)provider.getParent(), null);
    }

    public void testListSizes() throws Exception {
        for (Hardware hardware : this.client.listHardwareProfiles()) {
            assert (hardware.getProviderId() != null) : hardware;
            assert (ComputeServiceUtils.getCores((Hardware)hardware) > 0.0) : hardware;
            assert (hardware.getVolumes().size() >= 0) : hardware;
            assert (hardware.getRam() > 0) : hardware;
            Assert.assertEquals((Object)hardware.getType(), (Object)ComputeType.HARDWARE);
        }
    }

    @Test(enabled=true)
    public void testCompareSizes() throws Exception {
        this.doCompareSizes();
    }

    protected void doCompareSizes() throws Exception {
        Hardware defaultSize = this.client.templateBuilder().build().getHardware();
        Hardware smallest = this.client.templateBuilder().smallest().build().getHardware();
        Hardware fastest = this.client.templateBuilder().fastest().build().getHardware();
        Hardware biggest = this.client.templateBuilder().biggest().build().getHardware();
        Logger.getAnonymousLogger().info("smallest " + smallest);
        Logger.getAnonymousLogger().info("fastest " + fastest);
        Logger.getAnonymousLogger().info("biggest " + biggest);
        Assert.assertEquals((Object)defaultSize, (Object)smallest);
        assert (ComputeServiceUtils.getCores((Hardware)smallest) <= ComputeServiceUtils.getCores((Hardware)fastest)) : String.format("%s ! <= %s", smallest, fastest);
        assert (ComputeServiceUtils.getCores((Hardware)biggest) <= ComputeServiceUtils.getCores((Hardware)fastest)) : String.format("%s ! <= %s", biggest, fastest);
        assert (biggest.getRam() >= fastest.getRam()) : String.format("%s ! >= %s", biggest, fastest);
        assert (biggest.getRam() >= smallest.getRam()) : String.format("%s ! >= %s", biggest, smallest);
        assert (ComputeServiceUtils.getCores((Hardware)fastest) >= ComputeServiceUtils.getCores((Hardware)biggest)) : String.format("%s ! >= %s", fastest, biggest);
        assert (ComputeServiceUtils.getCores((Hardware)fastest) >= ComputeServiceUtils.getCores((Hardware)smallest)) : String.format("%s ! >= %s", fastest, smallest);
    }

    private void sshPing(NodeMetadata node, String taskName) throws IOException {
        for (int i = 0; i < 5; ++i) {
            try {
                this.doCheckJavaIsInstalledViaSsh(node, taskName);
                return;
            }
            catch (SshException e) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCheckJavaIsInstalledViaSsh(NodeMetadata node, String taskName) throws IOException {
        SshClient ssh = (SshClient)((ComputeServiceContext)this.view).utils().sshForNode().apply((Object)node);
        try {
            ssh.connect();
            ExecResponse hello = ssh.exec("echo hello");
            Assert.assertEquals((String)hello.getOutput().trim(), (String)"hello");
            ExecResponse exec = ssh.exec("java -version");
            assert (exec.getError().indexOf("OpenJDK") != -1 || exec.getOutput().indexOf("OpenJDK") != -1) : exec + "\n" + ssh.exec("cat /tmp/" + taskName + "/" + taskName + ".sh /tmp/" + taskName + "/stdout.log /tmp/" + taskName + "/stderr.log");
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        try {
            if (this.nodes != null) {
                this.client.destroyNodesMatching(Predicates.or((Predicate)NodePredicates.inGroup((String)this.group), (Predicate)Predicates.in(this.nodes)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDownContext();
    }

    @Override
    protected Module getSshModule() {
        throw new IllegalStateException("ssh is required for this test!");
    }

    static class ServiceStats {
        long backgroundProcessMilliseconds;
        long socketOpenMilliseconds;

        ServiceStats() {
        }

        public String toString() {
            return String.format("[backgroundProcessMilliseconds=%s, socketOpenMilliseconds=%s]", this.backgroundProcessMilliseconds, this.socketOpenMilliseconds);
        }
    }
}

