/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.suppliers;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.suppliers.ImageCacheSupplier;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ImageCacheSupplierTest")
public class ImageCacheSupplierTest {
    private Location location = new LocationBuilder().scope(LocationScope.PROVIDER).id("location").description("location").build();
    private OperatingSystem os = OperatingSystem.builder().name("osName").version("osVersion").description("osDescription").arch("X86_32").build();
    private Image image = new ImageBuilder().id("imageId").providerId("imageId").name("imageName").description("imageDescription").version("imageVersion").operatingSystem(this.os).status(Image.Status.AVAILABLE).location(this.location).build();
    private Set<? extends Image> images = ImmutableSet.of((Object)this.image);

    @Test(expectedExceptions={NullPointerException.class})
    public void testRegisterNullImageIsNotAllowed() {
        ImageCacheSupplier imageCache = new ImageCacheSupplier(Suppliers.ofInstance(this.images), 60L);
        imageCache.registerImage(null);
    }

    @Test
    public void testRegisterImageIgnoresDuplicates() {
        ImageCacheSupplier imageCache = new ImageCacheSupplier(Suppliers.ofInstance(this.images), 60L);
        Assert.assertEquals((int)imageCache.get().size(), (int)1);
        imageCache.registerImage(this.image);
        Assert.assertEquals((int)imageCache.get().size(), (int)1);
    }

    @Test
    public void testRegisterNewImage() {
        ImageCacheSupplier imageCache = new ImageCacheSupplier(Suppliers.ofInstance(this.images), 60L);
        Assert.assertEquals((int)imageCache.get().size(), (int)1);
        imageCache.registerImage(ImageBuilder.fromImage((Image)this.image).id("newimage").build());
        Assert.assertEquals((int)imageCache.get().size(), (int)2);
    }
}

