/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.concurrent.SingleThreaded;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.config.BindApiContextWithWildcardExtendsExplicitAndRawType;
import org.jclouds.config.BindNameToContext;
import org.jclouds.config.BindPropertiesToExpandedValues;
import org.jclouds.config.BindRestContextWithWildcardExtendsExplicitAndRawType;
import org.jclouds.domain.Credentials;
import org.jclouds.events.config.ConfiguresEventBus;
import org.jclouds.events.config.EventBusModule;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.JavaUrlHttpCommandExecutorServiceModule;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.lifecycle.config.LifeCycleModule;
import org.jclouds.logging.config.LoggingModule;
import org.jclouds.logging.jdk.config.JDKLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;
import org.jclouds.providers.config.BindProviderMetadataContextAndCredentials;
import org.jclouds.providers.internal.UpdateProviderMetadataFromProperties;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresCredentialStore;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.HttpApiMetadata;
import org.jclouds.rest.RestApiMetadata;
import org.jclouds.rest.config.CredentialStoreModule;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.config.RestModule;
import org.jclouds.rest.config.SyncToAsyncHttpInvocationModule;
import org.jclouds.util.Throwables2;

public class ContextBuilder {
    protected Optional<String> name = Optional.absent();
    protected Optional<ProviderMetadata> providerMetadata = Optional.absent();
    protected final String providerId;
    protected Optional<String> endpoint = Optional.absent();
    protected Optional<String> identity = Optional.absent();
    protected Optional<Supplier<Credentials>> credentialsSupplierOption = Optional.absent();
    @Nullable
    protected String credential;
    protected ApiMetadata apiMetadata;
    protected String apiVersion;
    protected String buildVersion;
    protected Optional<Properties> overrides = Optional.absent();
    protected List<Module> modules = Lists.newArrayListWithCapacity((int)3);
    private static Predicate<Module> configuresApi = new Predicate<Module>(){

        public boolean apply(Module input) {
            return input.getClass().isAnnotationPresent(ConfiguresHttpApi.class);
        }
    };
    private static Predicate<Module> configuresRest = new Predicate<Module>(){

        public boolean apply(Module input) {
            return input.getClass().isAnnotationPresent(ConfiguresRestClient.class);
        }
    };

    public static ContextBuilder newBuilder(String providerOrApi) throws NoSuchElementException {
        try {
            return ContextBuilder.newBuilder(Providers.withId(providerOrApi));
        }
        catch (NoSuchElementException e) {
            try {
                return ContextBuilder.newBuilder(Apis.withId(providerOrApi));
            }
            catch (NoSuchElementException e2) {
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                builder.putAll((Object)"providers", Iterables.transform(Providers.all(), Providers.idFunction()));
                builder.putAll((Object)"apis", Iterables.transform(Apis.all(), Apis.idFunction()));
                throw new NoSuchElementException(String.format("key [%s] not in the list of providers or apis: %s", providerOrApi, builder.build()));
            }
        }
    }

    public static ContextBuilder newBuilder(ApiMetadata apiMetadata) {
        try {
            return new ContextBuilder(apiMetadata);
        }
        catch (Exception e) {
            return (ContextBuilder)Throwables2.propagateAuthorizationOrOriginalException(e);
        }
    }

    public static ContextBuilder newBuilder(ProviderMetadata providerMetadata) {
        try {
            return new ContextBuilder(providerMetadata);
        }
        catch (Exception e) {
            return (ContextBuilder)Throwables2.propagateAuthorizationOrOriginalException(e);
        }
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("providerMetadata", this.providerMetadata).add("apiMetadata", (Object)this.apiMetadata).toString();
    }

    protected ContextBuilder(ProviderMetadata providerMetadata) {
        this(providerMetadata, ((ProviderMetadata)Preconditions.checkNotNull((Object)providerMetadata, (Object)"providerMetadata")).getApiMetadata());
    }

    protected ContextBuilder(@Nullable ProviderMetadata providerMetadata, ApiMetadata apiMetadata) {
        this.apiMetadata = (ApiMetadata)Preconditions.checkNotNull((Object)apiMetadata, (Object)"apiMetadata");
        if (providerMetadata != null) {
            this.providerMetadata = Optional.of((Object)providerMetadata);
            this.endpoint = Optional.of((Object)providerMetadata.getEndpoint());
            this.providerId = providerMetadata.getId();
        } else {
            this.endpoint = apiMetadata.getDefaultEndpoint();
            this.providerId = apiMetadata.getId();
        }
        this.identity = apiMetadata.getDefaultIdentity();
        this.credential = (String)apiMetadata.getDefaultCredential().orNull();
        this.apiVersion = apiMetadata.getVersion();
        this.buildVersion = (String)apiMetadata.getBuildVersion().or((Object)"");
    }

    public ContextBuilder(ApiMetadata apiMetadata) {
        this(null, apiMetadata);
    }

    public ContextBuilder name(String name) {
        this.name = Optional.of((Object)Preconditions.checkNotNull((Object)name, (Object)"name"));
        return this;
    }

    public ContextBuilder credentialsSupplier(Supplier<Credentials> credentialsSupplier) {
        this.credentialsSupplierOption = Optional.of((Object)Preconditions.checkNotNull(credentialsSupplier, (Object)"credentialsSupplier"));
        return this;
    }

    public ContextBuilder credentials(String identity, @Nullable String credential) {
        this.identity = Optional.of((Object)Preconditions.checkNotNull((Object)identity, (Object)"identity"));
        this.credential = credential;
        return this;
    }

    public ContextBuilder endpoint(String endpoint) {
        this.endpoint = Optional.of((Object)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint"));
        return this;
    }

    public ContextBuilder apiVersion(String apiVersion) {
        this.apiVersion = (String)Preconditions.checkNotNull((Object)apiVersion, (Object)"apiVersion");
        return this;
    }

    public ContextBuilder buildVersion(String buildVersion) {
        this.buildVersion = (String)Preconditions.checkNotNull((Object)buildVersion, (Object)"buildVersion");
        return this;
    }

    public ContextBuilder modules(Iterable<? extends Module> modules) {
        Iterables.addAll(this.modules, (Iterable)((Iterable)Preconditions.checkNotNull(modules, (Object)"modules")));
        return this;
    }

    public ContextBuilder overrides(Properties overrides) {
        this.overrides = Optional.of((Object)Preconditions.checkNotNull((Object)overrides, (Object)"overrides"));
        return this;
    }

    public static String searchPropertiesForProviderScopedProperty(Properties mutable, String prov, String key) throws NoSuchElementException {
        try {
            String string = (String)Iterables.find((Iterable)Lists.newArrayList((Object[])new String[]{mutable.getProperty(prov + "." + key), mutable.getProperty("jclouds." + key)}), (Predicate)Predicates.notNull());
            return string;
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("property %s.%s not present in properties: %s", prov, key, mutable.keySet()));
        }
        finally {
            mutable.remove(prov + "." + key);
            mutable.remove("jclouds." + key);
        }
    }

    public Injector buildInjector() {
        Properties unexpanded = this.currentStateToUnexpandedProperties();
        ImmutableSet keysToResolve = ImmutableSet.of((Object)"jclouds.identity", (Object)"jclouds.credential", (Object)"jclouds.endpoint", (Object)"jclouds.api", (Object)"jclouds.api-version", (Object)"jclouds.build-version", (Object[])new String[0]);
        ImmutableSet optionalKeys = this.credentialsSupplierOption.isPresent() ? ImmutableSet.of((Object)"jclouds.identity", (Object)"jclouds.credential") : (!this.apiMetadata.getCredentialName().isPresent() ? ImmutableSet.of((Object)"jclouds.credential") : ImmutableSet.of());
        Properties resolved = ContextBuilder.resolveProperties(unexpanded, this.providerId, (Set<String>)keysToResolve, (Set<String>)optionalKeys);
        Properties expanded = this.expandProperties(resolved);
        Supplier<Credentials> credentialsSupplier = this.buildCredentialsSupplier(expanded);
        ProviderMetadata providerMetadata = new UpdateProviderMetadataFromProperties(this.apiMetadata, this.providerMetadata).apply(expanded);
        return ContextBuilder.buildInjector((String)this.name.or((Object)String.valueOf(Objects.hashCode((Object[])new Object[]{providerMetadata.getId(), providerMetadata.getEndpoint(), providerMetadata.getApiMetadata().getVersion(), credentialsSupplier}))), providerMetadata, credentialsSupplier, this.modules);
    }

    protected Supplier<Credentials> buildCredentialsSupplier(Properties expanded) {
        Credentials creds = new Credentials(ContextBuilder.getAndRemove(expanded, "jclouds.identity"), ContextBuilder.getAndRemove(expanded, "jclouds.credential"));
        Supplier credentialsSupplier = this.credentialsSupplierOption.isPresent() ? (Supplier)this.credentialsSupplierOption.get() : Suppliers.ofInstance((Object)creds);
        return credentialsSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAndRemove(Properties expanded, String key) {
        try {
            String string = expanded.getProperty(key);
            return string;
        }
        finally {
            expanded.remove(key);
        }
    }

    private Properties currentStateToUnexpandedProperties() {
        Properties defaults = new Properties();
        defaults.putAll((Map<?, ?>)this.apiMetadata.getDefaultProperties());
        defaults.setProperty("jclouds.provider", this.providerId);
        if (this.providerMetadata.isPresent()) {
            defaults.putAll((Map<?, ?>)((ProviderMetadata)this.providerMetadata.get()).getDefaultProperties());
            defaults.setProperty("jclouds.iso3166-codes", Joiner.on((char)',').join(((ProviderMetadata)this.providerMetadata.get()).getIso3166Codes()));
        }
        if (this.endpoint.isPresent()) {
            defaults.setProperty("jclouds.endpoint", (String)this.endpoint.get());
        }
        defaults.setProperty("jclouds.api", this.apiMetadata.getName());
        defaults.setProperty("jclouds.api-version", this.apiVersion);
        defaults.setProperty("jclouds.build-version", this.buildVersion);
        if (this.identity.isPresent()) {
            defaults.setProperty("jclouds.identity", (String)this.identity.get());
        }
        if (this.credential != null) {
            defaults.setProperty("jclouds.credential", this.credential);
        }
        if (this.overrides.isPresent()) {
            defaults.putAll((Map<?, ?>)((Map)Preconditions.checkNotNull((Object)this.overrides.get(), (Object)"overrides")));
        }
        defaults.putAll(ContextBuilder.propertiesPrefixedWithJcloudsApiOrProviderId(this.getSystemProperties(), this.apiMetadata.getId(), this.providerId));
        return defaults;
    }

    @VisibleForTesting
    protected Properties getSystemProperties() {
        return System.getProperties();
    }

    private Properties expandProperties(Properties resolved) {
        return (Properties)Guice.createInjector((Module[])new Module[]{new BindPropertiesToExpandedValues(resolved)}).getInstance(Properties.class);
    }

    public static Injector buildInjector(String name, ProviderMetadata providerMetadata, Supplier<Credentials> creds, List<Module> inputModules) {
        ArrayList modules = Lists.newArrayList();
        modules.addAll(inputModules);
        boolean apiModuleSpecifiedByUser = ContextBuilder.apiModulePresent(inputModules);
        Iterable<Module> defaultModules = ContextBuilder.ifSpecifiedByUserDontIncludeDefaultApiModule(providerMetadata.getApiMetadata(), apiModuleSpecifiedByUser);
        Iterables.addAll((Collection)modules, defaultModules);
        ContextBuilder.addClientModuleIfNotPresent(providerMetadata.getApiMetadata(), modules);
        ContextBuilder.addRestContextBinding(providerMetadata.getApiMetadata(), modules);
        ContextBuilder.addLoggingModuleIfNotPresent(modules);
        ContextBuilder.addHttpModuleIfNeededAndNotPresent(modules);
        ContextBuilder.addExecutorServiceIfNotPresent(modules);
        ContextBuilder.addEventBusIfNotPresent(modules);
        ContextBuilder.addCredentialStoreIfNotPresent(modules);
        modules.add(new LifeCycleModule());
        modules.add(new BindProviderMetadataContextAndCredentials(providerMetadata, creds));
        modules.add(new BindNameToContext(name));
        Injector returnVal = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)modules);
        ((ExecutionList)returnVal.getInstance(ExecutionList.class)).execute();
        return returnVal;
    }

    static Properties resolveProperties(Properties mutable, String providerId, Set<String> keys, Set<String> optionalKeys) throws NoSuchElementException {
        for (String key : keys) {
            try {
                String scopedProperty = (String)ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)key)).get(1);
                mutable.setProperty(key, ContextBuilder.searchPropertiesForProviderScopedProperty(mutable, providerId, scopedProperty));
            }
            catch (NoSuchElementException e) {
                if (optionalKeys.contains(key)) continue;
                throw e;
            }
        }
        return mutable;
    }

    static void addRestContextBinding(ApiMetadata apiMetadata, List<Module> modules) {
        if (apiMetadata instanceof HttpApiMetadata) {
            try {
                modules.add((Module)new BindApiContextWithWildcardExtendsExplicitAndRawType((HttpApiMetadata)HttpApiMetadata.class.cast(apiMetadata)));
            }
            catch (IllegalArgumentException ignored) {}
        } else if (apiMetadata instanceof RestApiMetadata) {
            try {
                modules.add((Module)new BindRestContextWithWildcardExtendsExplicitAndRawType((RestApiMetadata)RestApiMetadata.class.cast(apiMetadata)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    static Iterable<Module> ifSpecifiedByUserDontIncludeDefaultApiModule(ApiMetadata apiMetadata, boolean restModuleSpecifiedByUser) {
        Iterable defaultModules = Iterables.transform(apiMetadata.getDefaultModules(), (Function)new Function<Class<? extends Module>, Module>(){

            public Module apply(Class<? extends Module> arg0) {
                try {
                    return arg0.newInstance();
                }
                catch (InstantiationException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
        if (restModuleSpecifiedByUser) {
            defaultModules = Iterables.filter((Iterable)defaultModules, (Predicate)Predicates.and((Predicate)Predicates.not(configuresApi), (Predicate)Predicates.not(configuresRest)));
        }
        return defaultModules;
    }

    static Map<String, Object> propertiesPrefixedWithJcloudsApiOrProviderId(Properties properties, String apiId, String providerId) {
        return Maps.filterKeys((Map)((Map)Map.class.cast(properties)), (Predicate)Predicates.containsPattern((String)("^(jclouds|" + providerId + "|" + apiId + ").*")));
    }

    @VisibleForTesting
    static void addLoggingModuleIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, (Predicate)Predicates.instanceOf(LoggingModule.class))) {
            modules.add((Module)new JDKLoggingModule());
        }
    }

    @VisibleForTesting
    static void addHttpModuleIfNeededAndNotPresent(List<Module> modules) {
        if (ContextBuilder.nothingConfiguresAnHttpService(modules)) {
            modules.add((Module)new JavaUrlHttpCommandExecutorServiceModule());
        }
    }

    static boolean nothingConfiguresAnHttpService(List<Module> modules) {
        return !Iterables.any(modules, (Predicate)new Predicate<Module>(){

            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresHttpCommandExecutorService.class);
            }
        });
    }

    @VisibleForTesting
    static void addClientModuleIfNotPresent(ApiMetadata apiMetadata, List<Module> modules) {
        if (!ContextBuilder.apiModulePresent(modules)) {
            ContextBuilder.addClientModule(apiMetadata, modules);
        }
    }

    private static boolean apiModulePresent(List<Module> modules) {
        return Iterables.any(modules, (Predicate)Predicates.or(configuresApi, configuresRest));
    }

    static void addClientModule(ApiMetadata apiMetadata, List<Module> modules) {
        if (apiMetadata instanceof HttpApiMetadata) {
            HttpApiMetadata api = (HttpApiMetadata)HttpApiMetadata.class.cast(apiMetadata);
            modules.add((Module)new HttpApiModule(api.getApi()));
        } else if (apiMetadata instanceof RestApiMetadata) {
            RestApiMetadata rest = (RestApiMetadata)RestApiMetadata.class.cast(apiMetadata);
            modules.add((Module)new RestClientModule(Reflection2.typeToken(rest.getApi()), Reflection2.typeToken(rest.getAsyncApi())));
        } else {
            modules.add((Module)new RestModule());
            modules.add((Module)new SyncToAsyncHttpInvocationModule());
        }
    }

    @VisibleForTesting
    static void addEventBusIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, (Predicate)new Predicate<Module>(){

            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresEventBus.class);
            }
        })) {
            modules.add((Module)new EventBusModule());
        }
    }

    @VisibleForTesting
    static void addExecutorServiceIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, (Predicate)new Predicate<Module>(){

            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresExecutorService.class);
            }
        })) {
            if (Iterables.any(modules, (Predicate)new Predicate<Module>(){

                public boolean apply(Module input) {
                    return input.getClass().isAnnotationPresent(SingleThreaded.class);
                }
            })) {
                modules.add((Module)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));
            } else {
                modules.add((Module)new ExecutorServiceModule());
            }
        }
    }

    @VisibleForTesting
    static void addCredentialStoreIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, (Predicate)new Predicate<Module>(){

            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresCredentialStore.class);
            }
        })) {
            modules.add((Module)new CredentialStoreModule());
        }
    }

    public <C extends Context> C build() {
        return (C)this.build(this.apiMetadata.getContext());
    }

    public <V extends View> V build(Class<V> viewType) {
        return this.buildView((Class)Preconditions.checkNotNull(viewType, (Object)"viewType"));
    }

    public <V extends View> V buildView(Class<V> viewType) {
        return this.buildView(Reflection2.typeToken(viewType));
    }

    public <V extends View> V buildView(TypeToken<V> viewType) {
        TypeToken<?> returnType;
        try {
            returnType = Apis.findView(this.apiMetadata, (TypeToken)Preconditions.checkNotNull(viewType, (Object)"viewType"));
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(String.format("api %s not wrappable as %s; context: %s, views: %s", this.apiMetadata, viewType, this.apiMetadata.getContext(), this.apiMetadata.getViews()));
        }
        return (V)((View)this.buildInjector().getInstance(Key.get((TypeLiteral)TypeLiteral.get((Type)returnType.getType()))));
    }

    public <C extends Context> C build(TypeToken<C> contextType) {
        TypeToken<? extends Context> returnType = null;
        if (!contextType.isAssignableFrom(this.apiMetadata.getContext())) {
            throw new IllegalArgumentException(String.format("api %s not assignable from %s; context: %s", this.apiMetadata, contextType, this.apiMetadata.getContext()));
        }
        returnType = this.apiMetadata.getContext();
        return (C)((Context)this.buildInjector().getInstance(Key.get((TypeLiteral)TypeLiteral.get((Type)returnType.getType()))));
    }

    public <A extends Closeable> A buildApi(Class<A> api) {
        return this.buildApi(Reflection2.typeToken(api));
    }

    public <A extends Closeable> A buildApi(TypeToken<A> apiType) {
        return (A)((Closeable)this.buildInjector().getInstance(Key.get((TypeLiteral)TypeLiteral.get((Type)apiType.getType()))));
    }

    public ApiMetadata getApiMetadata() {
        return this.apiMetadata;
    }
}

