/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Zone;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.logging.Logger;

@Singleton
public class ZoneToProvider
implements LocationsSupplier {
    @Resource
    protected Logger logger = Logger.NULL;
    private final JustProvider justProvider;
    private final Supplier<Set<String>> zoneIdsSupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;

    @Inject
    ZoneToProvider(JustProvider justProvider, @Zone Supplier<Set<String>> zoneIdsSupplier, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier) {
        this.justProvider = (JustProvider)Preconditions.checkNotNull((Object)justProvider, (Object)"justProvider");
        this.zoneIdsSupplier = (Supplier)Preconditions.checkNotNull(zoneIdsSupplier, (Object)"zoneIdsSupplier");
        this.isoCodesByIdSupplier = (Supplier)Preconditions.checkNotNull(isoCodesByIdSupplier, (Object)"isoCodesByIdSupplier");
    }

    public Set<? extends Location> get() {
        Location provider = (Location)Iterables.getOnlyElement((Iterable)this.justProvider.get());
        Set zoneIds = (Set)this.zoneIdsSupplier.get();
        Preconditions.checkState((zoneIds.size() > 0 ? 1 : 0) != 0, (String)"no zones found for provider %s, using supplier %s", (Object[])new Object[]{provider, this.zoneIdsSupplier});
        Map isoCodesById = (Map)this.isoCodesByIdSupplier.get();
        ImmutableSet.Builder locations = ImmutableSet.builder();
        for (String zoneId : zoneIds) {
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.ZONE).id(zoneId).description(zoneId).parent(provider);
            if (isoCodesById.containsKey(zoneId)) {
                builder.iso3166Codes((Iterable)((Supplier)isoCodesById.get(zoneId)).get());
            }
            locations.add((Object)builder.build());
        }
        return locations.build();
    }
}

