/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.Beta;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.DateService;
import org.jclouds.domain.Credentials;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;
import org.jclouds.rest.HttpAsyncClient;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.Utils;
import org.jclouds.xml.XMLParser;

@Singleton
public class UtilsImpl
implements Utils {
    private final Json json;
    private final HttpClient simpleClient;
    private final HttpAsyncClient simpleAsyncClient;
    private final Crypto encryption;
    private final DateService date;
    private final ListeningExecutorService userExecutor;
    private final ListeningExecutorService ioExecutor;
    private final EventBus eventBus;
    private final Map<String, Credentials> credentialStore;
    private final Logger.LoggerFactory loggerFactory;
    private Injector injector;
    private XMLParser xml;

    @Inject
    protected UtilsImpl(Injector injector, Json json, XMLParser xml, HttpClient simpleClient, HttpAsyncClient simpleAsyncClient, Crypto encryption, DateService date, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, @Named(value="jclouds.io-worker-threads") ListeningExecutorService ioExecutor, EventBus eventBus, Map<String, Credentials> credentialStore, Logger.LoggerFactory loggerFactory) {
        this.injector = injector;
        this.json = json;
        this.simpleClient = simpleClient;
        this.simpleAsyncClient = simpleAsyncClient;
        this.encryption = encryption;
        this.date = date;
        this.userExecutor = userExecutor;
        this.ioExecutor = ioExecutor;
        this.eventBus = eventBus;
        this.credentialStore = credentialStore;
        this.loggerFactory = loggerFactory;
        this.xml = xml;
    }

    @Override
    @Deprecated
    public HttpAsyncClient asyncHttp() {
        return this.simpleAsyncClient;
    }

    @Override
    public DateService date() {
        return this.date;
    }

    @Override
    public Crypto crypto() {
        return this.encryption;
    }

    @Override
    public DateService getDateService() {
        return this.date;
    }

    @Override
    public Crypto getCrypto() {
        return this.encryption;
    }

    @Override
    @Deprecated
    public HttpAsyncClient getHttpAsyncClient() {
        return this.simpleAsyncClient;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.simpleClient;
    }

    @Override
    public HttpClient http() {
        return this.simpleClient;
    }

    @Override
    public ListeningExecutorService getIoExecutor() {
        return this.ioExecutor;
    }

    @Override
    public ListeningExecutorService getUserExecutor() {
        return this.userExecutor;
    }

    @Override
    public ListeningExecutorService ioExecutor() {
        return this.ioExecutor;
    }

    @Override
    public ListeningExecutorService userExecutor() {
        return this.userExecutor;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public Logger.LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public Logger.LoggerFactory loggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public Json getJson() {
        return this.json;
    }

    @Override
    public Json json() {
        return this.json;
    }

    @Override
    @Beta
    public Injector getInjector() {
        return this.injector;
    }

    @Override
    @Beta
    public Injector injector() {
        return this.getInjector();
    }

    @Override
    public XMLParser getXml() {
        return this.xml;
    }

    @Override
    public XMLParser xml() {
        return this.xml;
    }

    @Override
    public Map<String, Credentials> credentialStore() {
        return this.credentialStore;
    }

    @Override
    public Map<String, Credentials> getCredentialStore() {
        return this.credentialStore;
    }
}

