/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.CountingOutputStream;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.jclouds.JcloudsVersion;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;

@Singleton
public class JavaUrlHttpCommandExecutorService
extends BaseHttpCommandExecutorService<HttpURLConnection> {
    public static final String DEFAULT_USER_AGENT = String.format("jclouds/%s java/%s", JcloudsVersion.get(), System.getProperty("java.version"));
    private final Supplier<SSLContext> untrustedSSLContextProvider;
    private final Function<URI, Proxy> proxyForURI;
    private final HostnameVerifier verifier;
    private final Field methodField;
    @Inject(optional=true)
    Supplier<SSLContext> sslContextSupplier;

    @Inject
    public JavaUrlHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, @Named(value="jclouds.io-worker-threads") ListeningExecutorService ioExecutor, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, Function<URI, Proxy> proxyForURI) throws SecurityException, NoSuchFieldException {
        super(utils, contentMetadataCodec, ioExecutor, retryHandler, ioRetryHandler, errorHandler, wire);
        if (utils.getMaxConnections() > 0) {
            System.setProperty("http.maxConnections", String.valueOf(((HttpUtils)Preconditions.checkNotNull((Object)utils, (Object)"utils")).getMaxConnections()));
        }
        this.untrustedSSLContextProvider = (Supplier)Preconditions.checkNotNull(untrustedSSLContextProvider, (Object)"untrustedSSLContextProvider");
        this.verifier = (HostnameVerifier)Preconditions.checkNotNull((Object)verifier, (Object)"verifier");
        this.proxyForURI = (Function)Preconditions.checkNotNull(proxyForURI, (Object)"proxyForURI");
        this.methodField = HttpURLConnection.class.getDeclaredField("method");
        this.methodField.setAccessible(true);
    }

    @Override
    protected HttpResponse invoke(HttpURLConnection connection) throws IOException, InterruptedException {
        HttpResponse.Builder<?> builder = HttpResponse.builder();
        InputStream in = null;
        try {
            in = JavaUrlHttpCommandExecutorService.consumeOnClose(connection.getInputStream());
        }
        catch (IOException e) {
            in = this.bufferAndCloseStream(connection.getErrorStream());
        }
        catch (RuntimeException e) {
            Closeables.closeQuietly((Closeable)in);
            throw Throwables.propagate((Throwable)e);
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 204) {
            Closeables.closeQuietly((Closeable)in);
            in = null;
        }
        builder.statusCode(responseCode);
        builder.message(connection.getResponseMessage());
        ImmutableMultimap.Builder headerBuilder = ImmutableMultimap.builder();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            String header = entry.getKey();
            if (header == null) continue;
            headerBuilder.putAll((Object)header, (Iterable)entry.getValue());
        }
        ImmutableMultimap headers = headerBuilder.build();
        if (in != null) {
            InputStreamPayload payload = Payloads.newInputStreamPayload(in);
            this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), (Multimap<String, String>)headers);
            builder.payload(payload);
        }
        builder.headers(HttpUtils.filterOutContentHeaders((Multimap<String, String>)headers));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream bufferAndCloseStream(InputStream inputStream) throws IOException {
        ByteArrayInputStream in = null;
        try {
            if (inputStream != null) {
                in = new ByteArrayInputStream(ByteStreams.toByteArray((InputStream)inputStream));
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
        return in;
    }

    @Override
    protected HttpURLConnection convert(HttpRequest request) throws IOException, InterruptedException {
        Payload payload;
        boolean chunked = "chunked".equals(request.getFirstHeaderOrNull("Transfer-Encoding"));
        URL url = request.getEndpoint().toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection((Proxy)this.proxyForURI.apply((Object)request.getEndpoint()));
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection sslCon = (HttpsURLConnection)connection;
            if (this.utils.relaxHostname()) {
                sslCon.setHostnameVerifier(this.verifier);
            }
            if (this.sslContextSupplier != null) {
                sslCon.setSSLSocketFactory(((SSLContext)this.sslContextSupplier.get()).getSocketFactory());
            } else if (this.utils.trustAllCerts()) {
                sslCon.setSSLSocketFactory(((SSLContext)this.untrustedSSLContextProvider.get()).getSocketFactory());
            }
        }
        connection.setConnectTimeout(this.utils.getConnectionTimeout());
        connection.setReadTimeout(this.utils.getSocketOpenTimeout());
        connection.setAllowUserInteraction(false);
        connection.setInstanceFollowRedirects(false);
        try {
            connection.setRequestMethod(request.getMethod());
        }
        catch (ProtocolException e) {
            try {
                this.methodField.set(connection, request.getMethod());
            }
            catch (IllegalAccessException e1) {
                this.logger.error(e, "could not set request method: ", request.getMethod());
                Throwables.propagate((Throwable)e1);
            }
        }
        for (Map.Entry entry : request.getHeaders().entries()) {
            connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        String host = request.getEndpoint().getHost();
        if (request.getEndpoint().getPort() != -1) {
            host = host + ":" + request.getEndpoint().getPort();
        }
        connection.setRequestProperty("Host", host);
        if (connection.getRequestProperty("User-Agent") == null) {
            connection.setRequestProperty("User-Agent", DEFAULT_USER_AGENT);
        }
        if ((payload = request.getPayload()) != null) {
            MutableContentMetadata md = payload.getContentMetadata();
            for (Map.Entry entry : this.contentMetadataCodec.toHeaders(md).entries()) {
                connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            if (chunked) {
                connection.setChunkedStreamingMode(8196);
                this.writePayloadToConnection(payload, "streaming", connection);
            } else {
                Long length = (Long)Preconditions.checkNotNull((Object)md.getContentLength(), (Object)"payload.getContentLength");
                Preconditions.checkArgument((length < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"JDK 1.6 does not support >2GB chunks. Use chunked encoding, if possible.");
                if (length > 0L) {
                    connection.setRequestProperty("Content-Length", length.toString());
                    connection.setFixedLengthStreamingMode(length.intValue());
                    this.writePayloadToConnection(payload, length, connection);
                } else {
                    this.writeNothing(connection);
                }
            }
        } else {
            this.writeNothing(connection);
        }
        return connection;
    }

    protected void writeNothing(HttpURLConnection connection) {
        if (!HttpRequest.NON_PAYLOAD_METHODS.contains(connection.getRequestMethod())) {
            connection.setRequestProperty("Content-Length", "0");
            String method = connection.getRequestMethod();
            if ("POST".equals(method) || "PUT".equals(method)) {
                connection.setFixedLengthStreamingMode(0);
                connection.setDoOutput(true);
            }
        }
    }

    void writePayloadToConnection(Payload payload, Object lengthDesc, HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        CountingOutputStream out = new CountingOutputStream(connection.getOutputStream());
        try {
            payload.writeTo((OutputStream)out);
        }
        catch (IOException e) {
            this.logger.error(e, "error after writing %d/%s bytes to %s", out.getCount(), lengthDesc, connection.getURL());
            throw e;
        }
    }

    @Override
    protected void cleanup(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }
}

