/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;

@Beta
public class Reflection2 {
    private static LoadingCache<TypeToken<?>, Set<Invokable<?, ?>>> constructorsForTypeToken = CacheBuilder.newBuilder().build(new CacheLoader<TypeToken<?>, Set<Invokable<?, ?>>>(){

        public Set<Invokable<?, ?>> load(TypeToken<?> key) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Constructor<?> ctor : key.getRawType().getDeclaredConstructors()) {
                ctor.setAccessible(true);
                builder.add((Object)key.constructor(ctor));
            }
            return builder.build();
        }
    });
    private static LoadingCache<Type, TypeToken<?>> typeTokenForType = CacheBuilder.newBuilder().build(new CacheLoader<Type, TypeToken<?>>(){

        public TypeToken<?> load(Type key) {
            return TypeToken.of((Type)key);
        }
    });
    private static LoadingCache<Class<?>, TypeToken<?>> typeTokenForClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, TypeToken<?>>(){

        public TypeToken<?> load(Class<?> key) {
            return TypeToken.of(key);
        }
    });
    private static LoadingCache<TypeTokenAndParameterTypes, Invokable<?, ?>> constructorForParams = CacheBuilder.newBuilder().build(new CacheLoader<TypeTokenAndParameterTypes, Invokable<?, ?>>(){

        public Invokable<?, ?> load(final TypeTokenAndParameterTypes key) {
            Set constructors = (Set)Reflection2.get(constructorsForTypeToken, key.type);
            Optional constructor = Iterables.tryFind((Iterable)constructors, (Predicate)new Predicate<Invokable<?, ?>>(){

                public boolean apply(Invokable<?, ?> input) {
                    return Objects.equal(Reflection2.toClasses((ImmutableList<Parameter>)input.getParameters()), key.parameterTypes);
                }
            });
            if (constructor.isPresent()) {
                return (Invokable)constructor.get();
            }
            throw new IllegalArgumentException("no such constructor " + key.toString() + "in: " + constructors);
        }
    });
    private static LoadingCache<TypeTokenNameAndParameterTypes, Invokable<?, ?>> methodForParams = CacheBuilder.newBuilder().build(new CacheLoader<TypeTokenNameAndParameterTypes, Invokable<?, ?>>(){

        public Invokable<?, ?> load(final TypeTokenNameAndParameterTypes key) {
            Set methods = (Set)Reflection2.get(methodsForTypeToken, key.type);
            Optional method = Iterables.tryFind((Iterable)methods, (Predicate)new Predicate<Invokable<?, ?>>(){

                public boolean apply(Invokable<?, ?> input) {
                    return !input.isSynthetic() && Objects.equal((Object)input.getName(), (Object)key.name) && Objects.equal(Reflection2.toClasses((ImmutableList<Parameter>)input.getParameters()), (Object)key.parameterTypes);
                }
            });
            Preconditions.checkArgument((boolean)method.isPresent(), (String)"no such method %s in: %s", (Object[])new Object[]{key.toString(), methods});
            return (Invokable)method.get();
        }
    });
    private static LoadingCache<TypeToken<?>, Set<Invokable<?, ?>>> methodsForTypeToken = CacheBuilder.newBuilder().build(new CacheLoader<TypeToken<?>, Set<Invokable<?, ?>>>(){

        public Set<Invokable<?, ?>> load(TypeToken<?> key) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (TypeToken token : key.getTypes()) {
                Class raw = token.getRawType();
                if (raw == Object.class) continue;
                for (Method method : raw.getDeclaredMethods()) {
                    if (!Reflection2.coreJavaClass(raw)) {
                        method.setAccessible(true);
                    }
                    builder.add((Object)key.method(method));
                }
            }
            return builder.build();
        }
    });

    public static <T> TypeToken<T> typeToken(Type in) {
        return Reflection2.get(typeTokenForType, Preconditions.checkNotNull((Object)in, (Object)"class"));
    }

    public static <T> TypeToken<T> typeToken(Class<T> in) {
        return Reflection2.get(typeTokenForClass, Preconditions.checkNotNull(in, (Object)"class"));
    }

    public static <T> Invokable<T, T> constructor(Class<T> ownerType, Class<?> ... parameterTypes) {
        return Reflection2.get(constructorForParams, new TypeTokenAndParameterTypes(Reflection2.typeToken(ownerType), parameterTypes));
    }

    public static <T> Collection<Invokable<T, T>> constructors(TypeToken<T> ownerType) {
        return (Collection)Collection.class.cast(Reflection2.get(constructorsForTypeToken, ownerType));
    }

    public static <T, R> Invokable<T, R> method(TypeToken<T> ownerType, Method method) {
        return Reflection2.method(ownerType.getRawType(), method.getName(), method.getParameterTypes());
    }

    public static <T, R> Invokable<T, R> method(Class<T> ownerType, String name, Class<?> ... parameterTypes) {
        return Reflection2.get(methodForParams, new TypeTokenNameAndParameterTypes(Reflection2.typeToken(ownerType), name, parameterTypes));
    }

    public static <T> Collection<Invokable<T, Object>> methods(Class<T> ownerType) {
        return (Collection)Collection.class.cast(Reflection2.get(methodsForTypeToken, Reflection2.typeToken(ownerType)));
    }

    protected static List<Class<?>> toClasses(ImmutableList<Parameter> params) {
        return Lists.transform(params, (Function)new Function<Parameter, Class<?>>(){

            public Class<?> apply(Parameter input) {
                return input.getType().getRawType();
            }
        });
    }

    private static boolean coreJavaClass(Class<?> clazz) {
        Package clazzPackage = clazz.getPackage();
        if (clazzPackage == null) {
            return false;
        }
        String packageName = clazzPackage.getName();
        return packageName.startsWith("com.sun.") || packageName.startsWith("java.") || packageName.startsWith("javax.") || packageName.startsWith("sun.");
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.get(key);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private static class TypeTokenNameAndParameterTypes
    extends TypeTokenAndParameterTypes {
        private String name;

        public TypeTokenNameAndParameterTypes(TypeToken<?> type, String name, Class<?> ... parameterTypes) {
            super(type, parameterTypes);
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.name});
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                TypeTokenNameAndParameterTypes that = (TypeTokenNameAndParameterTypes)TypeTokenNameAndParameterTypes.class.cast(obj);
                return this.name.equals(that.name);
            }
            return false;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper((String)"").add("type", (Object)this.type).add("name", (Object)this.name).add("parameterTypes", (Object)this.parameterTypes).toString();
        }
    }

    private static class TypeTokenAndParameterTypes {
        protected TypeToken<?> type;
        protected List<Class<?>> parameterTypes;

        public TypeTokenAndParameterTypes(TypeToken<?> type, Class<?> ... parameterTypes) {
            this.type = (TypeToken)Preconditions.checkNotNull(type, (Object)"type");
            this.parameterTypes = Arrays.asList((Object[])Preconditions.checkNotNull(parameterTypes, (Object)"parameterTypes"));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.parameterTypes});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TypeTokenAndParameterTypes that = (TypeTokenAndParameterTypes)TypeTokenAndParameterTypes.class.cast(obj);
            return Objects.equal(this.type, that.type) && Objects.equal(this.parameterTypes, that.parameterTypes);
        }

        public String toString() {
            return Objects.toStringHelper((String)"").add("type", this.type).add("parameterTypes", this.parameterTypes).toString();
        }
    }
}

