/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.common.primitives.Ints;

public class RetryAfterException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int seconds;

    public RetryAfterException(String message, int seconds) {
        super(message);
        this.seconds = Ints.max((int[])new int[]{seconds, 0});
    }

    public RetryAfterException(Throwable cause, int seconds) {
        seconds = Ints.max((int[])new int[]{seconds, 0});
        super(RetryAfterException.defaultMessage(seconds), cause);
        this.seconds = seconds;
    }

    private static String defaultMessage(int seconds) {
        switch (seconds) {
            case 0: {
                return "retry now";
            }
            case 1: {
                return "retry in 1 second";
            }
        }
        return String.format("retry in %d seconds", seconds);
    }

    public RetryAfterException(String message, Throwable cause, int seconds) {
        super(message, cause);
        this.seconds = Ints.max((int[])new int[]{seconds, 0});
    }

    public int getSeconds() {
        return this.seconds;
    }
}

