/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.List;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.collect.PagedIterables;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Beta
public abstract class Arg0ToPagedIterable<T, I extends Arg0ToPagedIterable<T, I>>
implements Function<IterableWithMarker<T>, PagedIterable<T>>,
InvocationContext<I> {
    private GeneratedHttpRequest request;

    public PagedIterable<T> apply(IterableWithMarker<T> input) {
        if (!input.nextMarker().isPresent()) {
            return PagedIterables.onlyPage(input);
        }
        List<Object> args = this.getArgs(this.request);
        Optional arg0 = Optional.fromNullable(args.size() > 0 ? args.get(0) : null);
        return PagedIterables.advance(input, this.markerToNextForArg0((Optional<Object>)arg0));
    }

    protected List<Object> getArgs(GeneratedHttpRequest request) {
        return request.getInvocation().getArgs();
    }

    protected abstract Function<Object, IterableWithMarker<T>> markerToNextForArg0(Optional<Object> var1);

    @Override
    public I setContext(HttpRequest request) {
        this.request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request);
        return (I)this;
    }

    public static abstract class FromCaller<T, I extends FromCaller<T, I>>
    extends Arg0ToPagedIterable<T, I> {
        @Override
        protected List<Object> getArgs(GeneratedHttpRequest request) {
            return ((Invocation)request.getCaller().get()).getArgs();
        }
    }
}

