/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.annotation.Resource;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ParseSax<T>
implements Function<HttpResponse, T>,
InvocationContext<ParseSax<T>> {
    @Resource
    private Logger logger = Logger.NULL;
    private final XMLReader parser;
    private final HandlerWithResult<T> handler;
    private HttpRequest request;

    public ParseSax(XMLReader parser, HandlerWithResult<T> handler) {
        this.parser = (XMLReader)Preconditions.checkNotNull((Object)parser, (Object)"parser");
        this.handler = (HandlerWithResult)Preconditions.checkNotNull(handler, (Object)"handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T apply(HttpResponse from) {
        T t;
        try {
            Preconditions.checkNotNull((Object)from, (Object)"http response");
            Preconditions.checkNotNull((Object)from.getPayload(), (Object)("payload in " + from));
        }
        catch (NullPointerException e) {
            return this.addDetailsAndPropagate(from, e);
        }
        InputStream is = null;
        try {
            if (from.getStatusCode() >= 300 || this.logger.isTraceEnabled()) {
                T t2 = this.convertStreamToStringAndParse(from);
                return t2;
            }
            is = from.getPayload().getInput();
            t = this.parse(new InputSource(is));
            Closeables.closeQuietly((Closeable)is);
        }
        catch (RuntimeException e) {
            T t3 = this.addDetailsAndPropagate(from, e);
            return t3;
        }
        finally {
            Closeables.closeQuietly(is);
            from.getPayload().release();
        }
        from.getPayload().release();
        return t;
    }

    private T convertStreamToStringAndParse(HttpResponse response) {
        String from = null;
        try {
            from = new String(HttpUtils.closeClientButKeepContentStream(response));
            this.validateXml(from);
            return this.doParse(new InputSource(new StringReader(from)));
        }
        catch (Exception e) {
            return this.addDetailsAndPropagate(response, e, from);
        }
    }

    public T parse(String from) {
        try {
            this.validateXml(from);
            return this.doParse(new InputSource(new StringReader(from)));
        }
        catch (Exception e) {
            return this.addDetailsAndPropagate(null, e, from);
        }
    }

    private void validateXml(String from) {
        Preconditions.checkNotNull((Object)from, (Object)"xml string");
        Preconditions.checkArgument((from.indexOf(60) >= 0 ? 1 : 0) != 0, (Object)String.format("not an xml document [%s] ", from));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T parse(InputStream from) {
        try {
            T t = this.parse(new InputSource(from));
            return t;
        }
        finally {
            Closeables.closeQuietly((Closeable)from);
        }
    }

    public T parse(InputSource from) {
        try {
            return this.doParse(from);
        }
        catch (Exception e) {
            return this.addDetailsAndPropagate(null, e);
        }
    }

    protected T doParse(InputSource from) throws IOException, SAXException {
        Preconditions.checkNotNull((Object)from, (Object)"xml inputsource");
        from.setEncoding("UTF-8");
        this.parser.setContentHandler(this.getHandler());
        this.parser.parse(from);
        return this.getHandler().getResult();
    }

    public T addDetailsAndPropagate(HttpResponse response, Exception e) {
        return this.addDetailsAndPropagate(response, e, null);
    }

    public T addDetailsAndPropagate(HttpResponse response, Exception e, @Nullable String text) {
        StringBuilder message = new StringBuilder();
        if (this.request != null) {
            message.append("request: ").append(this.request.getRequestLine());
        }
        if (response != null) {
            if (message.length() != 0) {
                message.append("; ");
            }
            message.append("response: ").append(response.getStatusLine());
        }
        if (e instanceof SAXParseException) {
            SAXParseException parseException = (SAXParseException)e;
            String systemId = parseException.getSystemId();
            if (systemId == null) {
                systemId = "";
            }
            if (message.length() != 0) {
                message.append("; ");
            }
            message.append(String.format("error at %d:%d in document %s", parseException.getColumnNumber(), parseException.getLineNumber(), systemId));
        }
        if (text != null) {
            message.append("; source:\n").append(text);
        }
        if (message.length() != 0) {
            message.append("; cause: ").append(e.toString());
            throw new RuntimeException(message.toString(), e);
        }
        throw Throwables.propagate((Throwable)e);
    }

    public HandlerWithResult<T> getHandler() {
        return this.handler;
    }

    @Override
    public ParseSax<T> setContext(HttpRequest request) {
        this.handler.setContext(request);
        this.request = request;
        return this;
    }

    public static abstract class HandlerForGeneratedRequestWithResult<T>
    extends HandlerWithResult<T> {
        @Override
        public HandlerForGeneratedRequestWithResult<T> setContext(HttpRequest request) {
            Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"note this handler requires a GeneratedHttpRequest");
            super.setContext(request);
            return this;
        }

        @Override
        protected GeneratedHttpRequest getRequest() {
            return (GeneratedHttpRequest)super.getRequest();
        }
    }

    public static abstract class HandlerWithResult<T>
    extends DefaultHandler
    implements InvocationContext<HandlerWithResult<T>> {
        private HttpRequest request;

        protected HttpRequest getRequest() {
            return this.request;
        }

        public abstract T getResult();

        @Override
        public HandlerWithResult<T> setContext(HttpRequest request) {
            this.request = request;
            return this;
        }
    }

    public static interface Factory {
        public <T> ParseSax<T> create(HandlerWithResult<T> var1);
    }
}

