/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.DelegatingPayload;

public abstract class BaseCipherPayload
extends DelegatingPayload {
    private final Key key;

    public BaseCipherPayload(Payload delegate, Key key) {
        super(delegate);
        this.key = (Key)Preconditions.checkNotNull((Object)key, (Object)"key");
    }

    public abstract Cipher initializeCipher(Key var1);

    @Override
    public CipherInputStream getInput() {
        return new CipherInputStream(super.getInput(), this.initializeCipher(this.key));
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        super.writeTo(new CipherOutputStream(outstream, this.initializeCipher(this.key)));
    }
}

