/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.internal;

import java.util.Date;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateServiceDateCodecFactory;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="DateServiceDateCodecFactoryTest")
public class DateServiceDateCodecFactoryTest {
    private DateServiceDateCodecFactory simpleDateCodecFactory;
    private DateCodec rfc822Codec;
    private DateCodec rfc1123Codec;
    private DateCodec iso8601Codec;
    private DateCodec iso8601SecondsCodec;

    @BeforeTest
    public void setUp() {
        this.simpleDateCodecFactory = new DateServiceDateCodecFactory((DateService)new SimpleDateFormatDateService());
        this.rfc822Codec = this.simpleDateCodecFactory.rfc822();
        this.rfc1123Codec = this.simpleDateCodecFactory.rfc1123();
        this.iso8601Codec = this.simpleDateCodecFactory.iso8601();
        this.iso8601SecondsCodec = this.simpleDateCodecFactory.iso8601Seconds();
    }

    @Test
    public void testCodecForRfc822() {
        Date date = new Date(1000L);
        Assert.assertEquals((Object)this.rfc822Codec.toDate(this.rfc822Codec.toString(date)), (Object)date);
        Assert.assertEquals((Object)this.rfc822Codec.toDate("Thu, 01 Dec 1994 16:00:00 GMT"), (Object)new Date(786297600000L));
    }

    @Test
    public void testCodecForRfc822ThrowsParseExceptionWhenMalformed() {
        try {
            this.rfc822Codec.toDate("wrong");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCodecForRfc1123() {
        Date date = new Date(1000L);
        Assert.assertEquals((Object)this.rfc1123Codec.toDate(this.rfc1123Codec.toString(date)), (Object)date);
        Assert.assertEquals((Object)this.rfc1123Codec.toDate("Thu, 01 Dec 1994 16:00:00 GMT"), (Object)new Date(786297600000L));
    }

    @Test
    public void testCodecForRfc1123ThrowsParseExceptionWhenMalformed() {
        try {
            this.rfc1123Codec.toDate("wrong");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCodecForIso8601() {
        Date date = new Date(1000L);
        Assert.assertEquals((Object)this.iso8601Codec.toDate(this.iso8601Codec.toString(date)), (Object)date);
        Assert.assertEquals((Object)this.iso8601Codec.toDate("1994-12-01T16:00:00.000Z"), (Object)new Date(786297600000L));
    }

    @Test
    public void testCodecForIso8601ThrowsParseExceptionWhenMalformed() {
        try {
            this.iso8601Codec.toDate("-");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCodecForIso8601Seconds() {
        Date date = new Date(1000L);
        Assert.assertEquals((Object)this.iso8601SecondsCodec.toDate(this.iso8601SecondsCodec.toString(date)), (Object)date);
        Assert.assertEquals((long)this.iso8601SecondsCodec.toDate("2012-11-14T21:51:28UTC").getTime(), (long)1352929888000L);
    }

    @Test
    public void testCodecForIso8601SecondsThrowsParseExceptionWhenMalformed() {
        try {
            this.iso8601SecondsCodec.toDate("-");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

