/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import org.jclouds.domain.JsonBall;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class JsonBallTest {
    private ParseJson<Map<String, JsonBall>> handler;
    private Json mapper;

    public void testJSON_STRING_PATTERN1() {
        Matcher matcher = JsonBall.JSON_STRING_PATTERN.matcher("hello");
        assert (matcher.find());
    }

    public void testJSON_STRING_PATTERN2() {
        Matcher matcher = JsonBall.JSON_STRING_PATTERN.matcher("hello world!");
        assert (matcher.find());
    }

    public void testJSON_STRING_PATTERN3() {
        Matcher matcher = JsonBall.JSON_STRING_PATTERN.matcher("\"hello world!\"");
        assert (!matcher.find());
    }

    public void testJSON_STRING_PATTERN4() {
        Matcher matcher = JsonBall.JSON_STRING_PATTERN.matcher("[hello world!]");
        assert (!matcher.find());
    }

    public void testJSON_STRING_PATTERN5() {
        Matcher matcher = JsonBall.JSON_STRING_PATTERN.matcher("{hello world!}");
        assert (!matcher.find());
    }

    public void testJSON_NUMBER_PATTERN1() {
        Matcher matcher = JsonBall.JSON_NUMBER_PATTERN.matcher("1");
        assert (matcher.find());
    }

    public void testJSON_NUMBER_PATTERN2() {
        Matcher matcher = JsonBall.JSON_NUMBER_PATTERN.matcher("1.1");
        assert (matcher.find());
    }

    public void testJSON_NUMBER_PATTERN3() {
        Matcher matcher = JsonBall.JSON_NUMBER_PATTERN.matcher("\"1.1\"");
        assert (!matcher.find());
    }

    public void testJSON_NUMBER_PATTERN4() {
        Matcher matcher = JsonBall.JSON_NUMBER_PATTERN.matcher("\"1\"");
        assert (!matcher.find());
    }

    @BeforeTest
    protected void setUpInjector() throws IOException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule()});
        this.handler = (ParseJson)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ParseJson<Map<String, JsonBall>>>(){}));
        this.mapper = (Json)injector.getInstance(Json.class);
    }

    public void testObject() {
        String json = "{\"tomcat6\":{\"ssl_port\":8433}}";
        ImmutableMap map = ImmutableMap.of((Object)"tomcat6", (Object)new JsonBall("{\"ssl_port\":8433}"));
        Assert.assertEquals((Map)((Map)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(json)).build())), (Map)map);
        Assert.assertEquals((String)this.mapper.toJson((Object)map), (String)json);
    }

    public void testList() {
        String json = "{\"list\":[8431,8433]}";
        ImmutableMap map = ImmutableMap.of((Object)"list", (Object)new JsonBall("[8431,8433]"));
        Assert.assertEquals((Map)((Map)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(json)).build())), (Map)map);
        Assert.assertEquals((String)this.mapper.toJson((Object)map), (String)json);
    }

    public void testString() {
        String json = "{\"name\":\"fooy\"}";
        ImmutableMap map = ImmutableMap.of((Object)"name", (Object)new JsonBall("fooy"));
        Assert.assertEquals((Map)((Map)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(json)).build())), (Map)map);
        Assert.assertEquals((String)this.mapper.toJson((Object)map), (String)json);
    }

    public void testNumber() {
        String json = "{\"number\":1.0}";
        ImmutableMap map = ImmutableMap.of((Object)"number", (Object)new JsonBall(1.0));
        Assert.assertEquals((Map)((Map)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(json)).build())), (Map)map);
        Assert.assertEquals((String)this.mapper.toJson((Object)map), (String)json);
    }

    public void testBoolean() {
        String json = "{\"boolean\":false}";
        ImmutableMap map = ImmutableMap.of((Object)"boolean", (Object)new JsonBall(false));
        Assert.assertEquals((Map)((Map)this.handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(json)).build())), (Map)map);
        Assert.assertEquals((String)this.mapper.toJson((Object)map), (String)json);
    }
}

