/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.io.Closeables;
import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.io.Closeable;
import java.util.Properties;
import org.jclouds.http.BaseMockWebServerTest;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.http.config.JavaUrlHttpCommandExecutorServiceModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class BackoffLimitedRetryJavaTest
extends BaseMockWebServerTest {
    private final int maxRetries = 5;

    @Override
    protected void addOverrideProperties(Properties props) {
        props.setProperty("jclouds.max-retries", "5");
    }

    @Override
    protected Module createConnectionModule() {
        return new JavaUrlHttpCommandExecutorServiceModule();
    }

    protected IntegrationTestClient client(String url) {
        return this.api(IntegrationTestClient.class, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoRetriesSuccessful() throws Exception {
        MockWebServer server = BackoffLimitedRetryJavaTest.mockWebServer(new MockResponse());
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            client.download("");
            Assert.assertEquals((int)server.getRequestCount(), (int)1);
        }
        finally {
            Closeables.close((Closeable)client, (boolean)true);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleRetrySuccessful() throws Exception {
        MockWebServer server = BackoffLimitedRetryJavaTest.mockWebServer(new MockResponse().setResponseCode(500), new MockResponse());
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            client.download("");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
        }
        finally {
            Closeables.close((Closeable)client, (boolean)true);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaximumRetriesSuccessful() throws Exception {
        MockWebServer server = BackoffLimitedRetryJavaTest.mockWebServer(new MockResponse[0]);
        for (int i = 0; i < 4; ++i) {
            server.enqueue(new MockResponse().setResponseCode(500));
        }
        server.enqueue(new MockResponse());
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            client.download("");
            Assert.assertEquals((int)server.getRequestCount(), (int)5);
        }
        finally {
            Closeables.close((Closeable)client, (boolean)true);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaximumRetriesExceeded() throws Exception {
        MockWebServer server = BackoffLimitedRetryJavaTest.mockWebServer(new MockResponse[0]);
        for (int i = 0; i <= 5; ++i) {
            server.enqueue(new MockResponse().setResponseCode(500));
        }
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            client.download("");
            Assert.fail((String)"Request should not succeed within 5 requests");
        }
        catch (HttpResponseException ex) {
            Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)500);
            Assert.assertEquals((int)server.getRequestCount(), (int)6);
        }
        finally {
            Closeables.close((Closeable)client, (boolean)true);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterleavedSuccessesAndFailures() throws Exception {
        MockWebServer server = BackoffLimitedRetryJavaTest.mockWebServer(new MockResponse(), new MockResponse());
        for (int i = 0; i <= 5; ++i) {
            server.enqueue(new MockResponse().setResponseCode(500));
        }
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            client.download("");
            client.download("");
            try {
                client.download("");
                Assert.fail((String)"Request should not succeed within 5 requests");
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)500);
                Assert.assertEquals((int)server.getRequestCount(), (int)8);
            }
        }
        finally {
            Closeables.close((Closeable)client, (boolean)true);
            server.shutdown();
        }
    }
}

