/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.internal;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jclouds.io.Payload;
import org.jclouds.io.internal.BasePayloadSlicer;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class BasePayloadSlicerTest {
    @Test
    public void testIterableSliceExpectedSingle() throws IOException {
        BasePayloadSlicer slicer = new BasePayloadSlicer();
        String contents = "aaaaaaaaaabbbbbbbbbbccccc";
        InputStreamPayload payload = new InputStreamPayload((InputStream)new ByteArrayInputStream(contents.getBytes(Charsets.US_ASCII)));
        Iterator iter = slicer.slice((Payload)payload, 25L).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Assert.assertEquals((String)new String(ByteStreams.toByteArray((InputSupplier)((InputSupplier)iter.next()))), (String)contents);
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterableSliceExpectedMulti() throws IOException {
        BasePayloadSlicer slicer = new BasePayloadSlicer();
        InputStreamPayload payload = new InputStreamPayload((InputStream)new ByteArrayInputStream("aaaaaaaaaabbbbbbbbbbccccc".getBytes(Charsets.US_ASCII)));
        Iterator iter = slicer.slice((Payload)payload, 10L).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((Payload)iter.next()).getInput()), (String)"aaaaaaaaaa");
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((Payload)iter.next()).getInput()), (String)"bbbbbbbbbb");
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((Payload)iter.next()).getInput()), (String)"ccccc");
        Assert.assertFalse((boolean)iter.hasNext());
    }
}

