/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Atomics;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test
public class GsonExperimentsTest {
    public static final String json = "['hello',5,{name:'GREETINGS',source:'guest'}]";
    private Gson gson;
    private String json2;
    private final String nested = "{ \"count\":1 ,\"event\" : [  {name:'GREETINGS',source:'guest'} ] }";
    private final String nestedFurther = "{ \"listaccountsresponse\" : { \"count\":1 ,\"event\" : [  {name:'GREETINGS',source:'guest'} ] } }";

    @BeforeTest
    void setupSource() {
        this.gson = new Gson();
        ArrayList collection = Lists.newArrayList();
        collection.add("hello");
        collection.add(5);
        collection.add(new Event("GREETINGS", "guest"));
        this.json2 = this.gson.toJson((Object)collection);
        Assert.assertEquals((String)this.json2, (String)"[\"hello\",5,{\"name\":\"GREETINGS\",\"source\":\"guest\"}]");
    }

    public void testPersistOptional() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).create();
        String json = gson.toJson((Object)new OptionalType());
        Assert.assertEquals((String)json, (String)"{\"present\":\"hello\"}");
        Assert.assertEquals((Object)gson.fromJson(json, OptionalType.class), (Object)new OptionalType());
    }

    public void testRawCollectionsWithParser() {
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(json).getAsJsonArray();
        String message = (String)this.gson.fromJson(array.get(0), String.class);
        int number = (Integer)this.gson.fromJson(array.get(1), Integer.TYPE);
        Event event = (Event)this.gson.fromJson(array.get(2), Event.class);
        Assert.assertEquals((String)message, (String)"hello");
        Assert.assertEquals((int)number, (int)5);
        Assert.assertEquals((String)event.toString(), (String)new Event("GREETINGS", "guest").toString());
    }

    public void testParseNestedElements() throws IOException {
        JsonReader reader = new JsonReader((Reader)new StringReader("{ \"count\":1 ,\"event\" : [  {name:'GREETINGS',source:'guest'} ] }"));
        List val = (List)this.parseThingFromReaderOrNull("event", reader, new TypeLiteral<List<Event>>(){}.getType());
        Assert.assertEquals((String)val.toString(), (String)"[(name=GREETINGS, source=guest)]");
    }

    public void testParseNestedFurtherElements() throws IOException {
        JsonReader reader = new JsonReader((Reader)new StringReader("{ \"listaccountsresponse\" : { \"count\":1 ,\"event\" : [  {name:'GREETINGS',source:'guest'} ] } }"));
        List val = (List)this.parseThingFromReaderOrNull("event", reader, new TypeLiteral<List<Event>>(){}.getType());
        Assert.assertEquals((String)val.toString(), (String)"[(name=GREETINGS, source=guest)]");
    }

    protected <T> T parseThingFromReaderOrNull(String toFind, JsonReader reader, Type type) throws IOException {
        AtomicReference name = Atomics.newReference();
        JsonToken token = reader.peek();
        while (token != JsonToken.END_DOCUMENT && this.nnn(toFind, reader, token, name)) {
            token = this.skipAndPeek(token, reader);
        }
        Object val = this.gson.fromJson(reader, type);
        reader.close();
        return (T)val;
    }

    protected boolean nnn(String toFind, JsonReader reader, JsonToken token, AtomicReference<String> name) throws IOException {
        String name2;
        if (token == JsonToken.NAME && toFind.equals(name2 = reader.nextName())) {
            name.set(name2);
            return false;
        }
        return true;
    }

    public JsonToken skipAndPeek(JsonToken token, JsonReader reader) throws IOException {
        switch (token) {
            case BEGIN_ARRAY: {
                reader.beginArray();
                break;
            }
            case END_ARRAY: {
                reader.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                reader.beginObject();
                break;
            }
            case END_OBJECT: {
                reader.endObject();
                break;
            }
            case NAME: {
                break;
            }
            case STRING: {
                reader.nextString();
                break;
            }
            case NUMBER: {
                reader.nextString();
                break;
            }
            case BOOLEAN: {
                reader.nextBoolean();
                break;
            }
            case NULL: {
                reader.nextNull();
                break;
            }
        }
        return reader.peek();
    }

    static class OptionalType {
        Optional<String> present = Optional.of((Object)"hello");
        Optional<String> notPresent = Optional.absent();

        OptionalType() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof OptionalType) {
                OptionalType other = (OptionalType)OptionalType.class.cast(object);
                return Objects.equal(this.present, other.present) && Objects.equal(this.notPresent, other.notPresent);
            }
            return false;
        }
    }

    public class OptionalTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Type type = typeToken.getType();
            if (typeToken.getRawType() != Optional.class || !(type instanceof ParameterizedType)) {
                return null;
            }
            Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
            TypeAdapter elementAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
            return this.newOptionalAdapter(elementAdapter);
        }

        private <E> TypeAdapter<Optional<E>> newOptionalAdapter(final TypeAdapter<E> elementAdapter) {
            return new TypeAdapter<Optional<E>>(){

                public void write(JsonWriter out, Optional<E> value) throws IOException {
                    if (value == null || !value.isPresent()) {
                        out.nullValue();
                        return;
                    }
                    elementAdapter.write(out, value.get());
                }

                public Optional<E> read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.NULL) {
                        in.nextNull();
                        return Optional.absent();
                    }
                    return Optional.of((Object)elementAdapter.read(in));
                }
            };
        }
    }

    static class Event {
        private String name;
        private String source;

        private Event(String name, String source) {
            this.name = name;
            this.source = source;
        }

        public String toString() {
            return String.format("(name=%s, source=%s)", this.name, this.source);
        }
    }
}

