/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.implicit;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.NoSuchElementException;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.implicit.FirstNetwork;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FirstNetworkTest")
public class FirstNetworkTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("servo").description("http://servo").build();
    Location region = new LocationBuilder().scope(LocationScope.REGION).id("servo-r").description("http://r.servo").parent(this.provider).build();
    Location network = new LocationBuilder().scope(LocationScope.NETWORK).id("servo-n").description("http://z.r.servo").parent(this.region).build();

    @Test
    public void testDidntFindNetworkThrowsNSEEWithReasonableMessage() {
        Supplier supplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider, (Object)this.region));
        FirstNetwork fn = new FirstNetwork(supplier);
        try {
            fn.get();
            Assert.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"none of the locations are scope NETWORK: [servo:PROVIDER, servo-r:REGION]");
        }
    }

    @Test
    public void testFirstNetwork() {
        Supplier supplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider, (Object)this.region, (Object)this.network));
        FirstNetwork fn = new FirstNetwork(supplier);
        Assert.assertEquals((Object)fn.get(), (Object)this.network);
    }
}

