/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain;

import com.google.common.base.Optional;
import org.jclouds.domain.Credentials;
import org.jclouds.javax.annotation.Nullable;

public class LoginCredentials
extends Credentials {
    private final boolean authenticateSudo;
    private final Optional<String> password;
    private final Optional<String> privateKey;

    private static boolean isPrivateKeyCredential(String credential) {
        return credential != null && (credential.startsWith("-----BEGIN RSA PRIVATE KEY-----") || credential.startsWith("-----BEGIN PRIVATE KEY-----"));
    }

    public static LoginCredentials fromCredentials(Credentials creds) {
        if (creds == null) {
            return null;
        }
        if (creds instanceof LoginCredentials) {
            return (LoginCredentials)LoginCredentials.class.cast(creds);
        }
        return LoginCredentials.builder(creds).build();
    }

    public static Builder builder(Credentials creds) {
        if (creds == null) {
            return LoginCredentials.builder();
        }
        if (creds instanceof LoginCredentials) {
            return ((LoginCredentials)LoginCredentials.class.cast(creds)).toBuilder();
        }
        return LoginCredentials.builder().identity(creds.identity).credential(creds.credential);
    }

    public static Builder builder() {
        return new Builder();
    }

    private LoginCredentials(String username, @Nullable Optional<String> password, @Nullable Optional<String> privateKey, boolean authenticateSudo) {
        super(username, privateKey != null && privateKey.isPresent() && LoginCredentials.isPrivateKeyCredential((String)privateKey.get()) ? (String)privateKey.get() : (password != null && password.isPresent() ? (String)password.get() : null));
        this.authenticateSudo = authenticateSudo;
        this.password = password;
        this.privateKey = privateKey;
    }

    public String getUser() {
        return this.identity;
    }

    @Nullable
    public String getPassword() {
        return this.password != null ? (String)this.password.orNull() : null;
    }

    @Nullable
    public Optional<String> getOptionalPassword() {
        return this.password;
    }

    @Nullable
    public String getPrivateKey() {
        return this.privateKey != null ? (String)this.privateKey.orNull() : null;
    }

    public boolean hasUnencryptedPrivateKey() {
        return this.getPrivateKey() != null && !this.getPrivateKey().isEmpty() && !this.getPrivateKey().contains("Proc-Type: 4,ENCRYPTED");
    }

    @Nullable
    public Optional<String> getOptionalPrivateKey() {
        return this.privateKey;
    }

    public boolean shouldAuthenticateSudo() {
        return this.authenticateSudo;
    }

    public Builder toBuilder() {
        Builder builder = new Builder().user(this.identity).authenticateSudo(this.authenticateSudo);
        if (this.password != null) {
            builder = this.password.isPresent() ? builder.password((String)this.password.get()) : builder.noPassword();
        }
        if (this.privateKey != null) {
            builder = this.privateKey.isPresent() ? builder.privateKey((String)this.privateKey.get()) : builder.noPrivateKey();
        }
        return builder;
    }

    @Override
    public String toString() {
        return "[user=" + this.getUser() + ", passwordPresent=" + this.password.isPresent() + ", privateKeyPresent=" + this.privateKey.isPresent() + ", shouldAuthenticateSudo=" + this.authenticateSudo + "]";
    }

    public static class Builder
    extends Credentials.Builder<LoginCredentials> {
        private boolean authenticateSudo;
        private Optional<String> password;
        private Optional<String> privateKey;

        public Builder identity(String identity) {
            return (Builder)Builder.class.cast(super.identity(identity));
        }

        public Builder user(String user) {
            return this.identity(user);
        }

        public Builder password(String password) {
            this.password = Optional.fromNullable((Object)password);
            if (this.privateKey == null) {
                this.noPrivateKey();
            }
            return this;
        }

        public Builder noPassword() {
            this.password = Optional.absent();
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = Optional.fromNullable((Object)privateKey);
            if (this.password == null) {
                this.noPassword();
            }
            return this;
        }

        public Builder noPrivateKey() {
            this.privateKey = Optional.absent();
            return this;
        }

        public Builder credential(String credential) {
            if (LoginCredentials.isPrivateKeyCredential(credential)) {
                return this.noPassword().privateKey(credential);
            }
            if (credential != null) {
                return this.password(credential).noPrivateKey();
            }
            return this;
        }

        public Builder authenticateSudo(boolean authenticateSudo) {
            this.authenticateSudo = authenticateSudo;
            return this;
        }

        @Override
        public LoginCredentials build() {
            if (this.identity == null && this.password == null && this.privateKey == null && !this.authenticateSudo) {
                return null;
            }
            return new LoginCredentials(this.identity, this.password, this.privateKey, this.authenticateSudo);
        }
    }
}

