/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.reflect.TypeToken;
import com.google.inject.Module;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.javax.annotation.Nullable;

@Beta
public interface ApiMetadata {
    public Builder<?> toBuilder();

    public String getId();

    public String getName();

    public String getEndpointName();

    public String getIdentityName();

    public Optional<String> getCredentialName();

    public String getVersion();

    public Optional<String> getBuildVersion();

    public Optional<String> getDefaultEndpoint();

    public Optional<String> getDefaultIdentity();

    public Optional<String> getDefaultCredential();

    public Properties getDefaultProperties();

    public Set<Class<? extends Module>> getDefaultModules();

    public URI getDocumentation();

    public TypeToken<? extends Context> getContext();

    public Set<TypeToken<? extends View>> getViews();

    public static interface Builder<B extends Builder<B>> {
        public B id(String var1);

        public B name(String var1);

        public B context(TypeToken<? extends Context> var1);

        public B view(Class<? extends View> var1);

        public B view(TypeToken<? extends View> var1);

        public B views(Set<TypeToken<? extends View>> var1);

        public B endpointName(String var1);

        public B identityName(String var1);

        public B credentialName(@Nullable String var1);

        public B version(String var1);

        public B buildVersion(@Nullable String var1);

        public B defaultEndpoint(@Nullable String var1);

        public B defaultIdentity(@Nullable String var1);

        public B defaultCredential(@Nullable String var1);

        public B defaultProperties(Properties var1);

        public B defaultModule(Class<? extends Module> var1);

        public B defaultModules(Set<Class<? extends Module>> var1);

        public B documentation(URI var1);

        public ApiMetadata build();

        public B fromApiMetadata(ApiMetadata var1);
    }
}

