/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Region;

@Singleton
public class RegionToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier;

    @Inject
    public RegionToEndpoint(@Region Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier) {
        this.regionToEndpointSupplier = (Supplier)Preconditions.checkNotNull(regionToEndpointSupplier, (Object)"regionToEndpointSupplier");
    }

    public URI apply(@Nullable Object from) {
        Preconditions.checkArgument((from != null && from instanceof String ? 1 : 0) != 0, (Object)"you must specify a region, as a String argument");
        Map regionToEndpoint = (Map)this.regionToEndpointSupplier.get();
        Preconditions.checkState((regionToEndpoint.size() > 0 ? 1 : 0) != 0, (Object)"no region name to endpoint mappings configured!");
        Preconditions.checkArgument((boolean)regionToEndpoint.containsKey(from), (String)"requested location %s, which is not in the configured locations: %s", (Object[])new Object[]{from, regionToEndpoint});
        return (URI)((Supplier)regionToEndpoint.get(from)).get();
    }
}

