/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.reflect.TypeToken;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.json.internal.DeserializationConstructorAndReflectiveTypeAdapterFactory;
import org.jclouds.json.internal.NamingStrategies;
import org.jclouds.json.internal.OptionalTypeAdapterFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="DeserializationConstructorTypeAdapterFactoryTest")
public final class DeserializationConstructorAndReflectiveTypeAdapterFactoryTest {
    Gson gson = new Gson();
    DeserializationConstructorAndReflectiveTypeAdapterFactory parameterizedCtorFactory = DeserializationConstructorAndReflectiveTypeAdapterFactoryTest.parameterizedCtorFactory();

    static DeserializationConstructorAndReflectiveTypeAdapterFactory parameterizedCtorFactory() {
        NamingStrategies.AnnotationOrNameFieldNamingStrategy serializationPolicy = new NamingStrategies.AnnotationOrNameFieldNamingStrategy((Iterable)ImmutableSet.of((Object)new NamingStrategies.ExtractSerializedName(), (Object)new NamingStrategies.ExtractNamed()));
        NamingStrategies.AnnotationConstructorNamingStrategy deserializationPolicy = new NamingStrategies.AnnotationConstructorNamingStrategy((Collection)ImmutableSet.of(ConstructorProperties.class, Inject.class), (Iterable)ImmutableSet.of((Object)new NamingStrategies.ExtractNamed()));
        return new DeserializationConstructorAndReflectiveTypeAdapterFactory(new ConstructorConstructor((Map)ImmutableMap.of()), (FieldNamingStrategy)serializationPolicy, Excluder.DEFAULT, deserializationPolicy);
    }

    public void testNullWhenPrimitive() {
        Assert.assertNull((Object)this.parameterizedCtorFactory.create(this.gson, TypeToken.get(Integer.TYPE)));
    }

    public void testRejectsIfNoConstuctorMarked() throws IOException {
        TypeAdapter adapter = this.parameterizedCtorFactory.create(this.gson, TypeToken.get(DefaultConstructor.class));
        Assert.assertNull((Object)adapter);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".* parameter 0 failed to be named by AnnotationBasedNamingStrategy requiring one of javax.inject.Named")
    public void testSerializedNameRequiredOnAllParameters() {
        this.parameterizedCtorFactory.create(this.gson, TypeToken.get(WithDeserializationConstructorButWithoutSerializedName.class));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Multiple entries with same key: foo.*")
    public void testNoDuplicateSerializedNamesRequiredOnAllParameters() {
        this.parameterizedCtorFactory.create(this.gson, TypeToken.get(DuplicateSerializedNames.class));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="absent!")
    public void testValidatedConstructor() throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)this.parameterizedCtorFactory).registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).create();
        Assert.assertEquals((Object)new ValidatedConstructor((Optional<Integer>)Optional.of((Object)0), 1), (Object)gson.fromJson("{\"foo\":0,\"bar\":1}", ValidatedConstructor.class));
        gson.fromJson("{\"bar\":1}", ValidatedConstructor.class);
    }

    public void testGenericParamsCopiedIn() throws IOException {
        TypeAdapter adapter = this.parameterizedCtorFactory.create(this.gson, TypeToken.get(GenericParamsCopiedIn.class));
        ArrayList inputFoo = Lists.newArrayList();
        inputFoo.add("one");
        HashMap inputBar = Maps.newHashMap();
        inputBar.put("2", "two");
        GenericParamsCopiedIn toTest = (GenericParamsCopiedIn)adapter.fromJson("{ \"foo\":[\"one\"], \"bar\":{ \"2\":\"two\"}}");
        Assert.assertEquals((Collection)inputFoo, toTest.foo);
        Assert.assertNotSame((Object)inputFoo, toTest.foo);
        Assert.assertEquals((Map)inputBar, toTest.bar);
    }

    public void testCanOverrideDefault() throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)this.parameterizedCtorFactory).create();
        Assert.assertEquals((Object)new RenamedFields(0, 1), (Object)gson.fromJson("{\"foo\":0,\"_bar\":1}", RenamedFields.class));
        Assert.assertEquals((String)gson.toJson((Object)new RenamedFields(0, 1)), (String)"{\"foo\":0,\"_bar\":1}");
    }

    public void testRenamedFields() throws IOException {
        TypeAdapter adapter = this.parameterizedCtorFactory.create(this.gson, TypeToken.get(RenamedFields.class));
        Assert.assertEquals((Object)new RenamedFields(0, 1), (Object)adapter.fromJson("{\"foo\":0,\"_bar\":1}"));
        Assert.assertEquals((String)adapter.toJson((Object)new RenamedFields(0, 1)), (String)"{\"foo\":0,\"_bar\":1}");
    }

    public void checkSimpleComposedObject() throws IOException {
        ValidatedConstructor x = new ValidatedConstructor((Optional<Integer>)Optional.of((Object)0), 1);
        ValidatedConstructor y = new ValidatedConstructor((Optional<Integer>)Optional.of((Object)1), 2);
        TypeAdapter adapter = this.parameterizedCtorFactory.create(this.gson, TypeToken.get(ComposedObjects.class));
        Assert.assertEquals((Object)new ComposedObjects(x, y), (Object)adapter.fromJson("{\"x\":{\"foo\":0,\"bar\":1},\"y\":{\"foo\":1,\"bar\":2}}"));
    }

    public void testEmptyObjectIsNull() throws IOException {
        TypeAdapter adapter = this.parameterizedCtorFactory.create(this.gson, TypeToken.get(ComposedObjects.class));
        Assert.assertNull((Object)adapter.fromJson("{}"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testPartialObjectStillThrows() throws IOException {
        TypeAdapter adapter = this.parameterizedCtorFactory.create(this.gson, TypeToken.get(ComposedObjects.class));
        Assert.assertNull((Object)adapter.fromJson("{\"x\":{\"foo\":0,\"bar\":1}}"));
    }

    private static class ComposedObjects {
        final ValidatedConstructor x;
        final ValidatedConstructor y;

        @ConstructorProperties(value={"x", "y"})
        ComposedObjects(ValidatedConstructor x, ValidatedConstructor y) {
            this.x = (ValidatedConstructor)Preconditions.checkNotNull((Object)x);
            this.y = (ValidatedConstructor)Preconditions.checkNotNull((Object)y);
        }

        public boolean equals(Object obj) {
            ComposedObjects other = (ComposedObjects)ComposedObjects.class.cast(obj);
            return other != null && Objects.equal((Object)this.x, (Object)other.x) && Objects.equal((Object)this.y, (Object)other.y);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.x, this.y});
        }
    }

    private static class RenamedFields {
        final int foo;
        @Named(value="_bar")
        final int bar;

        @ConstructorProperties(value={"foo", "_bar"})
        RenamedFields(int foo, int bar) {
            if (foo < 0) {
                throw new IllegalArgumentException("negative!");
            }
            this.foo = foo;
            this.bar = bar;
        }

        public boolean equals(Object obj) {
            RenamedFields other = (RenamedFields)RenamedFields.class.cast(obj);
            return other != null && Objects.equal((Object)this.foo, (Object)other.foo) && Objects.equal((Object)this.bar, (Object)other.bar);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.foo, this.bar});
        }
    }

    private static class GenericParamsCopiedIn {
        final List<String> foo;
        final Map<String, String> bar;

        @Inject
        GenericParamsCopiedIn(@Named(value="foo") List<String> foo, @Named(value="bar") Map<String, String> bar) {
            this.foo = Lists.newArrayList(foo);
            this.bar = Maps.newHashMap(bar);
        }
    }

    private static class ValidatedConstructor {
        final int foo;
        final int bar;

        @Inject
        ValidatedConstructor(@Named(value="foo") Optional<Integer> foo, @Named(value="bar") int bar) {
            if (!foo.isPresent()) {
                throw new IllegalArgumentException("absent!");
            }
            this.foo = (Integer)foo.get();
            this.bar = bar;
        }

        public boolean equals(Object obj) {
            ValidatedConstructor other = (ValidatedConstructor)ValidatedConstructor.class.cast(obj);
            return other != null && Objects.equal((Object)this.foo, (Object)other.foo) && Objects.equal((Object)this.bar, (Object)other.bar);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.foo, this.bar});
        }
    }

    private static class DuplicateSerializedNames {
        final int foo;
        final int bar;

        @Inject
        DuplicateSerializedNames(@Named(value="foo") int foo, @Named(value="foo") int bar) {
            this.foo = foo;
            this.bar = bar;
        }
    }

    private static class WithDeserializationConstructorButWithoutSerializedName {
        final int foo;

        @Inject
        WithDeserializationConstructorButWithoutSerializedName(int foo) {
            this.foo = foo;
        }
    }

    private static class DefaultConstructor {
        int foo;
        int bar;

        private DefaultConstructor() {
        }
    }
}

