/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.location.suppliers.all.ZoneToProvider;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ZoneToProviderTest")
public class ZoneToProviderTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("servo").description("http://servo").iso3166Codes((Iterable)ImmutableSet.of((Object)"US")).build();
    JustProvider justProvider = new JustProvider("servo", Suppliers.ofInstance((Object)URI.create("http://servo")), (Set)ImmutableSet.of((Object)"US"));

    @Test
    public void test() {
        Supplier zoneIdsSupplier = Suppliers.ofInstance((Object)ImmutableSet.of((Object)"zone1", (Object)"zone2"));
        Supplier locationToIsoCodes = Suppliers.ofInstance((Object)ImmutableMap.of((Object)"servo", (Object)Suppliers.ofInstance((Object)ImmutableSet.of((Object)"US")), (Object)"zone1", (Object)Suppliers.ofInstance((Object)ImmutableSet.of((Object)"US-CA")), (Object)"zone2", (Object)Suppliers.ofInstance((Object)ImmutableSet.of((Object)"US-VA"))));
        ZoneToProvider fn = new ZoneToProvider(this.justProvider, zoneIdsSupplier, locationToIsoCodes);
        Assert.assertEquals((Set)fn.get(), (Set)ImmutableSet.of((Object)new LocationBuilder().scope(LocationScope.ZONE).id("zone1").description("zone1").iso3166Codes((Iterable)ImmutableSet.of((Object)"US-CA")).parent(this.provider).build(), (Object)new LocationBuilder().scope(LocationScope.ZONE).id("zone2").description("zone2").iso3166Codes((Iterable)ImmutableSet.of((Object)"US-VA")).parent(this.provider).build()));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWhenNoZones() {
        Supplier zoneIdsSupplier = Suppliers.ofInstance((Object)ImmutableSet.of());
        Supplier locationToIsoCodes = Suppliers.ofInstance((Object)ImmutableMap.of());
        ZoneToProvider fn = new ZoneToProvider(this.justProvider, zoneIdsSupplier, locationToIsoCodes);
        fn.get();
    }
}

