/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.io.ByteSource;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rest.config.CredentialStoreModule;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class CredentialStoreModuleTest {
    Json json = (Json)this.createInjector().getInstance(Json.class);

    @DataProvider(name="credentials")
    public Object[][] createData() {
        return new Object[][]{{"root", "-----BEGIN RSA PRIVATE KEY-----\nMIIEpQIBAAKCAQEAyb2ZJJqGm0KKR+8nfQJNsSd+F9tXNMV7CfOcW6jsqs8EZgiV\nR09hD1IYOj4YqM0qJONlgyg4xRWewdSG7QTPj1lJpVAida9sXy2+kzyagZA1Am0O\nZcbqb5hoeIDgcX+eDa79s0u0DomjcfO9EKhvHLBz+zM+3QqPRkPV8nYTbfs+HjVz\nzOU6D1B0XR3+IPZZl2AnWs2d0qhnStHcDUvnRVQ0P482YwN9VgceOZtpPz0DCKEJ\n5Tx5STub8k0/zt/VAMHQafLSuQMLd2s4ZLuOZptN//uAsTmxireqd37z+8ZTdBbJ\n8LEpJ+iCXuSfm5aUh7iw6oxvToY2AL53+jK2UQIDAQABAoIBAQDA88B3i/xWn0vX\nBVxFamCYoecuNjGwXXkSyZew616A+EOCu47bh4aTurdFbYL0YFaAtaWvzlaN2eHg\nDb+HDuTefE29+WkcGk6SshPmiz5T0XOCAICWw6wSVDkHmGwS4jZvbAFm7W8nwGk9\nYhxgxFiRngswJZFopOLoF5WXs2td8guIYNslMpo7tu50iFnBHwKO2ZsPAk8t9nnS\nxlDavKruymEmqHCr3+dtio5eaenJcp3fjoXBQOKUk3ipII29XRB8NqeCVV/7Kxwq\nckqOBEbRwBclckyIbD+RiAgKvOelORjEiE9R42vuqvxRA6k9kd9o7utlX0AUtpEn\n3gZc6LepAoGBAP9ael5Y75+sK2JJUNOOhO8ae45cdsilp2yI0X+UBaSuQs2+dyPp\nkpEHAxd4pmmSvn/8c9TlEZhr+qYbABXVPlDncxpIuw2Ajbk7s/S4XaSKsRqpXL57\nzj/QOqLkRk8+OVV9q6lMeQNqLtEj1u6JPviX70Ro+FQtRttNOYbfdP/fAoGBAMpA\nXjR5woV5sUb+REg9vEuYo8RSyOarxqKFCIXVUNsLOx+22+AK4+CQpbueWN7jotrl\nYD6uT6svWi3AAC7kiY0UI/fjVPRCUi8tVoQUE0TaU5VLITaYOB+W/bBaDE4M9560\n1NuDWO90baA5dfU44iuzva02rGJXK9+nS3o8nk/PAoGBALOL6djnDe4mwAaG6Jco\ncd4xr8jkyPzCRZuyBCSBbwphIUXLc7hDprPky064ncJD1UDmwIdkXd/fpMkg2QmA\n/CUk6LEFjMisqHojOaCL9gQZJPhLN5QUN2x1PJWGjs1vQh8Tkx0iUUCOa8bQPXNR\n+34OTsW6TUna4CSZAycLfhffAoGBAIggVsefBCvuQkF0NeUhmDCRZfhnd8y55RHR\n1HCvqKIlpv+rhcX/zmyBLuteopYyRJRsOiE2FW00i8+rIPRu4Z3Q5nybx7w3PzV9\noHN5R5baE9OyI4KpZWztpYYitZF67NcnAvVULHHOvVJQGnKYfLHJYmrJF7GA1ojM\nAuMdFbjFAoGAPxUhxwFy8gaqBahKUEZn4F81HFP5ihGhkT4QL6AFPO2e+JhIGjuR\n27+85hcFqQ+HHVtFsm81b/a+R7P4UuCRgc8eCjxQMoJ1Xl4n7VbjPbHMnIN0Ryvd\nO4ZpWDWYnCO021JTOUUOJ4J/y0416Bvkw0z59y7sNX7wDBBHHbK/XCc=\n-----END RSA PRIVATE KEY-----\n"}, {"identity", "Base64=="}, {"user@domain", "pa$sw@rd"}, {"user", "unic\u20aade"}};
    }

    @Test(dataProvider="credentials")
    public void deleteObject(String identity, String credential) throws InterruptedException, IOException {
        Injector injector = this.createInjector();
        Map<String, ByteSource> map = this.getMap(injector);
        this.check(map, this.getStore(injector), "i-20312", new Credentials(identity, credential));
    }

    public void testProvidedMapWithValue() throws IOException {
        ConcurrentHashMap<String, ByteSource> map = new ConcurrentHashMap<String, ByteSource>();
        map.put("test", ByteSource.wrap((byte[])this.json.toJson((Object)new Credentials("user", "pass")).getBytes()));
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", new Credentials("user", "pass"));
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", new Credentials("user", "pass"));
        this.remove(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test");
    }

    public void testProvidedConsistentAcrossRepeatedWrites() throws IOException {
        ConcurrentHashMap<String, ByteSource> map = new ConcurrentHashMap<String, ByteSource>();
        Injector injector = this.createInjectorWithProvidedMap(map);
        Assert.assertEquals((Map)((Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, ByteSource>>(){}))), map);
        Map<String, Credentials> store = this.getStore(injector);
        for (int i = 0; i < 10; ++i) {
            this.check(map, store, "test" + i, new Credentials("user" + i, "pass" + i));
        }
    }

    public void testProvidedConsistentAcrossMultipleInjectors() throws IOException {
        ConcurrentHashMap<String, ByteSource> map = new ConcurrentHashMap<String, ByteSource>();
        this.put(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", new Credentials("user", "pass"));
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", new Credentials("user", "pass"));
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", new Credentials("user", "pass"));
        this.remove(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test");
    }

    public void testDefaultConsistentAcrossMultipleInjectors() throws IOException {
        Map<String, ByteSource> map = this.getMap(this.createInjector());
        this.put(map, this.getStore(this.createInjector()), "test", new Credentials("user", "pass"));
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", new Credentials("user", "pass"));
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", new Credentials("user", "pass"));
        this.remove(map, this.getStore(this.createInjector()), "test");
    }

    public void testLoginConsistentAcrossMultipleInjectorsAndLooksNice() throws IOException {
        Map<String, ByteSource> map = this.getMap(this.createInjector());
        LoginCredentials creds = LoginCredentials.builder().user("user").password("pass").build();
        this.put(map, this.getStore(this.createInjector()), "test", (Credentials)creds);
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", (Credentials)creds, "{\"user\":\"user\",\"password\":\"pass\"}");
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", (Credentials)creds, "{\"user\":\"user\",\"password\":\"pass\"}");
        this.remove(map, this.getStore(this.createInjector()), "test");
    }

    public void testLoginConsistentAcrossMultipleInjectorsAndLooksNiceWithSudo() throws IOException {
        Map<String, ByteSource> map = this.getMap(this.createInjector());
        LoginCredentials creds = LoginCredentials.builder().user("user").password("pass").authenticateSudo(true).build();
        this.put(map, this.getStore(this.createInjector()), "test", (Credentials)creds);
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", (Credentials)creds, "{\"user\":\"user\",\"password\":\"pass\",\"authenticateSudo\":true}");
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", (Credentials)creds, "{\"user\":\"user\",\"password\":\"pass\",\"authenticateSudo\":true}");
        this.remove(map, this.getStore(this.createInjector()), "test");
    }

    public void testCredentialsToByteSourceConversion() throws Exception {
        Function<Credentials, ByteSource> toBytesFunc = this.getCredentialsToByteStoreFunction(this.createInjector());
        Function<ByteSource, Credentials> fromBytesFunc = this.getByteStoreToCredentialsFunction(this.createInjector());
        LoginCredentials creds = LoginCredentials.builder().user("myuser").password("mypass").authenticateSudo(true).build();
        ByteSource bytes = (ByteSource)toBytesFunc.apply((Object)creds);
        LoginCredentials deserializedCreds = (LoginCredentials)fromBytesFunc.apply((Object)bytes);
        String json = bytes.asCharSource(Charsets.UTF_8).read();
        Assert.assertEquals((String)json, (String)"{\"user\":\"myuser\",\"password\":\"mypass\",\"authenticateSudo\":true}");
        Assert.assertEquals((String)deserializedCreds.identity, (String)creds.identity);
        Assert.assertEquals((String)deserializedCreds.credential, (String)creds.credential);
        Assert.assertEquals((String)deserializedCreds.getUser(), (String)creds.getUser());
        Assert.assertEquals((Object)deserializedCreds.getOptionalPassword(), (Object)creds.getOptionalPassword());
        Assert.assertEquals((Object)deserializedCreds.getOptionalPrivateKey(), (Object)creds.getOptionalPrivateKey());
        Assert.assertEquals((boolean)deserializedCreds.shouldAuthenticateSudo(), (boolean)creds.shouldAuthenticateSudo());
    }

    protected Map<String, Credentials> getStore(Injector injector) {
        return (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, Credentials>>(){}));
    }

    protected Map<String, ByteSource> getMap(Injector injector) {
        return (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, ByteSource>>(){}));
    }

    protected Function<ByteSource, Credentials> getByteStoreToCredentialsFunction(Injector injector) {
        return (Function)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Function<ByteSource, Credentials>>(){}));
    }

    protected Function<Credentials, ByteSource> getCredentialsToByteStoreFunction(Injector injector) {
        return (Function)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Function<Credentials, ByteSource>>(){}));
    }

    protected Injector createInjectorWithProvidedMap(Map<String, ByteSource> map) {
        return Guice.createInjector((Module[])new Module[]{new CredentialStoreModule(map), new GsonModule()});
    }

    protected Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{new CredentialStoreModule(), new GsonModule()});
    }

    protected void check(Map<String, ByteSource> map, Map<String, Credentials> store, String key, Credentials creds) throws IOException {
        this.put(map, store, key, creds);
        this.checkConsistent(map, store, key, creds);
        this.remove(map, store, key);
    }

    protected void remove(Map<String, ByteSource> map, Map<String, Credentials> store, String key) {
        store.remove(key);
        Assert.assertEquals((int)store.size(), (int)0);
        Assert.assertEquals((int)map.size(), (int)0);
        Assert.assertEquals((Object)store.get(key), null);
        Assert.assertEquals((Object)map.get(key), null);
    }

    protected void checkConsistent(Map<String, ByteSource> map, Map<String, Credentials> store, String key, Credentials creds) throws IOException {
        this.checkConsistent(map, store, key, creds, this.json.toJson((Object)creds));
    }

    protected void checkConsistent(Map<String, ByteSource> map, Map<String, Credentials> store, String key, Credentials creds, String expected) throws IOException {
        Assert.assertEquals((int)store.size(), (int)1);
        Assert.assertEquals((int)map.size(), (int)1);
        Assert.assertTrue((boolean)store.containsKey(key));
        Assert.assertTrue((boolean)store.containsValue(creds));
        Assert.assertEquals((Object)store.get(key), (Object)creds);
        Assert.assertEquals((Object)store.get(key), (Object)creds);
        this.checkToJson(map, key, expected);
        this.checkToJson(map, key, expected);
    }

    protected void checkToJson(Map<String, ByteSource> map, String key, String expected) throws IOException {
        Assert.assertEquals((String)map.get(key).asCharSource(Charsets.UTF_8).read(), (String)expected);
    }

    protected void put(Map<String, ByteSource> map, Map<String, Credentials> store, String key, Credentials creds) {
        Assert.assertEquals((int)store.size(), (int)0);
        Assert.assertEquals((int)map.size(), (int)0);
        Assert.assertFalse((boolean)store.containsKey(key));
        Assert.assertFalse((boolean)store.containsValue(creds));
        store.put(key, creds);
    }
}

