/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.io.File;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindToJsonPayloadTest")
public class BindToJsonPayloadTest {
    Json json = new GsonWrapper(new Gson());

    @Test
    public void testMap() throws SecurityException, NoSuchMethodException {
        BindToJsonPayload binder = new BindToJsonPayload(this.json);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        request = binder.bindToRequest(request, (Object)ImmutableMap.of((Object)"imageName", (Object)"foo", (Object)"serverId", (Object)"2"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"{\"imageName\":\"foo\",\"serverId\":\"2\"}");
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"application/json");
    }

    @Test
    public void testSomethingNotAMap() throws SecurityException, NoSuchMethodException {
        BindToJsonPayload binder = new BindToJsonPayload(this.json);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        request = binder.bindToRequest(request, (Object)new File("foo"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"{\"path\":\"foo\"}");
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"application/json");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        BindToJsonPayload binder = new BindToJsonPayload(this.json);
        binder.bindToRequest(HttpRequest.builder().method("GET").endpoint("http://momma").build(), null);
    }
}

