/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.concurrent.config.ExecutorServiceModuleTest;
import org.jclouds.concurrent.config.ScheduledExecutorServiceModule;
import org.jclouds.lifecycle.Closer;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class ScheduledExecutorServiceModuleTest {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Injector injector;

    @BeforeClass
    private void setupExecutorModule() {
        ScheduledExecutorServiceModule module = new ScheduledExecutorServiceModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.scheduler-threads")).to(1);
                super.configure();
            }
        };
        this.injector = Guice.createInjector((Module[])new Module[]{module});
    }

    @AfterClass
    private void close() throws IOException {
        ListeningScheduledExecutorService sched = (ListeningScheduledExecutorService)this.injector.getInstance(Key.get(ListeningScheduledExecutorService.class, (Annotation)Names.named((String)"jclouds.scheduler-threads")));
        ((Closer)this.injector.getInstance(Closer.class)).close();
        Assert.assertTrue((boolean)sched.isShutdown());
    }

    @Test
    public void testShutdownOnClose() throws IOException {
        Injector i = Guice.createInjector((Module[])new Module[0]);
        Closer closer = (Closer)i.getInstance(Closer.class);
        ListeningScheduledExecutorService executor = (ListeningScheduledExecutorService)EasyMock.createMock(ListeningScheduledExecutorService.class);
        ExecutorServiceModule.shutdownOnClose((ListeningExecutorService)executor, (Closer)closer);
        EasyMock.expect((Object)executor.shutdownNow()).andReturn((Object)ImmutableList.of()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{executor});
        closer.close();
        EasyMock.verify((Object[])new Object[]{executor});
    }

    @Test(timeOut=5000L)
    public void testExceptionInSubmitRunnableIncludesSubmissionTrace() throws Exception {
        ListeningScheduledExecutorService sched = (ListeningScheduledExecutorService)this.injector.getInstance(Key.get(ListeningScheduledExecutorService.class, (Annotation)Names.named((String)"jclouds.scheduler-threads")));
        String submission = null;
        try {
            submission = Throwables.getStackTraceAsString((Throwable)ExecutorServiceModuleTest.incrementInitialElement(new RuntimeException(), 2)).replaceFirst(String.format(".*%s", LINE_SEPARATOR), "");
            sched.submit(ExecutorServiceModuleTest.runnableThrowsRTE()).get();
        }
        catch (ExecutionException e) {
            ExecutorServiceModuleTest.assertTraceHasSubmission(Throwables.getStackTraceAsString((Throwable)e), submission);
            ExecutorServiceModuleTest.assertTraceHasSubmission(Throwables.getStackTraceAsString((Throwable)e.getCause()), submission);
        }
    }

    @Test(timeOut=5000L)
    public void testExceptionInScheduleWithFixedDelayRunnableIncludesSubmissionTrace() throws Exception {
        ListeningScheduledExecutorService sched = (ListeningScheduledExecutorService)this.injector.getInstance(Key.get(ListeningScheduledExecutorService.class, (Annotation)Names.named((String)"jclouds.scheduler-threads")));
        String submission = null;
        try {
            submission = Throwables.getStackTraceAsString((Throwable)ExecutorServiceModuleTest.incrementInitialElement(new RuntimeException(), 2)).replaceFirst(String.format(".*%s", LINE_SEPARATOR), "");
            sched.scheduleWithFixedDelay(ExecutorServiceModuleTest.runnableThrowsRTE(), 0L, 1L, TimeUnit.MICROSECONDS).get();
        }
        catch (ExecutionException e) {
            ExecutorServiceModuleTest.assertTraceHasSubmission(Throwables.getStackTraceAsString((Throwable)e), submission);
            ExecutorServiceModuleTest.assertTraceHasSubmission(Throwables.getStackTraceAsString((Throwable)e.getCause()), submission);
        }
    }
}

