/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import org.jclouds.http.Uris;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class UrisTest {
    private static final ImmutableMap<String, String> templateParams = ImmutableMap.of((Object)"user", (Object)"bob");

    public void testScheme() {
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").scheme("http").toString(), (String)"http://foo.com:8080");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").scheme("http").build().toString(), (String)"http://foo.com:8080");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").scheme("http").toString(), (String)"http://api.github.com/repos/user?foo=bar&kung=fu");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").scheme("http").build().toString(), (String)"http://api.github.com/repos/user?foo=bar&kung=fu");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").scheme("http").toString(), (String)"http://api.github.com/repos/{user}");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").scheme("http").build(templateParams).toASCIIString(), (String)"http://api.github.com/repos/bob");
    }

    public void testHost() {
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").host("robots").toString(), (String)"https://robots:8080");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").host("robots").build().toString(), (String)"https://robots:8080");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").host("robots").toString(), (String)"https://robots/repos/user?foo=bar&kung=fu");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").host("robots").build().toString(), (String)"https://robots/repos/user?foo=bar&kung=fu");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").host("robots").toString(), (String)"https://robots/repos/{user}");
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").host("robots").build(templateParams).toASCIIString(), (String)"https://robots/repos/bob");
    }

    @DataProvider(name="strings")
    public Object[][] createData() {
        return new Object[][]{{"normal"}, {"sp ace"}, {"qu?stion"}, {"unic\u20aade"}, {"path/foo"}, {"colon:"}, {"asteri*k"}, {"quote\""}, {"great<r"}, {"lesst>en"}, {"p|pe"}};
    }

    @Test(dataProvider="strings")
    public void testQuery(String val) {
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").addQuery("moo", new String[]{val}).toString(), (String)("https://foo.com:8080?moo=" + val));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").addQuery("moo", new String[]{val}).build().toString(), (String)("https://foo.com:8080?moo=" + Strings2.urlEncode((String)val, (char[])new char[]{'/', ','})));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").addQuery("moo", new String[]{val}).toString(), (String)("https://api.github.com/repos/user?foo=bar&kung=fu&moo=" + val));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").addQuery("moo", new String[]{val}).build().toString(), (String)("https://api.github.com/repos/user?foo=bar&kung=fu&moo=" + Strings2.urlEncode((String)val, (char[])new char[]{'/', ','})));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").addQuery("moo", new String[]{val}).toString(), (String)("https://api.github.com/repos/{user}?moo=" + val));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").addQuery("moo", new String[]{val}).build(templateParams).toASCIIString(), (String)("https://api.github.com/repos/bob?moo=" + Strings2.urlEncode((String)val, (char[])new char[]{'/', ','})));
    }

    @Test(dataProvider="strings")
    public void testPath(String path) {
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").path(path).toString(), (String)("https://foo.com:8080/" + path));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").path(path).build().toString(), (String)("https://foo.com:8080/" + Strings2.urlEncode((String)path, (char[])new char[]{'/', ':', ';', '='})));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").path(path).toString(), (String)("https://api.github.com/" + path + "?foo=bar&kung=fu"));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").path(path).build().toString(), (String)("https://api.github.com/" + Strings2.urlEncode((String)path, (char[])new char[]{'/', ':', ';', '='}) + "?foo=bar&kung=fu"));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").path(path).toString(), (String)("https://api.github.com/" + path));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").path(path).build(templateParams).toASCIIString(), (String)("https://api.github.com/" + Strings2.urlEncode((String)path, (char[])new char[]{'/', ':', ';', '='})));
    }

    @Test(dataProvider="strings")
    public void testAppendPath(String path) {
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").appendPath(path).toString(), (String)("https://foo.com:8080/" + path));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://foo.com:8080").appendPath(path).build().toString(), (String)("https://foo.com:8080/" + Strings2.urlEncode((String)path, (char[])new char[]{'/', ':', ';', '='})));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").appendPath(path).toString(), (String)("https://api.github.com/repos/user/" + path + "?foo=bar&kung=fu"));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/user?foo=bar&kung=fu").appendPath(path).build().toString(), (String)("https://api.github.com/repos/user/" + Strings2.urlEncode((String)path, (char[])new char[]{'/', ':', ';', '='}) + "?foo=bar&kung=fu"));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").appendPath(path).toString(), (String)("https://api.github.com/repos/{user}/" + path));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.github.com/repos/{user}").appendPath(path).build(templateParams).toASCIIString(), (String)("https://api.github.com/repos/bob/" + Strings2.urlEncode((String)path, (char[])new char[]{'/', ':', ';', '='})));
    }

    @Test
    public void testNoDoubleSlashInPath() {
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://cloud/api/").appendPath("/").build().toASCIIString(), (String)"https://cloud/api/");
    }

    @Test
    public void testWhenMatrixOnPath() {
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"https://api.rimuhosting.com/r").appendPath("orders;include_inactive=N").build(templateParams).toASCIIString(), (String)"https://api.rimuhosting.com/r/orders;include_inactive=N");
    }

    @Test(dataProvider="strings")
    public void testReplaceQueryIsEncoded(String key) {
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"/redirect").addQuery("foo", new String[]{key}).toString(), (String)("/redirect?foo=" + key));
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"/redirect").addQuery("foo", new String[]{key}).build().toString(), (String)("/redirect?foo=" + Strings2.urlEncode((String)key, (char[])new char[]{'/', ','})));
    }

    public void testAddQuery() {
        Assert.assertEquals((String)Uris.uriBuilder((CharSequence)"http://localhost:8080/client/api").addQuery("response", new String[]{"json"}).toString(), (String)"http://localhost:8080/client/api?response=json");
        Assert.assertEquals((String)Uris.uriBuilder((URI)URI.create("http://localhost:8080/client/api")).addQuery("response", new String[]{"json"}).addQuery("command", new String[]{"queryAsyncJobResult"}).build().toString(), (String)"http://localhost:8080/client/api?response=json&command=queryAsyncJobResult");
    }
}

