/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import java.net.URI;
import org.easymock.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseURIFromListOrLocationHeaderIf20x;
import org.jclouds.io.Payload;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseURIFromListOrLocationHeaderIf20xTest {
    @Test
    public void testExceptionWhenNoContentOn200() {
        Payload payload;
        HttpResponse response;
        block2: {
            ParseURIFromListOrLocationHeaderIf20x function = new ParseURIFromListOrLocationHeaderIf20x();
            response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
            payload = (Payload)EasyMock.createMock(Payload.class);
            EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
            EasyMock.expect((Object)response.getFirstHeaderOrNull("Content-Type")).andReturn((Object)"text/uri-list");
            EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
            EasyMock.expect((Object)payload.getInput()).andReturn(null);
            payload.release();
            EasyMock.replay((Object[])new Object[]{payload});
            EasyMock.replay((Object[])new Object[]{response});
            try {
                function.apply((Object)response);
            }
            catch (Exception e) {
                if ($assertionsDisabled || e.getMessage().equals("no content")) break block2;
                throw new AssertionError();
            }
        }
        EasyMock.verify((Object[])new Object[]{payload});
        EasyMock.verify((Object[])new Object[]{response});
    }

    @Test
    public void testExceptionWhenIOExceptionOn200() {
        Payload payload;
        HttpResponse response;
        block2: {
            ParseURIFromListOrLocationHeaderIf20x function = new ParseURIFromListOrLocationHeaderIf20x();
            response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
            payload = (Payload)EasyMock.createMock(Payload.class);
            EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
            EasyMock.expect((Object)response.getFirstHeaderOrNull("Content-Type")).andReturn((Object)"text/uri-list");
            RuntimeException exception = new RuntimeException("bad");
            EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
            EasyMock.expect((Object)payload.getInput()).andThrow((Throwable)exception);
            payload.release();
            EasyMock.replay((Object[])new Object[]{payload});
            EasyMock.replay((Object[])new Object[]{response});
            try {
                function.apply((Object)response);
            }
            catch (Exception e) {
                if ($assertionsDisabled || e.equals(exception)) break block2;
                throw new AssertionError();
            }
        }
        EasyMock.verify((Object[])new Object[]{payload});
        EasyMock.verify((Object[])new Object[]{response});
    }

    @Test
    public void testResponseOk() {
        ParseURIFromListOrLocationHeaderIf20x function = new ParseURIFromListOrLocationHeaderIf20x();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        Payload payload = (Payload)EasyMock.createMock(Payload.class);
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Content-Type")).andReturn((Object)"text/uri-list");
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
        EasyMock.expect((Object)payload.getInput()).andReturn((Object)Strings2.toInputStream((String)"http://locahost")).atLeastOnce();
        payload.release();
        EasyMock.replay((Object[])new Object[]{payload});
        EasyMock.replay((Object[])new Object[]{response});
        Assert.assertEquals((Object)function.apply((Object)response), (Object)URI.create("http://locahost"));
        EasyMock.verify((Object[])new Object[]{payload});
        EasyMock.verify((Object[])new Object[]{response});
    }

    @Test
    public void testResponseLocationOk() {
        ParseURIFromListOrLocationHeaderIf20x function = new ParseURIFromListOrLocationHeaderIf20x();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        Payload payload = (Payload)EasyMock.createMock(Payload.class);
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Content-Type")).andReturn((Object)"text/plain");
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Location")).andReturn((Object)"http://locahost");
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
        payload.release();
        EasyMock.replay((Object[])new Object[]{payload});
        EasyMock.replay((Object[])new Object[]{response});
        Assert.assertEquals((Object)function.apply((Object)response), (Object)URI.create("http://locahost"));
        EasyMock.verify((Object[])new Object[]{response});
        EasyMock.verify((Object[])new Object[]{payload});
    }

    @Test
    public void testResponseLowercaseLocationOk() {
        ParseURIFromListOrLocationHeaderIf20x function = new ParseURIFromListOrLocationHeaderIf20x();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        Payload payload = (Payload)EasyMock.createMock(Payload.class);
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Content-Type")).andReturn((Object)"text/plain");
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Location")).andReturn(null);
        EasyMock.expect((Object)response.getFirstHeaderOrNull("location")).andReturn((Object)"http://locahost");
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
        payload.release();
        EasyMock.replay((Object[])new Object[]{payload});
        EasyMock.replay((Object[])new Object[]{response});
        Assert.assertEquals((Object)function.apply((Object)response), (Object)URI.create("http://locahost"));
        EasyMock.verify((Object[])new Object[]{response});
        EasyMock.verify((Object[])new Object[]{payload});
    }

    @Test
    public void testResponsePathLocationOk() {
        ParseURIFromListOrLocationHeaderIf20x function = new ParseURIFromListOrLocationHeaderIf20x();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        Payload payload = (Payload)EasyMock.createMock(Payload.class);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://new/fd").build();
        function.setContext(request);
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Content-Type")).andReturn((Object)"text/plain");
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Location")).andReturn((Object)"path");
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
        payload.release();
        EasyMock.replay((Object[])new Object[]{payload});
        EasyMock.replay((Object[])new Object[]{response});
        Assert.assertEquals((Object)function.apply(response), (Object)URI.create("http://new/path"));
        EasyMock.verify((Object[])new Object[]{response});
        EasyMock.verify((Object[])new Object[]{payload});
    }

    @Test
    public void testResponsePathPortLocationOk() {
        ParseURIFromListOrLocationHeaderIf20x function = new ParseURIFromListOrLocationHeaderIf20x();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        Payload payload = (Payload)EasyMock.createMock(Payload.class);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://new:8080/fd").build();
        function.setContext(request);
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Content-Type")).andReturn((Object)"text/plain");
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Location")).andReturn((Object)"path");
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
        payload.release();
        EasyMock.replay((Object[])new Object[]{payload});
        EasyMock.replay((Object[])new Object[]{response});
        Assert.assertEquals((Object)function.apply(response), (Object)URI.create("http://new:8080/path"));
        EasyMock.verify((Object[])new Object[]{response});
        EasyMock.verify((Object[])new Object[]{payload});
    }

    @Test
    public void testResponsePathSchemeLocationOk() {
        ParseURIFromListOrLocationHeaderIf20x function = new ParseURIFromListOrLocationHeaderIf20x();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        Payload payload = (Payload)EasyMock.createMock(Payload.class);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("https://new/fd").build();
        function.setContext(request);
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)200).atLeastOnce();
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Content-Type")).andReturn((Object)"text/plain");
        EasyMock.expect((Object)response.getFirstHeaderOrNull("Location")).andReturn((Object)"path");
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)payload).atLeastOnce();
        payload.release();
        EasyMock.replay((Object[])new Object[]{payload});
        EasyMock.replay((Object[])new Object[]{response});
        Assert.assertEquals((Object)function.apply(response), (Object)URI.create("https://new/path"));
        EasyMock.verify((Object[])new Object[]{response});
        EasyMock.verify((Object[])new Object[]{payload});
    }
}

