/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import org.easymock.EasyMock;
import org.jclouds.ContextBuilder;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.http.handlers.RedirectionRetryHandler;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class RedirectionRetryHandlerTest {
    Injector injector = ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forApiOnEndpoint(IntegrationTestClient.class, (String)"http://localhost")).modules((Iterable)ImmutableSet.of((Object)((Object)new BaseRestApiTest.MockModule()))).buildInjector();

    @Test
    public void test302DoesNotRetry() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpResponse response = HttpResponse.builder().statusCode(302).message("HTTP/1.1 302 Found").build();
        EasyMock.expect((Object)command.isReplayable()).andReturn((Object)true);
        EasyMock.expect((Object)command.incrementRedirectCount()).andReturn((Object)0);
        EasyMock.replay((Object[])new Object[]{command});
        RedirectionRetryHandler retry = (RedirectionRetryHandler)this.injector.getInstance(RedirectionRetryHandler.class);
        assert (!retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
    }

    @Test
    public void test302DoesNotRetryAfterLimit() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(302).message("HTTP/1.1 302 Found").addHeader("Location", new String[]{"/api/v0.8b-ext2.5/Error.aspx?aspxerrorpath=/api/v0.8b-ext2.5/org.svc/1906645"})).build();
        EasyMock.expect((Object)command.isReplayable()).andReturn((Object)true);
        EasyMock.expect((Object)command.incrementRedirectCount()).andReturn((Object)6);
        EasyMock.replay((Object[])new Object[]{command});
        RedirectionRetryHandler retry = (RedirectionRetryHandler)this.injector.getInstance(RedirectionRetryHandler.class);
        assert (!retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
    }

    @Test
    public void test302WithPathOnlyHeader() {
        this.verifyRedirectRoutes(HttpRequest.builder().method("GET").endpoint("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(302).message("HTTP/1.1 302 Found").addHeader("Location", new String[]{"/api/v0.8b-ext2.5/Error.aspx?aspxerrorpath=/api/v0.8b-ext2.5/org.svc/1906645"})).build(), HttpRequest.builder().method("GET").endpoint("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/Error.aspx?aspxerrorpath=/api/v0.8b-ext2.5/org.svc/1906645").build());
    }

    @Test
    public void test302ToHttps() {
        this.verifyRedirectRoutes(HttpRequest.builder().method("GET").endpoint("http://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(302).message("HTTP/1.1 302 Found").addHeader("Location", new String[]{"https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645"})).build(), HttpRequest.builder().method("GET").endpoint("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645").build());
    }

    @Test
    public void test302ToDifferentPort() {
        this.verifyRedirectRoutes(HttpRequest.builder().method("GET").endpoint("http://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(302).message("HTTP/1.1 302 Found").addHeader("Location", new String[]{"http://services.enterprisecloud.terremark.com:3030/api/v0.8b-ext2.5/org/1906645"})).build(), HttpRequest.builder().method("GET").endpoint("http://services.enterprisecloud.terremark.com:3030/api/v0.8b-ext2.5/org/1906645").build());
    }

    @Test
    public void test302WithHeader() {
        this.verifyRedirectRoutes(HttpRequest.builder().method("GET").endpoint("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(302).message("HTTP/1.1 302 Found").addHeader("Location", new String[]{"https://services1.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645"})).build(), HttpRequest.builder().method("GET").endpoint("https://services1.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645").build());
    }

    @Test
    public void test302WithHeaderReplacesHostHeader() {
        this.verifyRedirectRoutes(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645").addHeader("Host", new String[]{"services.enterprisecloud.terremark.com"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(302).message("HTTP/1.1 302 Found").addHeader("Location", new String[]{"https://services1.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645"})).build(), ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://services1.enterprisecloud.terremark.com/api/v0.8b-ext2.5/org/1906645").addHeader("Host", new String[]{"services1.enterprisecloud.terremark.com"})).build());
    }

    protected void verifyRedirectRoutes(HttpRequest request, HttpResponse response, HttpRequest expected) {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        EasyMock.expect((Object)command.isReplayable()).andReturn((Object)true);
        EasyMock.expect((Object)command.incrementRedirectCount()).andReturn((Object)0);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request);
        command.setCurrentRequest(expected);
        EasyMock.replay((Object[])new Object[]{command});
        RedirectionRetryHandler retry = (RedirectionRetryHandler)this.injector.getInstance(RedirectionRetryHandler.class);
        assert (retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
    }
}

