/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.rest.internal.BaseHttpApiMetadata;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BaseHttpCommandExecutorServiceTest")
public class BaseHttpCommandExecutorServiceTest {
    public void testStreamIsClosedWhenRetrying() throws IOException {
        MockInputStream in = new MockInputStream(2);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload((Payload)Payloads.newInputStreamPayload((InputStream)in))).build();
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(1L));
        HttpCommand command = this.mockHttpCommand();
        DelegatingRetryHandler retryHandler = (DelegatingRetryHandler)EasyMock.createMock(DelegatingRetryHandler.class);
        DelegatingErrorHandler errorHandler = (DelegatingErrorHandler)EasyMock.createMock(DelegatingErrorHandler.class);
        EasyMock.expect((Object)retryHandler.shouldRetryRequest(command, response)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{retryHandler, errorHandler});
        Assert.assertEquals((int)response.getPayload().openStream().available(), (int)2);
        Assert.assertEquals((int)response.getPayload().openStream().read(), (int)1);
        BaseHttpCommandExecutorService<?> service = this.mockHttpCommandExecutorService(retryHandler, errorHandler);
        Assert.assertTrue((boolean)service.shouldContinue(command, response));
        EasyMock.verify((Object[])new Object[]{retryHandler, errorHandler});
        Assert.assertFalse((boolean)in.isOpen);
        Assert.assertTrue((response.getPayload().openStream() == in ? 1 : 0) != 0);
        Assert.assertEquals((int)response.getPayload().openStream().available(), (int)0);
        Assert.assertEquals((int)response.getPayload().openStream().read(), (int)-1);
    }

    public void testStreamIsClosedWhenNotRetrying() throws IOException {
        MockInputStream in = new MockInputStream(2);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload((Payload)Payloads.newInputStreamPayload((InputStream)in))).build();
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(1L));
        HttpCommand command = this.mockHttpCommand();
        DelegatingRetryHandler retryHandler = (DelegatingRetryHandler)EasyMock.createMock(DelegatingRetryHandler.class);
        DelegatingErrorHandler errorHandler = (DelegatingErrorHandler)EasyMock.createMock(DelegatingErrorHandler.class);
        errorHandler.handleError(command, response);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)retryHandler.shouldRetryRequest(command, response)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{retryHandler, errorHandler});
        Assert.assertEquals((int)response.getPayload().openStream().available(), (int)2);
        Assert.assertEquals((int)response.getPayload().openStream().read(), (int)1);
        BaseHttpCommandExecutorService<?> service = this.mockHttpCommandExecutorService(retryHandler, errorHandler);
        Assert.assertFalse((boolean)service.shouldContinue(command, response));
        EasyMock.verify((Object[])new Object[]{retryHandler, errorHandler});
        Assert.assertFalse((boolean)in.isOpen);
        Assert.assertTrue((response.getPayload().openStream() == in ? 1 : 0) != 0);
        Assert.assertEquals((int)response.getPayload().openStream().available(), (int)0);
        Assert.assertEquals((int)response.getPayload().openStream().read(), (int)-1);
    }

    public void testStreamIsClosedAndBufferedInTheErrorHandlerWhenNotRetrying() throws IOException {
        MockInputStream in = new MockInputStream(2);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload((Payload)Payloads.newInputStreamPayload((InputStream)in))).build();
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(1L));
        HttpCommand command = this.mockHttpCommand();
        DelegatingRetryHandler retryHandler = (DelegatingRetryHandler)EasyMock.createMock(DelegatingRetryHandler.class);
        DelegatingErrorHandler errorHandler = (DelegatingErrorHandler)EasyMock.createMock(DelegatingErrorHandler.class);
        errorHandler.handleError(command, response);
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Void>(){

            public Void answer() throws Throwable {
                HttpResponse response = (HttpResponse)EasyMock.getCurrentArguments()[1];
                HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
                return null;
            }
        });
        EasyMock.expect((Object)retryHandler.shouldRetryRequest(command, response)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{retryHandler, errorHandler});
        Assert.assertEquals((int)response.getPayload().openStream().available(), (int)2);
        Assert.assertEquals((int)response.getPayload().openStream().read(), (int)1);
        BaseHttpCommandExecutorService<?> service = this.mockHttpCommandExecutorService(retryHandler, errorHandler);
        Assert.assertFalse((boolean)service.shouldContinue(command, response));
        EasyMock.verify((Object[])new Object[]{retryHandler, errorHandler});
        Assert.assertFalse((boolean)in.isOpen);
        Assert.assertEquals((int)in.available(), (int)0);
        Assert.assertEquals((int)in.read(), (int)-1);
        Assert.assertTrue((boolean)response.getPayload().isRepeatable());
        Assert.assertEquals((int)response.getPayload().openStream().available(), (int)1);
        Assert.assertEquals((int)response.getPayload().openStream().read(), (int)0);
    }

    public void testCloseStreamCanBeCalledMoreThanOnce() throws IOException {
        MockInputStream in = new MockInputStream(2);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().payload((Payload)Payloads.newInputStreamPayload((InputStream)in))).build();
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(1L));
        HttpCommand command = this.mockHttpCommand();
        DelegatingRetryHandler retryHandler = (DelegatingRetryHandler)EasyMock.createMock(DelegatingRetryHandler.class);
        DelegatingErrorHandler errorHandler = (DelegatingErrorHandler)EasyMock.createMock(DelegatingErrorHandler.class);
        errorHandler.handleError(command, response);
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Void>(){

            public Void answer() throws Throwable {
                HttpResponse response = (HttpResponse)EasyMock.getCurrentArguments()[1];
                HttpUtils.releasePayload((HttpMessage)response);
                return null;
            }
        });
        EasyMock.expect((Object)retryHandler.shouldRetryRequest(command, response)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{retryHandler, errorHandler});
        Assert.assertEquals((int)response.getPayload().openStream().available(), (int)2);
        Assert.assertEquals((int)response.getPayload().openStream().read(), (int)1);
        BaseHttpCommandExecutorService<?> service = this.mockHttpCommandExecutorService(retryHandler, errorHandler);
        Assert.assertFalse((boolean)service.shouldContinue(command, response));
        EasyMock.verify((Object[])new Object[]{retryHandler, errorHandler});
        Assert.assertFalse((boolean)in.isOpen);
        Assert.assertEquals((int)in.closeCount, (int)2);
        Assert.assertTrue((response.getPayload().openStream() == in ? 1 : 0) != 0);
        Assert.assertEquals((int)response.getPayload().openStream().available(), (int)0);
        Assert.assertEquals((int)response.getPayload().openStream().read(), (int)-1);
    }

    private HttpCommand mockHttpCommand() {
        return new HttpCommand(HttpRequest.builder().endpoint("http://localhost").method("mock").build());
    }

    private BaseHttpCommandExecutorService<?> mockHttpCommandExecutorService(final DelegatingRetryHandler retryHandler, final DelegatingErrorHandler errorHandler) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)BaseHttpApiMetadata.defaultProperties());
                this.bind(DelegatingRetryHandler.class).toInstance((Object)retryHandler);
                this.bind(DelegatingErrorHandler.class).toInstance((Object)errorHandler);
                this.bind(BaseHttpCommandExecutorService.class).to(MockHttpCommandExecutorService.class);
            }
        }});
        return (BaseHttpCommandExecutorService)injector.getInstance(BaseHttpCommandExecutorService.class);
    }

    private static class MockHttpCommandExecutorService
    extends BaseHttpCommandExecutorService<Object> {
        @Inject
        MockHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire) {
            super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire);
        }

        protected Object convert(HttpRequest request) throws IOException, InterruptedException {
            return null;
        }

        protected HttpResponse invoke(Object nativeRequest) throws IOException, InterruptedException {
            return null;
        }

        protected void cleanup(Object nativeRequest) {
        }
    }

    private static class MockInputStream
    extends InputStream {
        boolean isOpen = true;
        int count;
        int closeCount = 0;

        public MockInputStream(int count) {
            this.count = count;
        }

        @Override
        public void close() throws IOException {
            ++this.closeCount;
            if (!this.isOpen) {
                throw new IOException("The stream is already closed");
            }
            this.isOpen = false;
        }

        @Override
        public int read() throws IOException {
            if (this.isOpen) {
                return this.count > 0 ? (this.count = this.count - 1) : -1;
            }
            return -1;
        }

        @Override
        public int available() throws IOException {
            if (this.isOpen) {
                return this.count;
            }
            return 0;
        }
    }
}

