/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.net.Proxy;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.http.internal.JavaUrlHttpCommandExecutorService;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class TrackingJavaUrlHttpCommandExecutorService
extends JavaUrlHttpCommandExecutorService {
    private final List<HttpCommand> commandsInvoked;

    public static Module newTrackingModule(final List<HttpCommand> commandsInvoked) {
        return new AbstractModule(){

            protected void configure() {
                this.bind(JavaUrlHttpCommandExecutorService.class).to(TrackingJavaUrlHttpCommandExecutorService.class);
                this.bind((TypeLiteral)new TypeLiteral<List<HttpCommand>>(){}).toInstance((Object)commandsInvoked);
            }
        };
    }

    public static Invokable<?, ?> getInvokerOfRequestAtIndex(Collection<HttpCommand> commandsInvoked, int index) {
        return TrackingJavaUrlHttpCommandExecutorService.getInvokerOfRequest((HttpCommand)Iterables.get(commandsInvoked, (int)index));
    }

    public static Invokable<?, ?> getInvokerOfRequest(HttpCommand commandInvoked) {
        return ((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(commandInvoked.getCurrentRequest())).getInvocation().getInvokable();
    }

    public static List<Object> getArgsForRequestAtIndex(Collection<HttpCommand> commandsInvoked, int index) {
        return ((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(((HttpCommand)Iterables.get(commandsInvoked, (int)index)).getCurrentRequest())).getInvocation().getArgs();
    }

    @Inject
    public TrackingJavaUrlHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, Function<URI, Proxy> proxyForURI, List<HttpCommand> commandsInvoked) throws SecurityException, NoSuchFieldException {
        super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire, verifier, untrustedSSLContextProvider, proxyForURI);
        this.commandsInvoked = commandsInvoked;
    }

    public HttpResponse invoke(HttpCommand command) {
        this.commandsInvoked.add(command);
        return super.invoke(command);
    }
}

