/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.internal;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jclouds.io.Payload;
import org.jclouds.io.internal.BasePayloadSlicer;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class BasePayloadSlicerTest {
    @Test
    public void testIterableSliceExpectedSingle() throws IOException {
        BasePayloadSlicer slicer = new BasePayloadSlicer();
        String contents = "aaaaaaaaaabbbbbbbbbbccccc";
        InputStreamPayload payload = new InputStreamPayload((InputStream)new ByteArrayInputStream(contents.getBytes(Charsets.US_ASCII)));
        Iterator iter = slicer.slice((Payload)payload, 25L).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((Payload)iter.next()).openStream()), (String)contents);
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterableSliceExpectedMulti() throws IOException {
        BasePayloadSlicer slicer = new BasePayloadSlicer();
        InputStreamPayload payload = new InputStreamPayload((InputStream)new ByteArrayInputStream("aaaaaaaaaabbbbbbbbbbccccc".getBytes(Charsets.US_ASCII)));
        Iterator iter = slicer.slice((Payload)payload, 10L).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((Payload)iter.next()).getInput()), (String)"aaaaaaaaaa");
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((Payload)iter.next()).getInput()), (String)"bbbbbbbbbb");
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((Payload)iter.next()).getInput()), (String)"ccccc");
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterableSliceWithRepeatingByteSourceSmallerPartSize() throws IOException {
        BasePayloadSlicer slicer = new BasePayloadSlicer();
        ByteSource byteSource = ByteSource.wrap((byte[])"aaaaaaaaaabbbbbbbbbbccccc".getBytes(Charsets.UTF_8));
        ByteSourcePayload payload = new ByteSourcePayload(byteSource);
        Iterator iter = slicer.slice((Payload)payload, 10L).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Payload part = (Payload)iter.next();
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)part.getInput()), (String)"aaaaaaaaaa");
        Assert.assertEquals((Object)part.getContentMetadata().getContentLength(), (Object)10L);
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        part = (Payload)iter.next();
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)part.getInput()), (String)"bbbbbbbbbb");
        Assert.assertEquals((Object)part.getContentMetadata().getContentLength(), (Object)10L);
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        part = (Payload)iter.next();
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)part.getInput()), (String)"ccccc");
        Assert.assertEquals((Object)part.getContentMetadata().getContentLength(), (Object)5L);
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIterableSliceWithRepeatingByteSourceLargerPartSize() throws IOException {
        BasePayloadSlicer slicer = new BasePayloadSlicer();
        ByteSource byteSource = ByteSource.wrap((byte[])"aaaaaaaaaabbbbbbbbbbccccc".getBytes(Charsets.UTF_8));
        ByteSourcePayload payload = new ByteSourcePayload(byteSource);
        Iterator iter = slicer.slice((Payload)payload, 50L).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"Not enough results");
        Payload part = (Payload)iter.next();
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)part.getInput()), (String)"aaaaaaaaaabbbbbbbbbbccccc");
        Assert.assertEquals((Object)part.getContentMetadata().getContentLength(), (Object)25L);
        Assert.assertFalse((boolean)iter.hasNext());
    }
}

