/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.AutoValue_JsonTest_NestedSerializedNamesType;
import org.jclouds.json.AutoValue_JsonTest_SerializedNamesTooFewType;
import org.jclouds.json.AutoValue_JsonTest_SerializedNamesType;
import org.jclouds.json.Json;
import org.jclouds.json.SerializedNames;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class JsonTest {
    private Json json = (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class);
    private final NestedSerializedNamesType nested = NestedSerializedNamesType.access$500(SerializedNamesType.access$300("1234", Collections.emptyMap()), Arrays.asList(SerializedNamesType.access$300("5678", (Map)ImmutableMap.of((Object)"Foo", (Object)"Bar"))));

    public void testObjectNoDefaultConstructor() {
        ObjectNoDefaultConstructor obj = new ObjectNoDefaultConstructor("foo", 1);
        Assert.assertEquals((String)this.json.toJson((Object)obj), (String)"{\"stringValue\":\"foo\",\"intValue\":1}");
        ObjectNoDefaultConstructor obj2 = (ObjectNoDefaultConstructor)this.json.fromJson(this.json.toJson((Object)obj), ObjectNoDefaultConstructor.class);
        Assert.assertEquals((Object)obj2, (Object)obj);
        Assert.assertEquals((String)this.json.toJson((Object)obj2), (String)this.json.toJson((Object)obj));
    }

    public void testExcluder() {
        Json excluder = (Json)Guice.createInjector((Module[])new Module[]{new GsonModule(), new AbstractModule(){

            protected void configure() {
                this.bind(GsonModule.DefaultExclusionStrategy.class).to(ExcludeStringValue.class);
            }
        }}).getInstance(Json.class);
        ObjectNoDefaultConstructor obj = new ObjectNoDefaultConstructor("foo", 1);
        Assert.assertEquals((String)excluder.toJson((Object)obj), (String)"{\"intValue\":1}");
    }

    public void testByteList() {
        ByteList bl = new ByteList();
        bl.checksum = Bytes.asList((byte[])BaseEncoding.base16().lowerCase().decode((CharSequence)"1dda05ed139664f1f89b9dec482b77c0"));
        Assert.assertEquals((String)this.json.toJson((Object)bl), (String)"{\"checksum\":\"1dda05ed139664f1f89b9dec482b77c0\"}");
        Assert.assertEquals(((ByteList)this.json.fromJson((String)this.json.toJson((Object)bl), ByteList.class)).checksum, bl.checksum);
    }

    public void testPropertiesSerializesDefaults() {
        Properties props = new Properties();
        props.put("string", "string");
        props.put("number", "1");
        props.put("boolean", "true");
        Assert.assertEquals((String)this.json.toJson((Object)props), (String)"{\"string\":\"string\",\"boolean\":\"true\",\"number\":\"1\"}");
        Properties props3 = new Properties(props);
        Assert.assertEquals((String)this.json.toJson((Object)props3), (String)"{\"string\":\"string\",\"boolean\":\"true\",\"number\":\"1\"}");
        Properties props2 = (Properties)this.json.fromJson(this.json.toJson((Object)props), Properties.class);
        Assert.assertEquals((Map)props2, (Map)props);
        Assert.assertEquals((String)this.json.toJson((Object)props2), (String)this.json.toJson((Object)props));
    }

    public void testMapStringObjectWithAllValidValuesOneDeep() {
        ImmutableMap map = ImmutableMap.builder().put((Object)"string", (Object)"string").put((Object)"map", (Object)ImmutableMap.of((Object)"key", (Object)"value")).put((Object)"list", (Object)ImmutableList.of((Object)"key", (Object)"value")).put((Object)"boolean", (Object)true).put((Object)"number", (Object)1.0).build();
        Assert.assertEquals((String)this.json.toJson((Object)map), (String)"{\"string\":\"string\",\"map\":{\"key\":\"value\"},\"list\":[\"key\",\"value\"],\"boolean\":true,\"number\":1.0}");
        Map map2 = (Map)this.json.fromJson(this.json.toJson((Object)map), new TypeLiteral<Map<String, Object>>(){}.getType());
        Assert.assertEquals((Map)map2, (Map)map);
        Assert.assertEquals((String)this.json.toJson((Object)map2), (String)this.json.toJson((Object)map));
    }

    public void testMapStringObjectWithNumericalKeysConvertToStrings() {
        ImmutableMap map = ImmutableMap.of((Object)"map", (Object)ImmutableMap.of((Object)1, (Object)"value"));
        Assert.assertEquals((String)this.json.toJson((Object)map), (String)"{\"map\":{\"1\":\"value\"}}");
        Map map2 = (Map)this.json.fromJson(this.json.toJson((Object)map), new TypeLiteral<Map<String, Object>>(){}.getType());
        Assert.assertEquals((Map)map2, (Map)ImmutableMap.of((Object)"map", (Object)ImmutableMap.of((Object)"1", (Object)"value")));
        Assert.assertEquals((String)this.json.toJson((Object)map2), (String)this.json.toJson((Object)map));
    }

    public void testMapStringObjectWithBooleanKeysConvertToStrings() {
        ImmutableMap map = ImmutableMap.of((Object)"map", (Object)ImmutableMap.of((Object)true, (Object)"value"));
        Assert.assertEquals((String)this.json.toJson((Object)map), (String)"{\"map\":{\"true\":\"value\"}}");
        Map map2 = (Map)this.json.fromJson(this.json.toJson((Object)map), new TypeLiteral<Map<String, Object>>(){}.getType());
        Assert.assertEquals((Map)map2, (Map)ImmutableMap.of((Object)"map", (Object)ImmutableMap.of((Object)"true", (Object)"value")));
        Assert.assertEquals((String)this.json.toJson((Object)map2), (String)this.json.toJson((Object)map));
    }

    public void testDeserializeEnum() {
        Assert.assertEquals((Object)((Object)((EnumInside)this.json.fromJson("{enumValue : \"FOO\"}", EnumInside.class)).enumValue), (Object)((Object)EnumInside.Test.FOO));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDeserializeEnumWhenBadValue() {
        Assert.assertEquals((Object)((Object)((EnumInside)this.json.fromJson("{enumValue : \"s\"}", EnumInside.class)).enumValue), (Object)((Object)EnumInside.Test.FOO));
    }

    public void testDeserializeEnumWithParser() {
        Assert.assertEquals((Object)((Object)((EnumInsideWithParser)this.json.fromJson("{enumValue : \"FOO\"}", EnumInsideWithParser.class)).enumValue), (Object)((Object)EnumInsideWithParser.Test.FOO));
    }

    public void testDeserializeEnumWithParserAndBadValue() {
        Assert.assertEquals((Object)((Object)((EnumInsideWithParser)this.json.fromJson("{enumValue : \"sd\"}", EnumInsideWithParser.class)).enumValue), (Object)((Object)EnumInsideWithParser.Test.UNRECOGNIZED));
    }

    public void autoValueSerializedNames() {
        Json json = (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class);
        SerializedNamesType resource = SerializedNamesType.create("1234", Collections.emptyMap());
        String spinalJson = "{\"Id\":\"1234\",\"Volumes\":{}}";
        Assert.assertEquals((String)json.toJson((Object)resource), (String)spinalJson);
        Assert.assertEquals((Object)json.fromJson(spinalJson, SerializedNamesType.class), (Object)resource);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Incorrect number .*")
    public void autoValueSerializedNames_tooFew() {
        Json json = (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class);
        json.toJson((Object)SerializedNamesTooFewType.create("1234", null));
    }

    public void autoValueSerializedNames_nullValueInJson() {
        Json json = (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class);
        Assert.assertEquals((Object)json.fromJson("{\"Id\":\"1234\",\"Volumes\":null}", SerializedNamesType.class), (Object)SerializedNamesType.create("1234", null));
    }

    public void autoValueSerializedNames_nestedType() {
        Json json = (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class);
        String spinalJson = "{\"Item\":{\"Id\":\"1234\",\"Volumes\":{}},\"Items\":[{\"Id\":\"5678\",\"Volumes\":{\"Foo\":\"Bar\"}}]}";
        Assert.assertEquals((String)json.toJson((Object)this.nested), (String)spinalJson);
        Assert.assertEquals((Object)json.fromJson(spinalJson, NestedSerializedNamesType.class), (Object)this.nested);
    }

    public void autoValueSerializedNames_overriddenTypeAdapterFactory() {
        Json json = (Json)Guice.createInjector((Module[])new Module[]{new GsonModule(), new AbstractModule(){

            protected void configure() {
            }

            @Provides
            public Set<TypeAdapterFactory> typeAdapterFactories() {
                return ImmutableSet.of((Object)((Object)new NestedSerializedNamesTypeAdapterFactory()));
            }
        }}).getInstance(Json.class);
        Assert.assertEquals((String)json.toJson((Object)this.nested), (String)"{\"id\":\"1234\",\"count\":1}");
        Assert.assertEquals((Object)json.fromJson("{\"id\":\"1234\",\"count\":1}", NestedSerializedNamesType.class), (Object)this.nested);
    }

    private class NestedSerializedNamesTypeAdapterFactory
    extends TypeAdapter<NestedSerializedNamesType>
    implements TypeAdapterFactory {
        private NestedSerializedNamesTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!NestedSerializedNamesType.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return this;
        }

        public void write(JsonWriter out, NestedSerializedNamesType value) throws IOException {
            out.beginObject();
            out.name("id").value(value.item().id());
            out.name("count").value((long)value.items().size());
            out.endObject();
        }

        public NestedSerializedNamesType read(JsonReader in) throws IOException {
            in.beginObject();
            in.nextName();
            in.nextString();
            in.nextName();
            in.nextInt();
            in.endObject();
            return JsonTest.this.nested;
        }
    }

    static abstract class NestedSerializedNamesType {
        NestedSerializedNamesType() {
        }

        abstract SerializedNamesType item();

        abstract List<SerializedNamesType> items();

        @SerializedNames(value={"Item", "Items"})
        private static NestedSerializedNamesType create(SerializedNamesType item, List<SerializedNamesType> items) {
            return new AutoValue_JsonTest_NestedSerializedNamesType(item, items);
        }

        static /* synthetic */ NestedSerializedNamesType access$500(SerializedNamesType x0, List x1) {
            return NestedSerializedNamesType.create(x0, x1);
        }
    }

    static abstract class SerializedNamesTooFewType {
        SerializedNamesTooFewType() {
        }

        abstract String id();

        @Nullable
        abstract Map<String, String> volumes();

        @SerializedNames(value={"Id"})
        private static SerializedNamesTooFewType create(String id, Map<String, String> volumes) {
            return new AutoValue_JsonTest_SerializedNamesTooFewType(id, volumes);
        }
    }

    static abstract class SerializedNamesType {
        SerializedNamesType() {
        }

        abstract String id();

        @Nullable
        abstract Map<String, String> volumes();

        @SerializedNames(value={"Id", "Volumes"})
        private static SerializedNamesType create(String id, Map<String, String> volumes) {
            return new AutoValue_JsonTest_SerializedNamesType(id, volumes);
        }
    }

    private static class EnumInsideWithParser {
        private Test enumValue;

        private EnumInsideWithParser() {
        }

        private static enum Test {
            FOO,
            BAR,
            UNRECOGNIZED;


            public static Test fromValue(String state) {
                try {
                    return Test.valueOf(state);
                }
                catch (IllegalArgumentException e) {
                    return UNRECOGNIZED;
                }
            }
        }
    }

    private static class ByteList {
        List<Byte> checksum;

        private ByteList() {
        }
    }

    private static class EnumInside {
        private Test enumValue;

        private EnumInside() {
        }

        private static enum Test {
            FOO,
            BAR;

        }
    }

    static class ExcludeStringValue
    implements GsonModule.DefaultExclusionStrategy {
        ExcludeStringValue() {
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getName().equals("stringValue");
        }
    }

    private static class ObjectNoDefaultConstructor {
        private final String stringValue;
        private final int intValue;

        public ObjectNoDefaultConstructor(String stringValue, int intValue) {
            this.stringValue = stringValue;
            this.intValue = intValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.intValue;
            result = 31 * result + (this.stringValue == null ? 0 : this.stringValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ObjectNoDefaultConstructor other = (ObjectNoDefaultConstructor)obj;
            if (this.intValue != other.intValue) {
                return false;
            }
            return !(this.stringValue == null ? other.stringValue != null : !this.stringValue.equals(other.stringValue));
        }
    }
}

