/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.derived;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jclouds.location.suppliers.derived.ZoneIdToURIFromJoinOnRegionIdToURI;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class ZoneIdToURIFromJoinOnRegionIdToURITest {
    public void zoneToRegionMappingsValid() {
        LinkedHashMap regionIdToURIs = Maps.newLinkedHashMap();
        regionIdToURIs.put("us-east-1", Suppliers.ofInstance((Object)URI.create("ec2.us-east-1.amazonaws.com")));
        regionIdToURIs.put("eu-central-1", Suppliers.ofInstance((Object)URI.create("ec2.eu-central-1.amazonaws.com")));
        LinkedHashMap regionIdToZoneIds = Maps.newLinkedHashMap();
        regionIdToZoneIds.put("us-east-1", ZoneIdToURIFromJoinOnRegionIdToURITest.supplyZoneIds("us-east-1a", "us-east-1b"));
        regionIdToZoneIds.put("eu-central-1", ZoneIdToURIFromJoinOnRegionIdToURITest.supplyZoneIds("eu-central-1a"));
        Map result = new ZoneIdToURIFromJoinOnRegionIdToURI(Suppliers.ofInstance((Object)regionIdToURIs), Suppliers.ofInstance((Object)regionIdToZoneIds)).get();
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals(result.get("us-east-1a"), regionIdToURIs.get("us-east-1"));
        Assert.assertEquals(result.get("us-east-1b"), regionIdToURIs.get("us-east-1"));
        Assert.assertEquals(result.get("eu-central-1a"), regionIdToURIs.get("eu-central-1"));
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="region eu-central-1 is not in the configured region to zone mappings: .*")
    public void zoneToRegionMappingsInconsistentOnKeys() {
        LinkedHashMap regionIdToURIs = Maps.newLinkedHashMap();
        regionIdToURIs.put("us-east-1", Suppliers.ofInstance((Object)URI.create("ec2.us-east-1.amazonaws.com")));
        regionIdToURIs.put("eu-central-1", Suppliers.ofInstance((Object)URI.create("ec2.eu-central-1.amazonaws.com")));
        LinkedHashMap regionIdToZoneIds = Maps.newLinkedHashMap();
        regionIdToZoneIds.put("us-east-1", ZoneIdToURIFromJoinOnRegionIdToURITest.supplyZoneIds("us-east-1a", "us-east-1b"));
        new ZoneIdToURIFromJoinOnRegionIdToURI(Suppliers.ofInstance((Object)regionIdToURIs), Suppliers.ofInstance((Object)regionIdToZoneIds)).get();
    }

    private static Supplier<Set<String>> supplyZoneIds(String ... zoneIds) {
        return Suppliers.ofInstance((Object)ImmutableSet.copyOf((Object[])zoneIds));
    }
}

