/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.jclouds.reflect.Reflection2;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class Reflection2CoreJavaClassesTest {
    private SecurityManager originalSecurityManager;
    private boolean securityManagerOverridden = false;

    @BeforeClass
    public void backupSecurityManager() {
        this.originalSecurityManager = System.getSecurityManager();
    }

    public void testCoreJavaMethodsNotMadeAccessible(final Method testMethod) {
        SecurityManager mockSecurityManager = (SecurityManager)EasyMock.createNiceMock(SecurityManager.class);
        mockSecurityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
        EasyMock.expectLastCall().andStubAnswer((IAnswer)new IAnswer<Void>(){

            public Void answer() throws Throwable {
                try {
                    throw new Exception();
                }
                catch (Exception exception) {
                    for (StackTraceElement element : exception.getStackTrace()) {
                        if (element.getMethodName().equals(testMethod.getName())) {
                            throw new AssertionError((Object)"checkPermission(new ReflectPermission(\"suppressAccessChecks\")) should not be called");
                        }
                    }
                    return null;
                }
            }
        });
        EasyMock.replay((Object[])new Object[]{mockSecurityManager});
        System.setSecurityManager(mockSecurityManager);
        this.securityManagerOverridden = true;
        Reflection2.methods(Enum.class);
    }

    @AfterClass(alwaysRun=true)
    public void restoreSecurityManager() {
        if (this.securityManagerOverridden) {
            System.setSecurityManager(this.originalSecurityManager);
        }
    }
}

