/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.inject.Injector;
import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import org.jclouds.ContextBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.predicates.validators.AllLowerCaseValidator;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.InputParamValidator;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.TestException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class InputParamValidatorTest {
    Injector injector;
    Function<Invocation, HttpRequest> restAnnotationProcessor;

    @Test
    public void testInputParamsValidation() throws Exception {
        Invokable allParamsValidatedMethod = Reflection2.method(InputParamValidatorForm.class, (String)"allParamsValidated", (Class[])new Class[]{String.class, String.class});
        Invokable oneParamValidatedMethod = Reflection2.method(InputParamValidatorForm.class, (String)"oneParamValidated", (Class[])new Class[]{String.class, String.class});
        this.restAnnotationProcessor.apply((Object)Invocation.create((Invokable)allParamsValidatedMethod, (List)ImmutableList.of((Object)"blah", (Object)"blah")));
        this.restAnnotationProcessor.apply((Object)Invocation.create((Invokable)oneParamValidatedMethod, (List)ImmutableList.of((Object)"blah", (Object)"blah")));
        try {
            this.restAnnotationProcessor.apply((Object)Invocation.create((Invokable)allParamsValidatedMethod, (List)ImmutableList.of((Object)"BLAH", (Object)"blah")));
            throw new TestException("AllLowerCaseValidator shouldn't have passed 'BLAH' as a parameter because it's uppercase.");
        }
        catch (IllegalArgumentException e) {
            this.restAnnotationProcessor.apply((Object)Invocation.create((Invokable)oneParamValidatedMethod, (List)ImmutableList.of((Object)"BLAH", (Object)"blah")));
            try {
                this.restAnnotationProcessor.apply((Object)Invocation.create((Invokable)oneParamValidatedMethod, (List)ImmutableList.of((Object)"blah", (Object)"BLAH")));
                throw new TestException("AllLowerCaseValidator shouldn't have passed 'BLAH' as the second parameter because it's uppercase.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
    }

    @Test
    public void testNullParametersForAllLowerCaseValidator() {
        new AllLowerCaseValidator().validate(null);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void testWrongPredicateTypeLiteral() throws Exception {
        Invocation invocation = Invocation.create((Invokable)Reflection2.method(WrongValidator.class, (String)"method", (Class[])new Class[]{Integer.class}), (List)ImmutableList.of((Object)55));
        new InputParamValidator(this.injector).validateMethodParametersOrThrow(invocation, (List)invocation.getInvokable().getParameters());
    }

    @BeforeClass
    void setupFactory() {
        this.injector = ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forApiOnEndpoint(IntegrationTestClient.class, (String)"http://localhost:9999")).buildInjector();
        this.restAnnotationProcessor = (Function)this.injector.getInstance(RestAnnotationProcessor.class);
    }

    private static interface WrongValidator {
        @POST
        @ParamValidators(value={AllLowerCaseValidator.class})
        public void method(@PathParam(value="param1") Integer var1);
    }

    private static interface InputParamValidatorForm {
        @POST
        @ParamValidators(value={AllLowerCaseValidator.class})
        public void allParamsValidated(@PathParam(value="param1") String var1, @PathParam(value="param2") String var2);

        @POST
        public void oneParamValidated(@PathParam(value="param1") String var1, @ParamValidators(value={AllLowerCaseValidator.class}) @PathParam(value="param2") String var2);
    }
}

